/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.DescribeRuntimeConfigurationRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeRuntimeConfigurationRequestMarshaller
implements Marshaller<Request<DescribeRuntimeConfigurationRequest>, DescribeRuntimeConfigurationRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeRuntimeConfigurationRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeRuntimeConfigurationRequest> marshall(DescribeRuntimeConfigurationRequest describeRuntimeConfigurationRequest) {
        if (describeRuntimeConfigurationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeRuntimeConfigurationRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.DescribeRuntimeConfiguration");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeRuntimeConfigurationRequest.getFleetId() != null) {
                jsonGenerator.writeFieldName("FleetId").writeValue(describeRuntimeConfigurationRequest.getFleetId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

