/*
 * Copyright 2011-2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not
 * use this file except in compliance with the License. A copy of the License is
 * located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.amazonaws.services.redshift.model;

import java.io.Serializable;

/**
 * <p>
 * Describes the default cluster parameters for a parameter group family.
 * </p>
 */
public class DefaultClusterParameters implements Serializable, Cloneable {

    /**
     * <p>
     * The name of the cluster parameter group family to which the engine
     * default parameters apply.
     * </p>
     */
    private String parameterGroupFamily;
    /**
     * <p>
     * A value that indicates the starting point for the next set of response
     * records in a subsequent request. If a value is returned in a response,
     * you can retrieve the next set of records by providing this returned
     * marker value in the <code>Marker</code> parameter and retrying the
     * command. If the <code>Marker</code> field is empty, all response records
     * have been retrieved for the request.
     * </p>
     */
    private String marker;
    /**
     * <p>
     * The list of cluster default parameters.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<Parameter> parameters;

    /**
     * <p>
     * The name of the cluster parameter group family to which the engine
     * default parameters apply.
     * </p>
     * 
     * @param parameterGroupFamily
     *        The name of the cluster parameter group family to which the engine
     *        default parameters apply.
     */

    public void setParameterGroupFamily(String parameterGroupFamily) {
        this.parameterGroupFamily = parameterGroupFamily;
    }

    /**
     * <p>
     * The name of the cluster parameter group family to which the engine
     * default parameters apply.
     * </p>
     * 
     * @return The name of the cluster parameter group family to which the
     *         engine default parameters apply.
     */

    public String getParameterGroupFamily() {
        return this.parameterGroupFamily;
    }

    /**
     * <p>
     * The name of the cluster parameter group family to which the engine
     * default parameters apply.
     * </p>
     * 
     * @param parameterGroupFamily
     *        The name of the cluster parameter group family to which the engine
     *        default parameters apply.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public DefaultClusterParameters withParameterGroupFamily(
            String parameterGroupFamily) {
        setParameterGroupFamily(parameterGroupFamily);
        return this;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response
     * records in a subsequent request. If a value is returned in a response,
     * you can retrieve the next set of records by providing this returned
     * marker value in the <code>Marker</code> parameter and retrying the
     * command. If the <code>Marker</code> field is empty, all response records
     * have been retrieved for the request.
     * </p>
     * 
     * @param marker
     *        A value that indicates the starting point for the next set of
     *        response records in a subsequent request. If a value is returned
     *        in a response, you can retrieve the next set of records by
     *        providing this returned marker value in the <code>Marker</code>
     *        parameter and retrying the command. If the <code>Marker</code>
     *        field is empty, all response records have been retrieved for the
     *        request.
     */

    public void setMarker(String marker) {
        this.marker = marker;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response
     * records in a subsequent request. If a value is returned in a response,
     * you can retrieve the next set of records by providing this returned
     * marker value in the <code>Marker</code> parameter and retrying the
     * command. If the <code>Marker</code> field is empty, all response records
     * have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of
     *         response records in a subsequent request. If a value is returned
     *         in a response, you can retrieve the next set of records by
     *         providing this returned marker value in the <code>Marker</code>
     *         parameter and retrying the command. If the <code>Marker</code>
     *         field is empty, all response records have been retrieved for the
     *         request.
     */

    public String getMarker() {
        return this.marker;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response
     * records in a subsequent request. If a value is returned in a response,
     * you can retrieve the next set of records by providing this returned
     * marker value in the <code>Marker</code> parameter and retrying the
     * command. If the <code>Marker</code> field is empty, all response records
     * have been retrieved for the request.
     * </p>
     * 
     * @param marker
     *        A value that indicates the starting point for the next set of
     *        response records in a subsequent request. If a value is returned
     *        in a response, you can retrieve the next set of records by
     *        providing this returned marker value in the <code>Marker</code>
     *        parameter and retrying the command. If the <code>Marker</code>
     *        field is empty, all response records have been retrieved for the
     *        request.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public DefaultClusterParameters withMarker(String marker) {
        setMarker(marker);
        return this;
    }

    /**
     * <p>
     * The list of cluster default parameters.
     * </p>
     * 
     * @return The list of cluster default parameters.
     */

    public java.util.List<Parameter> getParameters() {
        if (parameters == null) {
            parameters = new com.amazonaws.internal.SdkInternalList<Parameter>();
        }
        return parameters;
    }

    /**
     * <p>
     * The list of cluster default parameters.
     * </p>
     * 
     * @param parameters
     *        The list of cluster default parameters.
     */

    public void setParameters(java.util.Collection<Parameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }

        this.parameters = new com.amazonaws.internal.SdkInternalList<Parameter>(
                parameters);
    }

    /**
     * <p>
     * The list of cluster default parameters.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if
     * any). Use {@link #setParameters(java.util.Collection)} or
     * {@link #withParameters(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param parameters
     *        The list of cluster default parameters.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public DefaultClusterParameters withParameters(Parameter... parameters) {
        if (this.parameters == null) {
            setParameters(new com.amazonaws.internal.SdkInternalList<Parameter>(
                    parameters.length));
        }
        for (Parameter ele : parameters) {
            this.parameters.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The list of cluster default parameters.
     * </p>
     * 
     * @param parameters
     *        The list of cluster default parameters.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public DefaultClusterParameters withParameters(
            java.util.Collection<Parameter> parameters) {
        setParameters(parameters);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getParameterGroupFamily() != null)
            sb.append("ParameterGroupFamily: " + getParameterGroupFamily()
                    + ",");
        if (getMarker() != null)
            sb.append("Marker: " + getMarker() + ",");
        if (getParameters() != null)
            sb.append("Parameters: " + getParameters());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DefaultClusterParameters == false)
            return false;
        DefaultClusterParameters other = (DefaultClusterParameters) obj;
        if (other.getParameterGroupFamily() == null
                ^ this.getParameterGroupFamily() == null)
            return false;
        if (other.getParameterGroupFamily() != null
                && other.getParameterGroupFamily().equals(
                        this.getParameterGroupFamily()) == false)
            return false;
        if (other.getMarker() == null ^ this.getMarker() == null)
            return false;
        if (other.getMarker() != null
                && other.getMarker().equals(this.getMarker()) == false)
            return false;
        if (other.getParameters() == null ^ this.getParameters() == null)
            return false;
        if (other.getParameters() != null
                && other.getParameters().equals(this.getParameters()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime
                * hashCode
                + ((getParameterGroupFamily() == null) ? 0
                        : getParameterGroupFamily().hashCode());
        hashCode = prime * hashCode
                + ((getMarker() == null) ? 0 : getMarker().hashCode());
        hashCode = prime * hashCode
                + ((getParameters() == null) ? 0 : getParameters().hashCode());
        return hashCode;
    }

    @Override
    public DefaultClusterParameters clone() {
        try {
            return (DefaultClusterParameters) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException(
                    "Got a CloneNotSupportedException from Object.clone() "
                            + "even though we're Cloneable!", e);
        }
    }
}
