/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow;

import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.DataConverterException;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;

public class JsonDataConverter
extends DataConverter {
    protected final ObjectMapper mapper;

    public JsonDataConverter() {
        this(new ObjectMapper());
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.mapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
    }

    public JsonDataConverter(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public String toData(Object value) throws DataConverterException {
        try {
            return this.mapper.writeValueAsString(value);
        }
        catch (JsonGenerationException e) {
            this.throwDataConverterException(e, value);
        }
        catch (JsonMappingException e) {
            this.throwDataConverterException(e, value);
        }
        catch (IOException e) {
            this.throwDataConverterException(e, value);
        }
        throw new IllegalStateException("not reachable");
    }

    private void throwDataConverterException(Throwable e, Object value) {
        if (value == null) {
            throw new DataConverterException("Failure serializing null value", e);
        }
        throw new DataConverterException("Failure serializing \"" + value + "\" of type \"" + value.getClass() + "\"", e);
    }

    @Override
    public <T> T fromData(String serialized, Class<T> valueType) throws DataConverterException {
        try {
            return (T)this.mapper.readValue(serialized, valueType);
        }
        catch (JsonParseException e) {
            throw new DataConverterException(e);
        }
        catch (JsonMappingException e) {
            throw new DataConverterException(e);
        }
        catch (IOException e) {
            throw new DataConverterException(e);
        }
    }
}

