/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.workspaces.model.WorkspaceBundle;
import com.amazonaws.services.workspaces.model.transform.ComputeTypeJsonMarshaller;
import com.amazonaws.services.workspaces.model.transform.UserStorageJsonMarshaller;

public class WorkspaceBundleJsonMarshaller {
    private static WorkspaceBundleJsonMarshaller instance;

    public void marshall(WorkspaceBundle workspaceBundle, StructuredJsonGenerator jsonGenerator) {
        if (workspaceBundle == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (workspaceBundle.getBundleId() != null) {
                jsonGenerator.writeFieldName("BundleId").writeValue(workspaceBundle.getBundleId());
            }
            if (workspaceBundle.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(workspaceBundle.getName());
            }
            if (workspaceBundle.getOwner() != null) {
                jsonGenerator.writeFieldName("Owner").writeValue(workspaceBundle.getOwner());
            }
            if (workspaceBundle.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(workspaceBundle.getDescription());
            }
            if (workspaceBundle.getUserStorage() != null) {
                jsonGenerator.writeFieldName("UserStorage");
                UserStorageJsonMarshaller.getInstance().marshall(workspaceBundle.getUserStorage(), jsonGenerator);
            }
            if (workspaceBundle.getComputeType() != null) {
                jsonGenerator.writeFieldName("ComputeType");
                ComputeTypeJsonMarshaller.getInstance().marshall(workspaceBundle.getComputeType(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static WorkspaceBundleJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new WorkspaceBundleJsonMarshaller();
        }
        return instance;
    }
}

