/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.play_billing;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import com.android.billingclient.api.AcknowledgePurchaseParams;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ConsumeParams;
import com.android.billingclient.api.InAppMessageResult;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.QueryProductDetailsParams;
import com.android.billingclient.api.zzbx;
import com.google.android.gms.internal.play_billing.zza;
import com.google.android.gms.internal.play_billing.zzm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONException;

public final class zzb {
    public static final int zza = Runtime.getRuntime().availableProcessors();

    private static int zzq(Bundle bundle, String string) {
        if (bundle == null) {
            zzb.zzo(string, "Unexpected null bundle received!");
            return 0;
        }
        return bundle.getInt("IN_APP_MESSAGE_RESPONSE_CODE", 0);
    }

    public static int zza(Intent intent, String string) {
        string = "ProxyBillingActivity";
        if (intent == null) {
            zzb.zzo(string, "Got null intent!");
            return 0;
        }
        return zzb.zzq(intent.getExtras(), string);
    }

    public static int zzb(Bundle object, String string) {
        if (object == null) {
            zzb.zzo(string, "Unexpected null bundle received!");
            return 6;
        }
        if ((object = object.get("RESPONSE_CODE")) == null) {
            zzb.zzn(string, "getResponseCodeFromBundle() got null response code, assuming OK");
            return 0;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        object = String.valueOf(object.getClass().getName());
        zzb.zzo(string, "Unexpected type for bundle response code: ".concat((String)object));
        return 6;
    }

    public static Bundle zzc(AcknowledgePurchaseParams acknowledgePurchaseParams, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("playBillingLibraryVersion", string);
        return bundle;
    }

    public static Bundle zzd(ConsumeParams consumeParams, boolean bl, String string) {
        consumeParams = new Bundle();
        if (bl) {
            consumeParams.putString("playBillingLibraryVersion", string);
        }
        return consumeParams;
    }

    public static Bundle zze(int n, boolean bl, String string, @Nullable String string2, ArrayList arrayList) {
        string2 = new Bundle();
        if (n >= 9) {
            string2.putString("playBillingLibraryVersion", string);
        }
        if (n >= 9 && bl) {
            string2.putBoolean("enablePendingPurchases", true);
        }
        if (n >= 14) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
            int n2 = arrayList.size();
            bl = false;
            boolean bl2 = false;
            for (n = 0; n < n2; ++n) {
                zzbx cfr_ignored_0 = (zzbx)arrayList.get(n);
                arrayList2.add(null);
                bl |= TextUtils.isEmpty(null) ^ true;
                arrayList3.add(null);
                boolean bl3 = bl2 | TextUtils.isEmpty(null) ^ true;
                arrayList4.add(0);
                bl2 = bl3;
            }
            if (bl) {
                string2.putStringArrayList("SKU_OFFER_ID_TOKEN_LIST", arrayList2);
            }
            if (bl2) {
                string2.putStringArrayList("SKU_OFFER_ID_LIST", arrayList3);
            }
        }
        return string2;
    }

    public static Bundle zzf(BillingFlowParams object, boolean bl, boolean bl2, boolean bl3, String arrayList) {
        Bundle bundle = new Bundle();
        bundle.putString("playBillingLibraryVersion", (String)((Object)arrayList));
        if (((BillingFlowParams)object).zza() != 0) {
            int n = ((BillingFlowParams)object).zza();
            bundle.putInt("prorationMode", n);
        }
        if (!TextUtils.isEmpty((CharSequence)((BillingFlowParams)object).zzb())) {
            arrayList = ((BillingFlowParams)object).zzb();
            bundle.putString("accountId", (String)((Object)arrayList));
        }
        if (!TextUtils.isEmpty((CharSequence)((BillingFlowParams)object).zzc())) {
            arrayList = ((BillingFlowParams)object).zzc();
            bundle.putString("obfuscatedProfileId", (String)((Object)arrayList));
        }
        if (((BillingFlowParams)object).zzn()) {
            bundle.putBoolean("isOfferPersonalizedByDeveloper", true);
        }
        if (!TextUtils.isEmpty(null)) {
            arrayList = new ArrayList<String>(Arrays.asList(new String[]{null}));
            bundle.putStringArrayList("skusToReplace", arrayList);
        }
        if (!TextUtils.isEmpty((CharSequence)((BillingFlowParams)object).zzd())) {
            object = ((BillingFlowParams)object).zzd();
            bundle.putString("oldSkuPurchaseToken", (String)object);
        }
        if (!TextUtils.isEmpty(null)) {
            bundle.putString("oldSkuPurchaseId", null);
        }
        if (!TextUtils.isEmpty(null)) {
            bundle.putString("originalExternalTransactionId", null);
        }
        if (!TextUtils.isEmpty(null)) {
            bundle.putString("paymentsPurchaseParams", null);
        }
        if (bl && bl2) {
            bundle.putBoolean("enablePendingPurchases", true);
        }
        if (bl3) {
            bundle.putBoolean("enableAlternativeBilling", true);
        }
        return bundle;
    }

    public static Bundle zzg(String string, ArrayList arrayList, @Nullable String string2) {
        Bundle bundle = new Bundle();
        bundle.putString("playBillingLibraryVersion", string);
        bundle.putBoolean("enablePendingPurchases", true);
        bundle.putString("SKU_DETAILS_RESPONSE_FORMAT", "PRODUCT_DETAILS");
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList arrayList3 = new ArrayList();
        int n = arrayList.size();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            QueryProductDetailsParams.Product product = (QueryProductDetailsParams.Product)arrayList.get(i);
            arrayList2.add(null);
            bl |= TextUtils.isEmpty(null) ^ true;
            if (!product.zzb().equals("first_party")) continue;
            zzm.zzc(null, "Serialized DocId is required for constructing ExtraParams to query ProductDetails for all first party products.");
            arrayList3.add(null);
        }
        if (bl) {
            bundle.putStringArrayList("SKU_OFFER_ID_TOKEN_LIST", arrayList2);
        }
        if (!arrayList3.isEmpty()) {
            bundle.putStringArrayList("SKU_SERIALIZED_DOCID_LIST", arrayList3);
        }
        return bundle;
    }

    public static Bundle zzh(boolean bl, boolean bl2, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("playBillingLibraryVersion", string);
        if (bl && bl2) {
            bundle.putBoolean("enablePendingPurchases", true);
        }
        return bundle;
    }

    public static BillingResult zzi(Intent intent, String string) {
        if (intent == null) {
            zzb.zzo("BillingHelper", "Got null intent!");
            BillingResult.Builder builder = BillingResult.newBuilder();
            builder.setResponseCode(6);
            builder.setDebugMessage("An internal error occurred.");
            return builder.build();
        }
        BillingResult.Builder builder = BillingResult.newBuilder();
        builder.setResponseCode(zzb.zzb(intent.getExtras(), string));
        builder.setDebugMessage(zzb.zzk(intent.getExtras(), string));
        return builder.build();
    }

    public static InAppMessageResult zzj(Bundle bundle, String string) {
        if (bundle == null) {
            return new InAppMessageResult(0, null);
        }
        return new InAppMessageResult(zzb.zzq(bundle, "BillingClient"), bundle.getString("IN_APP_MESSAGE_PURCHASE_TOKEN"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static Purchase zzr(String object, String string) {
        if (object == null || string == null) {
            zzb.zzn("BillingHelper", "Received a null purchase data.");
            return null;
        }
        try {
            Purchase purchase = new Purchase((String)object, string);
            return purchase;
        }
        catch (JSONException jSONException) {
            object = "Got JSONException while parsing purchase data: ".concat(((Object)((Object)jSONException)).toString());
            zzb.zzo("BillingHelper", (String)object);
            return null;
        }
    }

    public static String zzk(Bundle object, String string) {
        String string2 = "";
        if (object == null) {
            zzb.zzo(string, "Unexpected null bundle received!");
            return string2;
        }
        if ((object = object.get("DEBUG_MESSAGE")) == null) {
            zzb.zzn(string, "getDebugMessageFromBundle() got null response code, assuming OK");
            return string2;
        }
        if (object instanceof String) {
            return (String)object;
        }
        object = String.valueOf(object.getClass().getName());
        zzb.zzo(string, "Unexpected type for debug message: ".concat((String)object));
        return string2;
    }

    public static String zzl(int n) {
        return com.google.android.gms.internal.play_billing.zza.zza(n).toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    public static List zzm(Bundle object) {
        Object object2 = object;
        ArrayList arrayList = object2.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
        ArrayList arrayList2 = object2.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
        ArrayList<Purchase> arrayList3 = new ArrayList<Purchase>();
        if (arrayList == null || arrayList2 == null) {
            Purchase purchase = zzb.zzr(object.getString("INAPP_PURCHASE_DATA"), object.getString("INAPP_DATA_SIGNATURE"));
            if (purchase == null) {
                zzb.zzn("BillingHelper", "Couldn't find single purchase data as well.");
                return null;
            }
            arrayList3.add(purchase);
            return arrayList3;
        } else {
            void var0_4;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Found purchase list of ");
            stringBuilder.append(arrayList.size());
            stringBuilder.append(" items");
            String string = stringBuilder.toString();
            zzb.zzn("BillingHelper", string);
            boolean bl = false;
            while (var0_4 < arrayList.size() && var0_4 < arrayList2.size()) {
                Purchase purchase = zzb.zzr((String)arrayList.get((int)var0_4), (String)arrayList2.get((int)var0_4));
                if (purchase != null) {
                    arrayList3.add(purchase);
                }
                ++var0_4;
            }
        }
        return arrayList3;
    }

    public static void zzn(String string, String string2) {
        if (Log.isLoggable((String)string, (int)2)) {
            if (!string2.isEmpty()) {
                int n;
                for (int i = 40000; !string2.isEmpty() && i > 0; i -= n) {
                    n = Math.min(string2.length(), Math.min(4000, i));
                    Log.v((String)string, (String)string2.substring(0, n));
                    string2 = string2.substring(n);
                }
            } else {
                Log.v((String)string, (String)string2);
                return;
            }
        }
    }

    public static void zzo(String string, String string2) {
        if (Log.isLoggable((String)string, (int)5)) {
            Log.w((String)string, (String)string2);
            return;
        }
    }

    public static void zzp(String string, String string2, Throwable throwable) {
        if (Log.isLoggable((String)string, (int)5)) {
            Log.w((String)string, (String)string2, (Throwable)throwable);
            return;
        }
    }
}

