/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.android.billingclient.api.AcknowledgePurchaseParams;
import com.android.billingclient.api.AcknowledgePurchaseResponseListener;
import com.android.billingclient.api.AlternativeBillingOnlyAvailabilityListener;
import com.android.billingclient.api.AlternativeBillingOnlyInformationDialogListener;
import com.android.billingclient.api.AlternativeBillingOnlyReportingDetailsListener;
import com.android.billingclient.api.BillingClientImpl;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingConfigResponseListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ConsumeParams;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.ExternalOfferAvailabilityListener;
import com.android.billingclient.api.ExternalOfferInformationDialogListener;
import com.android.billingclient.api.ExternalOfferReportingDetailsListener;
import com.android.billingclient.api.GetBillingConfigParams;
import com.android.billingclient.api.InAppMessageParams;
import com.android.billingclient.api.InAppMessageResponseListener;
import com.android.billingclient.api.PendingPurchasesParams;
import com.android.billingclient.api.ProductDetailsResponseListener;
import com.android.billingclient.api.PurchaseHistoryResponseListener;
import com.android.billingclient.api.PurchasesResponseListener;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.QueryProductDetailsParams;
import com.android.billingclient.api.QueryPurchaseHistoryParams;
import com.android.billingclient.api.QueryPurchasesParams;
import com.android.billingclient.api.SkuDetailsParams;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.android.billingclient.api.UserChoiceBillingListener;
import com.android.billingclient.api.zzc;
import com.android.billingclient.api.zzcc;
import com.android.billingclient.api.zzck;
import com.android.billingclient.api.zzg;
import com.android.billingclient.api.zzh;
import com.android.billingclient.api.zzi;
import com.android.billingclient.api.zzk;
import com.android.billingclient.api.zzl;
import com.android.billingclient.api.zzp;
import com.google.android.gms.common.annotation.KeepForSdk;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.ExecutorService;

public abstract class BillingClient {
    @AnyThread
    public abstract int getConnectionState();

    @AnyThread
    @NonNull
    public static Builder newBuilder(@NonNull Context context) {
        Context context2;
        return new Builder(context2, null);
    }

    @AnyThread
    @NonNull
    public abstract BillingResult isFeatureSupported(@NonNull String var1);

    @UiThread
    @NonNull
    public abstract BillingResult launchBillingFlow(@NonNull Activity var1, @NonNull BillingFlowParams var2);

    @zzg
    @UiThread
    @NonNull
    public abstract BillingResult showAlternativeBillingOnlyInformationDialog(@NonNull Activity var1, @NonNull AlternativeBillingOnlyInformationDialogListener var2);

    @zzh
    @UiThread
    @NonNull
    public abstract BillingResult showExternalOfferInformationDialog(@NonNull Activity var1, @NonNull ExternalOfferInformationDialogListener var2);

    @UiThread
    @NonNull
    public abstract BillingResult showInAppMessages(@NonNull Activity var1, @NonNull InAppMessageParams var2, @NonNull InAppMessageResponseListener var3);

    @AnyThread
    public abstract void acknowledgePurchase(@NonNull AcknowledgePurchaseParams var1, @NonNull AcknowledgePurchaseResponseListener var2);

    @AnyThread
    public abstract void consumeAsync(@NonNull ConsumeParams var1, @NonNull ConsumeResponseListener var2);

    @zzg
    @AnyThread
    @KeepForSdk
    public abstract void createAlternativeBillingOnlyReportingDetailsAsync(@NonNull AlternativeBillingOnlyReportingDetailsListener var1);

    @AnyThread
    @zzh
    public abstract void createExternalOfferReportingDetailsAsync(@NonNull ExternalOfferReportingDetailsListener var1);

    @AnyThread
    public abstract void endConnection();

    @zzi
    @AnyThread
    public abstract void getBillingConfigAsync(@NonNull GetBillingConfigParams var1, @NonNull BillingConfigResponseListener var2);

    @zzg
    @AnyThread
    @KeepForSdk
    public abstract void isAlternativeBillingOnlyAvailableAsync(@NonNull AlternativeBillingOnlyAvailabilityListener var1);

    @AnyThread
    @zzh
    public abstract void isExternalOfferAvailableAsync(@NonNull ExternalOfferAvailabilityListener var1);

    @AnyThread
    public abstract void queryProductDetailsAsync(@NonNull QueryProductDetailsParams var1, @NonNull ProductDetailsResponseListener var2);

    @Deprecated
    @AnyThread
    public abstract void queryPurchaseHistoryAsync(@NonNull QueryPurchaseHistoryParams var1, @NonNull PurchaseHistoryResponseListener var2);

    @Deprecated
    @AnyThread
    public abstract void queryPurchaseHistoryAsync(@NonNull String var1, @NonNull PurchaseHistoryResponseListener var2);

    @AnyThread
    public abstract void queryPurchasesAsync(@NonNull QueryPurchasesParams var1, @NonNull PurchasesResponseListener var2);

    @Deprecated
    @AnyThread
    public abstract void queryPurchasesAsync(@NonNull String var1, @NonNull PurchasesResponseListener var2);

    @Deprecated
    @AnyThread
    public abstract void querySkuDetailsAsync(@NonNull SkuDetailsParams var1, @NonNull SkuDetailsResponseListener var2);

    @AnyThread
    public abstract void startConnection(@NonNull BillingClientStateListener var1);

    @AnyThread
    public abstract boolean isReady();

    @AnyThread
    public static final class Builder {
        private volatile String zza;
        private volatile PendingPurchasesParams zzb;
        private final Context zzc;
        private volatile PurchasesUpdatedListener zzd;
        private volatile zzck zze;
        private volatile zzcc zzf;
        private volatile zzc zzg;
        private volatile UserChoiceBillingListener zzh;
        @Nullable
        private volatile ExecutorService zzi;
        private volatile boolean zzj;
        private volatile boolean zzk;
        private volatile boolean zzl;

        @zzg
        @NonNull
        public Builder enableAlternativeBillingOnly() {
            this.zzj = true;
            return this;
        }

        @zzh
        @NonNull
        public Builder enableExternalOffer() {
            this.zzk = true;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder enablePendingPurchases() {
            PendingPurchasesParams.Builder builder = PendingPurchasesParams.newBuilder();
            builder.enableOneTimeProducts();
            this.enablePendingPurchases(builder.build());
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @zzk
        @NonNull
        public Builder enablePendingPurchases(@NonNull PendingPurchasesParams pendingPurchasesParams) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @zzl
        @NonNull
        public Builder enableUserChoiceBilling(@NonNull UserChoiceBillingListener userChoiceBillingListener) {
            void var1_1;
            this.zzh = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setListener(@NonNull PurchasesUpdatedListener listener) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public BillingClient build() {
            if (this.zzc == null) {
                throw new IllegalArgumentException("Please provide a valid Context.");
            }
            if (this.zzd != null) {
            }
            if (this.zzd == null) {
                if (this.zzh != null) {
                    throw new IllegalArgumentException("Please provide a valid listener for Google Play Billing purchases updates when enabling User Choice Billing.");
                }
                if (this.zzj) return new BillingClientImpl(null, this.zzc, null, null);
                if (!this.zzk) throw new IllegalArgumentException("Please provide a valid listener for purchases updates.");
                return new BillingClientImpl(null, this.zzc, null, null);
            }
            if (this.zzb == null) throw new IllegalArgumentException("Pending purchases for one-time products must be supported.");
            if (!this.zzb.isEnabledForOneTimeProducts()) {
                throw new IllegalArgumentException("Pending purchases for one-time products must be supported.");
            }
            if (this.zzd == null) return new BillingClientImpl(null, this.zzb, this.zzc, null, null, null);
            if (this.zzh != null) return new BillingClientImpl(null, this.zzb, this.zzc, this.zzd, this.zzh, null, null);
            return new BillingClientImpl(null, this.zzb, this.zzc, this.zzd, null, null, null);
        }

        /* synthetic */ Builder(Context context, zzp zzp2) {
            this.zzc = context;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectionState {
        public static final int DISCONNECTED = 0;
        public static final int CONNECTING = 1;
        public static final int CONNECTED = 2;
        public static final int CLOSED = 3;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BillingResponseCode {
        @Deprecated
        public static final int SERVICE_TIMEOUT = -3;
        public static final int FEATURE_NOT_SUPPORTED = -2;
        public static final int SERVICE_DISCONNECTED = -1;
        public static final int OK = 0;
        public static final int USER_CANCELED = 1;
        public static final int SERVICE_UNAVAILABLE = 2;
        public static final int BILLING_UNAVAILABLE = 3;
        public static final int ITEM_UNAVAILABLE = 4;
        public static final int DEVELOPER_ERROR = 5;
        public static final int ERROR = 6;
        public static final int ITEM_ALREADY_OWNED = 7;
        public static final int ITEM_NOT_OWNED = 8;
        public static final int NETWORK_ERROR = 12;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FeatureType {
        @NonNull
        public static final String SUBSCRIPTIONS = "subscriptions";
        @NonNull
        public static final String SUBSCRIPTIONS_UPDATE = "subscriptionsUpdate";
        @NonNull
        public static final String PRICE_CHANGE_CONFIRMATION = "priceChangeConfirmation";
        @NonNull
        public static final String IN_APP_MESSAGING = "bbb";
        @NonNull
        public static final String PRODUCT_DETAILS = "fff";
        @zzi
        @NonNull
        public static final String BILLING_CONFIG = "ggg";
        @zzg
        @NonNull
        public static final String ALTERNATIVE_BILLING_ONLY = "jjj";
        @zzh
        @NonNull
        public static final String EXTERNAL_OFFER = "kkk";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProductType {
        @NonNull
        public static final String INAPP = "inapp";
        @NonNull
        public static final String SUBS = "subs";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Deprecated
    public static @interface SkuType {
        @NonNull
        public static final String INAPP = "inapp";
        @NonNull
        public static final String SUBS = "subs";
    }
}

