/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.play_billing;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.Nullable;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.InAppMessageResult;
import com.android.billingclient.api.Purchase;
import com.google.android.gms.internal.play_billing.zza;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;

public final class zzb {
    public static final int zza = Runtime.getRuntime().availableProcessors();

    private static int zzm(Bundle bundle, String string) {
        if (bundle == null) {
            zzb.zzk(string, "Unexpected null bundle received!");
            return 0;
        }
        return bundle.getInt("IN_APP_MESSAGE_RESPONSE_CODE", 0);
    }

    public static int zza(Intent intent, String string) {
        string = "ProxyBillingActivity";
        if (intent == null) {
            zzb.zzk(string, "Got null intent!");
            return 0;
        }
        return zzb.zzm(intent.getExtras(), string);
    }

    public static int zzb(Bundle object, String string) {
        if (object == null) {
            zzb.zzk(string, "Unexpected null bundle received!");
            return 6;
        }
        if ((object = object.get("RESPONSE_CODE")) == null) {
            zzb.zzj(string, "getResponseCodeFromBundle() got null response code, assuming OK");
            return 0;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        object = String.valueOf(object.getClass().getName());
        zzb.zzk(string, "Unexpected type for bundle response code: ".concat((String)object));
        return 6;
    }

    public static Bundle zzc(boolean bl, boolean bl2, boolean bl3, boolean bl4, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("playBillingLibraryVersion", string);
        if (bl && bl3) {
            bundle.putBoolean("enablePendingPurchases", true);
        }
        if (bl2 && bl4) {
            bundle.putBoolean("enablePendingPurchaseForSubscriptions", true);
        }
        return bundle;
    }

    public static Bundle zzd(String string) {
        Bundle bundle = new Bundle();
        bundle.putString("playBillingLibraryVersion", string);
        return bundle;
    }

    public static BillingResult zze(Intent intent, String string) {
        if (intent == null) {
            zzb.zzk("BillingHelper", "Got null intent!");
            BillingResult.Builder builder = BillingResult.newBuilder();
            builder.setResponseCode(6);
            builder.setDebugMessage("An internal error occurred.");
            return builder.build();
        }
        BillingResult.Builder builder = BillingResult.newBuilder();
        builder.setResponseCode(zzb.zzb(intent.getExtras(), string));
        builder.setDebugMessage(zzb.zzg(intent.getExtras(), string));
        return builder.build();
    }

    public static InAppMessageResult zzf(Bundle bundle, String string) {
        if (bundle == null) {
            return new InAppMessageResult(0, null);
        }
        return new InAppMessageResult(zzb.zzm(bundle, "BillingClient"), bundle.getString("IN_APP_MESSAGE_PURCHASE_TOKEN"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static Purchase zzn(String object, String string) {
        if (object == null || string == null) {
            zzb.zzj("BillingHelper", "Received a null purchase data.");
            return null;
        }
        try {
            Purchase purchase = new Purchase((String)object, string);
            return purchase;
        }
        catch (JSONException jSONException) {
            object = "Got JSONException while parsing purchase data: ".concat(((Object)((Object)jSONException)).toString());
            zzb.zzk("BillingHelper", (String)object);
            return null;
        }
    }

    public static String zzg(Bundle object, String string) {
        String string2 = "";
        if (object == null) {
            zzb.zzk(string, "Unexpected null bundle received!");
            return string2;
        }
        if ((object = object.get("DEBUG_MESSAGE")) == null) {
            zzb.zzj(string, "getDebugMessageFromBundle() got null response code, assuming OK");
            return string2;
        }
        if (object instanceof String) {
            return (String)object;
        }
        object = String.valueOf(object.getClass().getName());
        zzb.zzk(string, "Unexpected type for debug message: ".concat((String)object));
        return string2;
    }

    public static String zzh(int n) {
        return com.google.android.gms.internal.play_billing.zza.zza(n).toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    public static List zzi(Bundle object) {
        Object object2 = object;
        ArrayList arrayList = object2.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
        ArrayList arrayList2 = object2.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
        ArrayList<Purchase> arrayList3 = new ArrayList<Purchase>();
        if (arrayList == null || arrayList2 == null) {
            Purchase purchase = zzb.zzn(object.getString("INAPP_PURCHASE_DATA"), object.getString("INAPP_DATA_SIGNATURE"));
            if (purchase == null) {
                zzb.zzj("BillingHelper", "Couldn't find single purchase data as well.");
                return null;
            }
            arrayList3.add(purchase);
            return arrayList3;
        } else {
            void var0_4;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Found purchase list of ");
            stringBuilder.append(arrayList.size());
            stringBuilder.append(" items");
            String string = stringBuilder.toString();
            zzb.zzj("BillingHelper", string);
            boolean bl = false;
            while (var0_4 < arrayList.size() && var0_4 < arrayList2.size()) {
                Purchase purchase = zzb.zzn((String)arrayList.get((int)var0_4), (String)arrayList2.get((int)var0_4));
                if (purchase != null) {
                    arrayList3.add(purchase);
                }
                ++var0_4;
            }
        }
        return arrayList3;
    }

    public static void zzj(String string, String string2) {
        if (Log.isLoggable((String)string, (int)2)) {
            if (!string2.isEmpty()) {
                int n;
                for (int i = 40000; !string2.isEmpty() && i > 0; i -= n) {
                    n = Math.min(string2.length(), Math.min(4000, i));
                    Log.v((String)string, (String)string2.substring(0, n));
                    string2 = string2.substring(n);
                }
            } else {
                Log.v((String)string, (String)string2);
                return;
            }
        }
    }

    public static void zzk(String string, String string2) {
        if (Log.isLoggable((String)string, (int)5)) {
            Log.w((String)string, (String)string2);
            return;
        }
    }

    public static void zzl(String string, String string2, Throwable throwable) {
        if (Log.isLoggable((String)string, (int)5)) {
            Log.w((String)string, (String)string2, (Throwable)throwable);
            return;
        }
    }
}

