/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ProductDetails;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.zzcd;
import com.android.billingclient.api.zzce;
import com.android.billingclient.api.zzcf;
import com.android.billingclient.api.zzcj;
import com.android.billingclient.api.zze;
import com.google.android.gms.internal.play_billing.zzbe;
import com.google.android.gms.internal.play_billing.zzco;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class BillingFlowParams {
    @NonNull
    public static final String EXTRA_PARAM_KEY_ACCOUNT_ID = "accountId";
    private boolean zza;
    private String zzb;
    private String zzc;
    private SubscriptionUpdateParams zzd;
    private zzco zze;
    private ArrayList zzf;
    private boolean zzg;

    @NonNull
    public static Builder newBuilder() {
        return new Builder(null);
    }

    private BillingFlowParams() {
        throw null;
    }

    public final int zza() {
        return this.zzd.zza();
    }

    final BillingResult zzb() {
        Object object;
        if (this.zze.isEmpty()) {
            return zzcj.zzl;
        }
        ProductDetailsParams productDetailsParams = (ProductDetailsParams)this.zze.get(0);
        for (int i = 1; i < this.zze.size(); ++i) {
            object = (ProductDetailsParams)this.zze.get(i);
            if (((ProductDetailsParams)object).zza().getProductType().equals(productDetailsParams.zza().getProductType()) || ((ProductDetailsParams)object).zza().getProductType().equals("play_pass_subs")) {
                continue;
            }
            return zzcj.zza(5, "All products should have same ProductType.");
        }
        String string = productDetailsParams.zza().zza();
        object = new Object();
        HashSet hashSet = new HashSet();
        zzco zzco2 = this.zze;
        int n = zzco2.size();
        for (int i = 0; i < n; ++i) {
            ProductDetailsParams productDetailsParams2 = (ProductDetailsParams)zzco2.get(i);
            productDetailsParams2.zza().getProductType().equals("subs");
            if (((HashSet)object).contains(productDetailsParams2.zza().getProductId())) {
                Object[] objectArray = new Object[]{productDetailsParams2.zza().getProductId()};
                return zzcj.zza(5, String.format("ProductId can not be duplicated. Invalid product id: %s.", objectArray));
            }
            ((HashSet)object).add(productDetailsParams2.zza().getProductId());
            if (productDetailsParams.zza().getProductType().equals("play_pass_subs") || productDetailsParams2.zza().getProductType().equals("play_pass_subs") || string.equals(productDetailsParams2.zza().zza())) {
                continue;
            }
            return zzcj.zza(5, "All products must have the same package name.");
        }
        Object object2 = hashSet.iterator();
        while (object2.hasNext()) {
            string = (String)object2.next();
            if (!((HashSet)object).contains(string)) continue;
            object2 = new Object[]{string};
            return zzcj.zza(5, String.format("OldProductId must not be one of the products to be purchased. Invalid old product id: %s.", object2));
        }
        object2 = productDetailsParams.zza().getOneTimePurchaseOfferDetails();
        if (object2 != null && object2.zza() != null) {
            return zzcj.zza(5, "Both autoPayDetails and autoPayBalanceThreshold is required for constructing ProductDetailsParams for autopay.");
        }
        return zzcj.zzl;
    }

    @Nullable
    public final String zzc() {
        return this.zzb;
    }

    @Nullable
    public final String zzd() {
        return this.zzc;
    }

    @Nullable
    public final String zze() {
        return this.zzd.zzc();
    }

    @Nullable
    public final String zzf() {
        return this.zzd.zzd();
    }

    @NonNull
    public final ArrayList zzg() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.zzf);
        return arrayList;
    }

    @NonNull
    public final List zzh() {
        return this.zze;
    }

    /* synthetic */ BillingFlowParams(zzcf zzcf2) {
    }

    public final boolean zzp() {
        return this.zzg;
    }

    final boolean zzq() {
        return this.zzb != null || this.zzc != null || this.zzd.zzd() != null || this.zzd.zza() != 0 || this.zze.stream().anyMatch(new zzcd()) || this.zza || this.zzg;
    }

    public static class SubscriptionUpdateParams {
        private String zza;
        private String zzb;
        private int zzc = 0;

        @NonNull
        public static Builder newBuilder() {
            return new Builder(null);
        }

        private SubscriptionUpdateParams() {
        }

        final int zza() {
            return this.zzc;
        }

        static /* bridge */ /* synthetic */ Builder zzb(SubscriptionUpdateParams subscriptionUpdateParams) {
            Builder builder = SubscriptionUpdateParams.newBuilder();
            builder.zzb(subscriptionUpdateParams.zza);
            builder.setSubscriptionReplacementMode(subscriptionUpdateParams.zzc);
            builder.setOriginalExternalTransactionId(subscriptionUpdateParams.zzb);
            return builder;
        }

        final String zzc() {
            return this.zza;
        }

        final String zzd() {
            return this.zzb;
        }

        /* synthetic */ SubscriptionUpdateParams(zzcf zzcf2) {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ReplacementMode {
            public static final int UNKNOWN_REPLACEMENT_MODE = 0;
            public static final int WITH_TIME_PRORATION = 1;
            public static final int CHARGE_PRORATED_PRICE = 2;
            public static final int WITHOUT_PRORATION = 3;
            public static final int CHARGE_FULL_PRICE = 5;
            public static final int DEFERRED = 6;
        }

        public static class Builder {
            private String zza;
            private String zzb;
            private boolean zzc;
            private int zzd = 0;

            /*
             * WARNING - void declaration
             */
            @NonNull
            public Builder setOldPurchaseToken(@NonNull String purchaseToken) {
                void var1_1;
                this.zza = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @zze
            @NonNull
            public Builder setOriginalExternalTransactionId(@NonNull String externalTransactionId) {
                void var1_1;
                this.zzb = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @NonNull
            public Builder setSubscriptionReplacementMode(int subscriptionReplacementMode) {
                void var1_1;
                this.zzd = var1_1;
                return this;
            }

            /*
             * Enabled aggressive block sorting
             */
            @NonNull
            public SubscriptionUpdateParams build() {
                boolean bl = TextUtils.isEmpty((CharSequence)this.zza) ? !TextUtils.isEmpty(null) : true;
                boolean bl2 = TextUtils.isEmpty((CharSequence)this.zzb) ^ true;
                if (bl && bl2) {
                    throw new IllegalArgumentException("Please provide Old SKU purchase information(token/id) or original external transaction id, not both.");
                }
                if (!(this.zzc || bl || bl2)) {
                    throw new IllegalArgumentException("Old SKU purchase information(token/id) or original external transaction id must be provided.");
                }
                SubscriptionUpdateParams subscriptionUpdateParams = new SubscriptionUpdateParams(null);
                subscriptionUpdateParams.zza = this.zza;
                subscriptionUpdateParams.zzc = this.zzd;
                subscriptionUpdateParams.zzb = this.zzb;
                return subscriptionUpdateParams;
            }

            private Builder() {
            }

            static /* synthetic */ Builder zza(Builder builder) {
                builder.zzc = true;
                return builder;
            }

            @Deprecated
            @NonNull
            public final Builder zzb(@NonNull String string) {
                this.zza = string;
                return this;
            }

            /* synthetic */ Builder(zzcf zzcf2) {
            }
        }
    }

    public static final class ProductDetailsParams {
        private final ProductDetails zza;
        @Nullable
        private final String zzb;

        @NonNull
        public static Builder newBuilder() {
            return new Builder(null);
        }

        @NonNull
        public final ProductDetails zza() {
            return this.zza;
        }

        @Nullable
        public final String zzb() {
            return this.zzb;
        }

        /* synthetic */ ProductDetailsParams(Builder builder, zzcf zzcf2) {
            this.zza = builder.zza;
            this.zzb = builder.zzb;
        }

        public static class Builder {
            private ProductDetails zza;
            @Nullable
            private String zzb;

            /*
             * WARNING - void declaration
             */
            @NonNull
            public Builder setOfferToken(@NonNull String offerToken) {
                void var1_1;
                if (TextUtils.isEmpty((CharSequence)offerToken)) {
                    throw new IllegalArgumentException("offerToken can not be empty");
                }
                this.zzb = var1_1;
                return this;
            }

            @NonNull
            public Builder setProductDetails(@NonNull ProductDetails productDetails) {
                ProductDetails.OneTimePurchaseOfferDetails oneTimePurchaseOfferDetails;
                this.zza = oneTimePurchaseOfferDetails;
                if (((ProductDetails)((Object)oneTimePurchaseOfferDetails)).getOneTimePurchaseOfferDetails() != null) {
                    if (((ProductDetails)((Object)oneTimePurchaseOfferDetails)).getOneTimePurchaseOfferDetails() != null) {
                        if ((oneTimePurchaseOfferDetails = ((ProductDetails)((Object)oneTimePurchaseOfferDetails)).getOneTimePurchaseOfferDetails()).zzb() != null) {
                            this.zzb = oneTimePurchaseOfferDetails.zzb();
                        }
                    } else {
                        throw null;
                    }
                }
                return this;
            }

            @NonNull
            public ProductDetailsParams build() {
                zzbe.zzc(this.zza, "ProductDetails is required for constructing ProductDetailsParams.");
                if (this.zza.getSubscriptionOfferDetails() != null) {
                    zzbe.zzc(this.zzb, "offerToken is required for constructing ProductDetailsParams for subscriptions.");
                }
                return new ProductDetailsParams(this, null);
            }

            private Builder() {
                throw null;
            }

            /* synthetic */ Builder(zzcf zzcf2) {
            }
        }
    }

    public static class Builder {
        private String zza;
        private String zzb;
        private List zzc;
        private ArrayList zzd;
        private boolean zze;
        private SubscriptionUpdateParams.Builder zzf;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setIsOfferPersonalized(boolean isOfferPersonalized) {
            void var1_1;
            this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setObfuscatedAccountId(@NonNull String obfuscatedAccountid) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setObfuscatedProfileId(@NonNull String obfuscatedProfileId) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setProductDetailsParamsList(@NonNull List<ProductDetailsParams> productDetailsParamsList) {
            void var1_1;
            this.zzc = new ArrayList(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @NonNull
        public Builder setSkuDetails(@NonNull SkuDetails skuDetails) {
            void var1_1;
            ArrayList<void> arrayList = new ArrayList<void>();
            arrayList.add(var1_1);
            this.zzd = arrayList;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setSubscriptionUpdateParams(@NonNull SubscriptionUpdateParams subscriptionUpdateParams) {
            void var1_1;
            this.zzf = SubscriptionUpdateParams.zzb((SubscriptionUpdateParams)var1_1);
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NonNull
        public BillingFlowParams build() {
            ArrayList arrayList = ((Builder)this_).zzd;
            boolean bl = arrayList != null ? !arrayList.isEmpty() : false;
            List list = ((Builder)this_).zzc;
            boolean bl2 = list != null ? !list.isEmpty() : false;
            if (!bl && !bl2) {
                throw new IllegalArgumentException("Details of the products must be provided.");
            }
            if (bl && bl2) {
                throw new IllegalArgumentException("Set SkuDetails or ProductDetailsParams, not both.");
            }
            if (bl) {
                if (((Builder)this_).zzd.contains(null)) {
                    throw new IllegalArgumentException("SKU cannot be null.");
                }
                if (((Builder)this_).zzd.size() > 1) {
                    SkuDetails skuDetails;
                    int n;
                    Object object = (SkuDetails)((Builder)this_).zzd.get(0);
                    String string = ((SkuDetails)object).getType();
                    ArrayList arrayList2 = ((Builder)this_).zzd;
                    int n2 = arrayList2.size();
                    for (n = 0; n < n2; ++n) {
                        skuDetails = (SkuDetails)arrayList2.get(n);
                        if (string.equals("play_pass_subs") || skuDetails.getType().equals("play_pass_subs") || string.equals(skuDetails.getType())) continue;
                        throw new IllegalArgumentException("SKUs should have the same type.");
                    }
                    object = ((SkuDetails)object).zzd();
                    arrayList2 = ((Builder)this_).zzd;
                    n2 = arrayList2.size();
                    for (n = 0; n < n2; ++n) {
                        skuDetails = (SkuDetails)arrayList2.get(n);
                        if (string.equals("play_pass_subs") || skuDetails.getType().equals("play_pass_subs") || ((String)object).equals(skuDetails.zzd())) continue;
                        throw new IllegalArgumentException("All SKUs must have the same package name.");
                    }
                }
            } else {
                ((Builder)this_).zzc.forEach(new zzce());
            }
            BillingFlowParams billingFlowParams = new BillingFlowParams(null);
            bl = !bl || ((SkuDetails)((Builder)this_).zzd.get(0)).zzd().isEmpty() ? (bl2 ? !((ProductDetailsParams)((Builder)this_).zzc.get(0)).zza().zza().isEmpty() : false) : true;
            billingFlowParams.zza = bl;
            billingFlowParams.zzb = ((Builder)this_).zza;
            billingFlowParams.zzc = ((Builder)this_).zzb;
            billingFlowParams.zzd = ((Builder)this_).zzf.build();
            ArrayList arrayList3 = ((Builder)this_).zzd;
            arrayList3 = arrayList3 != null ? new ArrayList(arrayList3) : new ArrayList();
            billingFlowParams.zzf = arrayList3;
            billingFlowParams.zzg = ((Builder)this_).zze;
            Object this_ = ((Builder)this_).zzc;
            this_ = this_ != null ? zzco.zzk((Collection)this_) : zzco.zzl();
            billingFlowParams.zze = (zzco)this_;
            return billingFlowParams;
        }

        private Builder() {
            SubscriptionUpdateParams.Builder builder = SubscriptionUpdateParams.newBuilder();
            SubscriptionUpdateParams.Builder.zza(builder);
            this.zzf = builder;
        }

        /* synthetic */ Builder(zzcf zzcf2) {
            SubscriptionUpdateParams.Builder builder = SubscriptionUpdateParams.newBuilder();
            SubscriptionUpdateParams.Builder.zza(builder);
            this.zzf = builder;
        }
    }
}

