/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.billingclient.api.zzde;
import com.android.billingclient.api.zzk;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzk
public final class UserChoiceDetails {
    private final String mOriginalJson;
    private final JSONObject mParsedJson;
    private final List<Product> mProducts;

    @NonNull
    public String getExternalTransactionToken() {
        return this.mParsedJson.optString("externalTransactionToken");
    }

    @Nullable
    public String getOriginalExternalTransactionId() {
        String this_ = ((UserChoiceDetails)((Object)this_)).mParsedJson.optString("originalExternalTransactionId");
        if (this_.isEmpty()) {
            return null;
        }
        return this_;
    }

    @NonNull
    public List<Product> getProducts() {
        return this.mProducts;
    }

    private static List<Product> toProductList(@Nullable JSONArray productArray) {
        JSONArray jSONArray;
        ArrayList<Product> arrayList = new ArrayList<Product>();
        if (jSONArray != null) {
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.optJSONObject(i);
                if (jSONObject == null) continue;
                arrayList.add(new Product(jSONObject, null));
            }
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    UserChoiceDetails(String jsonPurchaseInfo) throws JSONException {
        void var1_1;
        this.mOriginalJson = var1_1;
        this.mParsedJson = new JSONObject(this.mOriginalJson);
        this.mProducts = UserChoiceDetails.toProductList(this.mParsedJson.optJSONArray("products"));
    }

    @zzk
    public static class Product {
        private final String id;
        private final String type;
        @Nullable
        private final String offerToken;

        public int hashCode() {
            String string = this.id;
            return Objects.hash(string, this.type, this.offerToken);
        }

        @NonNull
        public String getId() {
            return this.id;
        }

        @Nullable
        public String getOfferToken() {
            return this.offerToken;
        }

        @NonNull
        public String getType() {
            return this.type;
        }

        @NonNull
        public String toString() {
            String string = this.id;
            Object[] objectArray = new Object[]{string, this.type, this.offerToken};
            return String.format("{id: %s, type: %s, offer token: %s}", objectArray);
        }

        private Product(JSONObject parsedJson) {
            String string;
            this.id = string.optString("productId");
            this.type = string.optString("productType");
            string = string.optString("offerToken");
            if (string.isEmpty()) {
                string = null;
            }
            this.offerToken = string;
        }

        /*
         * WARNING - void declaration
         */
        Product(String id2, String type, @Nullable String offerToken) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.id = var1_1;
            this.type = var2_2;
            this.offerToken = var3_3;
        }

        public boolean equals(@Nullable Object o) {
            Product product;
            if (this == product) {
                return true;
            }
            if (!(product instanceof Product)) {
                return false;
            }
            return this.id.equals((product = (Product)product).getId()) && this.type.equals(product.getType()) && Objects.equals(this.offerToken, product.getOfferToken());
        }

        /* synthetic */ Product(JSONObject jSONObject, zzde zzde2) {
            this(jSONObject);
        }
    }
}

