/*
 * Decompiled with CFR 0.152.
 */
package com.android.signflinger;

import com.android.zipflinger.ZipInfo;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

class ApkSigningBlock {
    ApkSigningBlock() {
    }

    static void addToArchive(RandomAccessFile raf, byte[] sig, ZipInfo zipInfo) {
        if (zipInfo.eocd.size() != 22L) {
            throw new IllegalStateException("Commented eocd is not supported (was this apk not created with zipflinger?).");
        }
        ByteBuffer signatureBlock = ByteBuffer.wrap(sig);
        try (FileChannel channel = raf.getChannel();){
            byte[] cdAndEocd = new byte[(int)(zipInfo.cd.size() + zipInfo.eocd.size())];
            raf.seek(zipInfo.cd.first);
            raf.read(cdAndEocd);
            ByteBuffer cdAndEocdBuffer = ByteBuffer.wrap(cdAndEocd).order(ByteOrder.LITTLE_ENDIAN);
            cdAndEocdBuffer.position(cdAndEocdBuffer.capacity() - 6);
            int offset = (int)(zipInfo.cd.first + (long)signatureBlock.capacity());
            cdAndEocdBuffer.putInt(offset);
            raf.seek(zipInfo.cd.first);
            raf.write(signatureBlock.array());
            raf.write(cdAndEocdBuffer.array());
            channel.truncate(raf.length());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

