/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.design.R;
import android.support.design.widget.AnimationUtils;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.HeaderBehavior;
import android.support.design.widget.HeaderScrollingViewBehavior;
import android.support.design.widget.ThemeUtils;
import android.support.design.widget.ViewUtilsLollipop;
import android.support.v4.math.MathUtils;
import android.support.v4.util.ObjectsCompat;
import android.support.v4.view.AbsSavedState;
import android.support.v4.view.OnApplyWindowInsetsListener;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.WindowInsetsCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

@CoordinatorLayout.DefaultBehavior(value=Behavior.class)
public class AppBarLayout
extends LinearLayout {
    static final int PENDING_ACTION_NONE = 0;
    static final int PENDING_ACTION_EXPANDED = 1;
    static final int PENDING_ACTION_COLLAPSED = 2;
    static final int PENDING_ACTION_ANIMATE_ENABLED = 4;
    static final int PENDING_ACTION_FORCE = 8;
    private static final int INVALID_SCROLL_RANGE = -1;
    private int mTotalScrollRange = -1;
    private int mDownPreScrollRange = -1;
    private int mDownScrollRange = -1;
    private boolean mHaveChildWithInterpolator;
    private int mPendingAction = 0;
    private WindowInsetsCompat mLastInsets;
    private List<OnOffsetChangedListener> mListeners;
    private boolean mCollapsible;
    private boolean mCollapsed;
    private int[] mTmpStatesArray;

    public AppBarLayout(Context context) {
        this(context, null);
    }

    public AppBarLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOrientation(1);
        ThemeUtils.checkAppCompatTheme(context);
        if (Build.VERSION.SDK_INT >= 21) {
            ViewUtilsLollipop.setBoundsViewOutlineProvider((View)this);
            ViewUtilsLollipop.setStateListAnimatorFromAttrs((View)this, attrs, 0, R.style.Widget_Design_AppBarLayout);
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AppBarLayout, 0, R.style.Widget_Design_AppBarLayout);
        ViewCompat.setBackground((View)this, (Drawable)a.getDrawable(R.styleable.AppBarLayout_android_background));
        if (a.hasValue(R.styleable.AppBarLayout_expanded)) {
            this.setExpanded(a.getBoolean(R.styleable.AppBarLayout_expanded, false), false, false);
        }
        if (Build.VERSION.SDK_INT >= 21 && a.hasValue(R.styleable.AppBarLayout_elevation)) {
            ViewUtilsLollipop.setDefaultAppBarLayoutStateListAnimator((View)this, a.getDimensionPixelSize(R.styleable.AppBarLayout_elevation, 0));
        }
        if (Build.VERSION.SDK_INT >= 26) {
            if (a.hasValue(R.styleable.AppBarLayout_android_keyboardNavigationCluster)) {
                this.setKeyboardNavigationCluster(a.getBoolean(R.styleable.AppBarLayout_android_keyboardNavigationCluster, false));
            }
            if (a.hasValue(R.styleable.AppBarLayout_android_touchscreenBlocksFocus)) {
                this.setTouchscreenBlocksFocus(a.getBoolean(R.styleable.AppBarLayout_android_touchscreenBlocksFocus, false));
            }
        }
        a.recycle();
        ViewCompat.setOnApplyWindowInsetsListener((View)this, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                return AppBarLayout.this.onWindowInsetChanged(insets);
            }
        });
    }

    public void addOnOffsetChangedListener(OnOffsetChangedListener listener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList<OnOffsetChangedListener>();
        }
        if (listener != null && !this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void removeOnOffsetChangedListener(OnOffsetChangedListener listener) {
        if (this.mListeners != null && listener != null) {
            this.mListeners.remove(listener);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.invalidateScrollRanges();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.invalidateScrollRanges();
        this.mHaveChildWithInterpolator = false;
        int z = this.getChildCount();
        for (int i = 0; i < z; ++i) {
            View child = this.getChildAt(i);
            LayoutParams childLp = (LayoutParams)child.getLayoutParams();
            Interpolator interpolator = childLp.getScrollInterpolator();
            if (interpolator == null) continue;
            this.mHaveChildWithInterpolator = true;
            break;
        }
        this.updateCollapsible();
    }

    private void updateCollapsible() {
        boolean haveCollapsibleChild = false;
        int z = this.getChildCount();
        for (int i = 0; i < z; ++i) {
            if (!((LayoutParams)this.getChildAt(i).getLayoutParams()).isCollapsible()) continue;
            haveCollapsibleChild = true;
            break;
        }
        this.setCollapsibleState(haveCollapsibleChild);
    }

    private void invalidateScrollRanges() {
        this.mTotalScrollRange = -1;
        this.mDownPreScrollRange = -1;
        this.mDownScrollRange = -1;
    }

    public void setOrientation(int orientation) {
        if (orientation != 1) {
            throw new IllegalArgumentException("AppBarLayout is always vertical and does not support horizontal orientation");
        }
        super.setOrientation(orientation);
    }

    public void setExpanded(boolean expanded) {
        this.setExpanded(expanded, ViewCompat.isLaidOut((View)this));
    }

    public void setExpanded(boolean expanded, boolean animate) {
        this.setExpanded(expanded, animate, true);
    }

    private void setExpanded(boolean expanded, boolean animate, boolean force) {
        this.mPendingAction = (expanded ? 1 : 2) | (animate ? 4 : 0) | (force ? 8 : 0);
        this.requestLayout();
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -2);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        if (Build.VERSION.SDK_INT >= 19 && p instanceof LinearLayout.LayoutParams) {
            return new LayoutParams((LinearLayout.LayoutParams)p);
        }
        if (p instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)p);
        }
        return new LayoutParams(p);
    }

    boolean hasChildWithInterpolator() {
        return this.mHaveChildWithInterpolator;
    }

    public final int getTotalScrollRange() {
        if (this.mTotalScrollRange != -1) {
            return this.mTotalScrollRange;
        }
        int range = 0;
        int z = this.getChildCount();
        for (int i = 0; i < z; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childHeight = child.getMeasuredHeight();
            int flags = lp.mScrollFlags;
            if ((flags & 1) == 0) break;
            range += childHeight + lp.topMargin + lp.bottomMargin;
            if ((flags & 2) == 0) continue;
            range -= ViewCompat.getMinimumHeight((View)child);
            break;
        }
        this.mTotalScrollRange = Math.max(0, range - this.getTopInset());
        return this.mTotalScrollRange;
    }

    boolean hasScrollableChildren() {
        return this.getTotalScrollRange() != 0;
    }

    int getUpNestedPreScrollRange() {
        return this.getTotalScrollRange();
    }

    int getDownNestedPreScrollRange() {
        if (this.mDownPreScrollRange != -1) {
            return this.mDownPreScrollRange;
        }
        int range = 0;
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childHeight = child.getMeasuredHeight();
            int flags = lp.mScrollFlags;
            if ((flags & 5) == 5) {
                range += lp.topMargin + lp.bottomMargin;
                if ((flags & 8) != 0) {
                    range += ViewCompat.getMinimumHeight((View)child);
                    continue;
                }
                if ((flags & 2) != 0) {
                    range += childHeight - ViewCompat.getMinimumHeight((View)child);
                    continue;
                }
                range += childHeight - this.getTopInset();
                continue;
            }
            if (range > 0) break;
        }
        this.mDownPreScrollRange = Math.max(0, range);
        return this.mDownPreScrollRange;
    }

    int getDownNestedScrollRange() {
        if (this.mDownScrollRange != -1) {
            return this.mDownScrollRange;
        }
        int range = 0;
        int z = this.getChildCount();
        for (int i = 0; i < z; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childHeight = child.getMeasuredHeight();
            childHeight += lp.topMargin + lp.bottomMargin;
            int flags = lp.mScrollFlags;
            if ((flags & 1) == 0) break;
            range += childHeight;
            if ((flags & 2) == 0) continue;
            range -= ViewCompat.getMinimumHeight((View)child) + this.getTopInset();
            break;
        }
        this.mDownScrollRange = Math.max(0, range);
        return this.mDownScrollRange;
    }

    void dispatchOffsetUpdates(int offset) {
        if (this.mListeners != null) {
            int z = this.mListeners.size();
            for (int i = 0; i < z; ++i) {
                OnOffsetChangedListener listener = this.mListeners.get(i);
                if (listener == null) continue;
                listener.onOffsetChanged(this, offset);
            }
        }
    }

    final int getMinimumHeightForVisibleOverlappingContent() {
        int lastChildMinHeight;
        int topInset = this.getTopInset();
        int minHeight = ViewCompat.getMinimumHeight((View)this);
        if (minHeight != 0) {
            return minHeight * 2 + topInset;
        }
        int childCount = this.getChildCount();
        int n = lastChildMinHeight = childCount >= 1 ? ViewCompat.getMinimumHeight((View)this.getChildAt(childCount - 1)) : 0;
        if (lastChildMinHeight != 0) {
            return lastChildMinHeight * 2 + topInset;
        }
        return this.getHeight() / 3;
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        if (this.mTmpStatesArray == null) {
            this.mTmpStatesArray = new int[2];
        }
        int[] extraStates = this.mTmpStatesArray;
        int[] states = super.onCreateDrawableState(extraSpace + extraStates.length);
        extraStates[0] = this.mCollapsible ? R.attr.state_collapsible : -R.attr.state_collapsible;
        extraStates[1] = this.mCollapsible && this.mCollapsed ? R.attr.state_collapsed : -R.attr.state_collapsed;
        return AppBarLayout.mergeDrawableStates((int[])states, (int[])extraStates);
    }

    private boolean setCollapsibleState(boolean collapsible) {
        if (this.mCollapsible != collapsible) {
            this.mCollapsible = collapsible;
            this.refreshDrawableState();
            return true;
        }
        return false;
    }

    boolean setCollapsedState(boolean collapsed) {
        if (this.mCollapsed != collapsed) {
            this.mCollapsed = collapsed;
            this.refreshDrawableState();
            return true;
        }
        return false;
    }

    @Deprecated
    public void setTargetElevation(float elevation) {
        if (Build.VERSION.SDK_INT >= 21) {
            ViewUtilsLollipop.setDefaultAppBarLayoutStateListAnimator((View)this, elevation);
        }
    }

    @Deprecated
    public float getTargetElevation() {
        return 0.0f;
    }

    int getPendingAction() {
        return this.mPendingAction;
    }

    void resetPendingAction() {
        this.mPendingAction = 0;
    }

    @VisibleForTesting
    final int getTopInset() {
        return this.mLastInsets != null ? this.mLastInsets.getSystemWindowInsetTop() : 0;
    }

    WindowInsetsCompat onWindowInsetChanged(WindowInsetsCompat insets) {
        WindowInsetsCompat newInsets = null;
        if (ViewCompat.getFitsSystemWindows((View)this)) {
            newInsets = insets;
        }
        if (!ObjectsCompat.equals((Object)this.mLastInsets, (Object)newInsets)) {
            this.mLastInsets = newInsets;
            this.invalidateScrollRanges();
        }
        return insets;
    }

    public static class ScrollingViewBehavior
    extends HeaderScrollingViewBehavior {
        public ScrollingViewBehavior() {
        }

        public ScrollingViewBehavior(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ScrollingViewBehavior_Layout);
            this.setOverlayTop(a.getDimensionPixelSize(R.styleable.ScrollingViewBehavior_Layout_behavior_overlapTop, 0));
            a.recycle();
        }

        public boolean layoutDependsOn(CoordinatorLayout parent, View child, View dependency) {
            return dependency instanceof AppBarLayout;
        }

        public boolean onDependentViewChanged(CoordinatorLayout parent, View child, View dependency) {
            this.offsetChildAsNeeded(parent, child, dependency);
            return false;
        }

        public boolean onRequestChildRectangleOnScreen(CoordinatorLayout parent, View child, Rect rectangle, boolean immediate) {
            AppBarLayout header = this.findFirstDependency((List<View>)parent.getDependencies(child));
            if (header != null) {
                rectangle.offset(child.getLeft(), child.getTop());
                Rect parentRect = this.mTempRect1;
                parentRect.set(0, 0, parent.getWidth(), parent.getHeight());
                if (!parentRect.contains(rectangle)) {
                    header.setExpanded(false, !immediate);
                    return true;
                }
            }
            return false;
        }

        private void offsetChildAsNeeded(CoordinatorLayout parent, View child, View dependency) {
            CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)dependency.getLayoutParams()).getBehavior();
            if (behavior instanceof Behavior) {
                Behavior ablBehavior = (Behavior)behavior;
                ViewCompat.offsetTopAndBottom((View)child, (int)(dependency.getBottom() - child.getTop() + ablBehavior.mOffsetDelta + this.getVerticalLayoutGap() - this.getOverlapPixelsForOffset(dependency)));
            }
        }

        @Override
        float getOverlapRatioForOffset(View header) {
            if (header instanceof AppBarLayout) {
                AppBarLayout abl = (AppBarLayout)header;
                int totalScrollRange = abl.getTotalScrollRange();
                int preScrollDown = abl.getDownNestedPreScrollRange();
                int offset = ScrollingViewBehavior.getAppBarLayoutOffset(abl);
                if (preScrollDown != 0 && totalScrollRange + offset <= preScrollDown) {
                    return 0.0f;
                }
                int availScrollRange = totalScrollRange - preScrollDown;
                if (availScrollRange != 0) {
                    return 1.0f + (float)offset / (float)availScrollRange;
                }
            }
            return 0.0f;
        }

        private static int getAppBarLayoutOffset(AppBarLayout abl) {
            CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)abl.getLayoutParams()).getBehavior();
            if (behavior instanceof Behavior) {
                return ((Behavior)behavior).getTopBottomOffsetForScrollingSibling();
            }
            return 0;
        }

        AppBarLayout findFirstDependency(List<View> views) {
            int z = views.size();
            for (int i = 0; i < z; ++i) {
                View view = views.get(i);
                if (!(view instanceof AppBarLayout)) continue;
                return (AppBarLayout)view;
            }
            return null;
        }

        @Override
        int getScrollRange(View v) {
            if (v instanceof AppBarLayout) {
                return ((AppBarLayout)v).getTotalScrollRange();
            }
            return super.getScrollRange(v);
        }
    }

    public static class Behavior
    extends HeaderBehavior<AppBarLayout> {
        private static final int MAX_OFFSET_ANIMATION_DURATION = 600;
        private static final int INVALID_POSITION = -1;
        private int mOffsetDelta;
        private ValueAnimator mOffsetAnimator;
        private int mOffsetToChildIndexOnLayout = -1;
        private boolean mOffsetToChildIndexOnLayoutIsMinHeight;
        private float mOffsetToChildIndexOnLayoutPerc;
        private WeakReference<View> mLastNestedScrollingChildRef;
        private DragCallback mOnDragCallback;

        public Behavior() {
        }

        public Behavior(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public boolean onStartNestedScroll(CoordinatorLayout parent, AppBarLayout child, View directTargetChild, View target, int nestedScrollAxes, int type) {
            boolean started;
            boolean bl = started = (nestedScrollAxes & 2) != 0 && child.hasScrollableChildren() && parent.getHeight() - directTargetChild.getHeight() <= child.getHeight();
            if (started && this.mOffsetAnimator != null) {
                this.mOffsetAnimator.cancel();
            }
            this.mLastNestedScrollingChildRef = null;
            return started;
        }

        public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, int dx, int dy, int[] consumed, int type) {
            if (dy != 0) {
                int max;
                int min;
                if (dy < 0) {
                    min = -child.getTotalScrollRange();
                    max = min + child.getDownNestedPreScrollRange();
                } else {
                    min = -child.getUpNestedPreScrollRange();
                    max = 0;
                }
                if (min != max) {
                    consumed[1] = this.scroll(coordinatorLayout, child, dy, min, max);
                }
            }
        }

        public void onNestedScroll(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type) {
            if (dyUnconsumed < 0) {
                this.scroll(coordinatorLayout, child, dyUnconsumed, -child.getDownNestedScrollRange(), 0);
            }
        }

        public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, AppBarLayout abl, View target, int type) {
            if (type == 0) {
                this.snapToChildIfNeeded(coordinatorLayout, abl);
            }
            this.mLastNestedScrollingChildRef = new WeakReference<View>(target);
        }

        public void setDragCallback(@Nullable DragCallback callback) {
            this.mOnDragCallback = callback;
        }

        private void animateOffsetTo(CoordinatorLayout coordinatorLayout, AppBarLayout child, int offset, float velocity) {
            int duration;
            int distance = Math.abs(this.getTopBottomOffsetForScrollingSibling() - offset);
            if ((velocity = Math.abs(velocity)) > 0.0f) {
                duration = 3 * Math.round(1000.0f * ((float)distance / velocity));
            } else {
                float distanceRatio = (float)distance / (float)child.getHeight();
                duration = (int)((distanceRatio + 1.0f) * 150.0f);
            }
            this.animateOffsetWithDuration(coordinatorLayout, child, offset, duration);
        }

        private void animateOffsetWithDuration(final CoordinatorLayout coordinatorLayout, final AppBarLayout child, int offset, int duration) {
            int currentOffset = this.getTopBottomOffsetForScrollingSibling();
            if (currentOffset == offset) {
                if (this.mOffsetAnimator != null && this.mOffsetAnimator.isRunning()) {
                    this.mOffsetAnimator.cancel();
                }
                return;
            }
            if (this.mOffsetAnimator == null) {
                this.mOffsetAnimator = new ValueAnimator();
                this.mOffsetAnimator.setInterpolator((TimeInterpolator)AnimationUtils.DECELERATE_INTERPOLATOR);
                this.mOffsetAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        Behavior.this.setHeaderTopBottomOffset(coordinatorLayout, child, (Integer)animation.getAnimatedValue());
                    }
                });
            } else {
                this.mOffsetAnimator.cancel();
            }
            this.mOffsetAnimator.setDuration((long)Math.min(duration, 600));
            this.mOffsetAnimator.setIntValues(new int[]{currentOffset, offset});
            this.mOffsetAnimator.start();
        }

        private int getChildIndexOnOffset(AppBarLayout abl, int offset) {
            int count = abl.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = abl.getChildAt(i);
                if (child.getTop() > -offset || child.getBottom() < -offset) continue;
                return i;
            }
            return -1;
        }

        private void snapToChildIfNeeded(CoordinatorLayout coordinatorLayout, AppBarLayout abl) {
            View offsetChild;
            LayoutParams lp;
            int flags;
            int offset = this.getTopBottomOffsetForScrollingSibling();
            int offsetChildIndex = this.getChildIndexOnOffset(abl, offset);
            if (offsetChildIndex >= 0 && ((flags = (lp = (LayoutParams)(offsetChild = abl.getChildAt(offsetChildIndex)).getLayoutParams()).getScrollFlags()) & 0x11) == 17) {
                int snapTop = -offsetChild.getTop();
                int snapBottom = -offsetChild.getBottom();
                if (offsetChildIndex == abl.getChildCount() - 1) {
                    snapBottom += abl.getTopInset();
                }
                if (Behavior.checkFlag(flags, 2)) {
                    snapBottom += ViewCompat.getMinimumHeight((View)offsetChild);
                } else if (Behavior.checkFlag(flags, 5)) {
                    int seam = snapBottom + ViewCompat.getMinimumHeight((View)offsetChild);
                    if (offset < seam) {
                        snapTop = seam;
                    } else {
                        snapBottom = seam;
                    }
                }
                int newOffset = offset < (snapBottom + snapTop) / 2 ? snapBottom : snapTop;
                this.animateOffsetTo(coordinatorLayout, abl, MathUtils.clamp((int)newOffset, (int)(-abl.getTotalScrollRange()), (int)0), 0.0f);
            }
        }

        private static boolean checkFlag(int flags, int check) {
            return (flags & check) == check;
        }

        public boolean onMeasureChild(CoordinatorLayout parent, AppBarLayout child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
            CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)child.getLayoutParams();
            if (lp.height == -2) {
                parent.onMeasureChild((View)child, parentWidthMeasureSpec, widthUsed, View.MeasureSpec.makeMeasureSpec((int)0, (int)0), heightUsed);
                return true;
            }
            return super.onMeasureChild(parent, (View)child, parentWidthMeasureSpec, widthUsed, parentHeightMeasureSpec, heightUsed);
        }

        @Override
        public boolean onLayoutChild(CoordinatorLayout parent, AppBarLayout abl, int layoutDirection) {
            boolean handled = super.onLayoutChild(parent, abl, layoutDirection);
            int pendingAction = abl.getPendingAction();
            if (this.mOffsetToChildIndexOnLayout >= 0 && (pendingAction & 8) == 0) {
                View child = abl.getChildAt(this.mOffsetToChildIndexOnLayout);
                int offset = -child.getBottom();
                offset = this.mOffsetToChildIndexOnLayoutIsMinHeight ? (offset += ViewCompat.getMinimumHeight((View)child) + abl.getTopInset()) : (offset += Math.round((float)child.getHeight() * this.mOffsetToChildIndexOnLayoutPerc));
                this.setHeaderTopBottomOffset(parent, abl, offset);
            } else if (pendingAction != 0) {
                boolean animate;
                boolean bl = animate = (pendingAction & 4) != 0;
                if ((pendingAction & 2) != 0) {
                    int offset = -abl.getUpNestedPreScrollRange();
                    if (animate) {
                        this.animateOffsetTo(parent, abl, offset, 0.0f);
                    } else {
                        this.setHeaderTopBottomOffset(parent, abl, offset);
                    }
                } else if ((pendingAction & 1) != 0) {
                    if (animate) {
                        this.animateOffsetTo(parent, abl, 0, 0.0f);
                    } else {
                        this.setHeaderTopBottomOffset(parent, abl, 0);
                    }
                }
            }
            abl.resetPendingAction();
            this.mOffsetToChildIndexOnLayout = -1;
            this.setTopAndBottomOffset(MathUtils.clamp((int)this.getTopAndBottomOffset(), (int)(-abl.getTotalScrollRange()), (int)0));
            this.updateAppBarLayoutDrawableState(parent, abl, this.getTopAndBottomOffset(), 0, true);
            abl.dispatchOffsetUpdates(this.getTopAndBottomOffset());
            return handled;
        }

        @Override
        boolean canDragView(AppBarLayout view) {
            if (this.mOnDragCallback != null) {
                return this.mOnDragCallback.canDrag(view);
            }
            if (this.mLastNestedScrollingChildRef != null) {
                View scrollingView = (View)this.mLastNestedScrollingChildRef.get();
                return scrollingView != null && scrollingView.isShown() && !scrollingView.canScrollVertically(-1);
            }
            return true;
        }

        @Override
        void onFlingFinished(CoordinatorLayout parent, AppBarLayout layout2) {
            this.snapToChildIfNeeded(parent, layout2);
        }

        @Override
        int getMaxDragOffset(AppBarLayout view) {
            return -view.getDownNestedScrollRange();
        }

        @Override
        int getScrollRangeForDragFling(AppBarLayout view) {
            return view.getTotalScrollRange();
        }

        @Override
        int setHeaderTopBottomOffset(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, int newOffset, int minOffset, int maxOffset) {
            int curOffset = this.getTopBottomOffsetForScrollingSibling();
            int consumed = 0;
            if (minOffset != 0 && curOffset >= minOffset && curOffset <= maxOffset) {
                if (curOffset != (newOffset = MathUtils.clamp((int)newOffset, (int)minOffset, (int)maxOffset))) {
                    int interpolatedOffset = appBarLayout.hasChildWithInterpolator() ? this.interpolateOffset(appBarLayout, newOffset) : newOffset;
                    boolean offsetChanged = this.setTopAndBottomOffset(interpolatedOffset);
                    consumed = curOffset - newOffset;
                    this.mOffsetDelta = newOffset - interpolatedOffset;
                    if (!offsetChanged && appBarLayout.hasChildWithInterpolator()) {
                        coordinatorLayout.dispatchDependentViewsChanged((View)appBarLayout);
                    }
                    appBarLayout.dispatchOffsetUpdates(this.getTopAndBottomOffset());
                    this.updateAppBarLayoutDrawableState(coordinatorLayout, appBarLayout, newOffset, newOffset < curOffset ? -1 : 1, false);
                }
            } else {
                this.mOffsetDelta = 0;
            }
            return consumed;
        }

        @VisibleForTesting
        boolean isOffsetAnimatorRunning() {
            return this.mOffsetAnimator != null && this.mOffsetAnimator.isRunning();
        }

        private int interpolateOffset(AppBarLayout layout2, int offset) {
            int absOffset = Math.abs(offset);
            int z = layout2.getChildCount();
            for (int i = 0; i < z; ++i) {
                View child = layout2.getChildAt(i);
                LayoutParams childLp = (LayoutParams)child.getLayoutParams();
                Interpolator interpolator = childLp.getScrollInterpolator();
                if (absOffset < child.getTop() || absOffset > child.getBottom()) continue;
                if (interpolator == null) break;
                int childScrollableHeight = 0;
                int flags = childLp.getScrollFlags();
                if ((flags & 1) != 0) {
                    childScrollableHeight += child.getHeight() + childLp.topMargin + childLp.bottomMargin;
                    if ((flags & 2) != 0) {
                        childScrollableHeight -= ViewCompat.getMinimumHeight((View)child);
                    }
                }
                if (ViewCompat.getFitsSystemWindows((View)child)) {
                    childScrollableHeight -= layout2.getTopInset();
                }
                if (childScrollableHeight <= 0) break;
                int offsetForView = absOffset - child.getTop();
                int interpolatedDiff = Math.round((float)childScrollableHeight * interpolator.getInterpolation((float)offsetForView / (float)childScrollableHeight));
                return Integer.signum(offset) * (child.getTop() + interpolatedDiff);
            }
            return offset;
        }

        private void updateAppBarLayoutDrawableState(CoordinatorLayout parent, AppBarLayout layout2, int offset, int direction, boolean forceJump) {
            View child = Behavior.getAppBarChildOnOffset(layout2, offset);
            if (child != null) {
                LayoutParams childLp = (LayoutParams)child.getLayoutParams();
                int flags = childLp.getScrollFlags();
                boolean collapsed = false;
                if ((flags & 1) != 0) {
                    int minHeight = ViewCompat.getMinimumHeight((View)child);
                    if (direction > 0 && (flags & 0xC) != 0) {
                        collapsed = -offset >= child.getBottom() - minHeight - layout2.getTopInset();
                    } else if ((flags & 2) != 0) {
                        collapsed = -offset >= child.getBottom() - minHeight - layout2.getTopInset();
                    }
                }
                boolean changed = layout2.setCollapsedState(collapsed);
                if (Build.VERSION.SDK_INT >= 11 && (forceJump || changed && this.shouldJumpElevationState(parent, layout2))) {
                    layout2.jumpDrawablesToCurrentState();
                }
            }
        }

        private boolean shouldJumpElevationState(CoordinatorLayout parent, AppBarLayout layout2) {
            List dependencies = parent.getDependents((View)layout2);
            int size = dependencies.size();
            for (int i = 0; i < size; ++i) {
                View dependency = (View)dependencies.get(i);
                CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)dependency.getLayoutParams();
                CoordinatorLayout.Behavior behavior = lp.getBehavior();
                if (!(behavior instanceof ScrollingViewBehavior)) continue;
                return ((ScrollingViewBehavior)behavior).getOverlayTop() != 0;
            }
            return false;
        }

        private static View getAppBarChildOnOffset(AppBarLayout layout2, int offset) {
            int absOffset = Math.abs(offset);
            int z = layout2.getChildCount();
            for (int i = 0; i < z; ++i) {
                View child = layout2.getChildAt(i);
                if (absOffset < child.getTop() || absOffset > child.getBottom()) continue;
                return child;
            }
            return null;
        }

        @Override
        int getTopBottomOffsetForScrollingSibling() {
            return this.getTopAndBottomOffset() + this.mOffsetDelta;
        }

        public Parcelable onSaveInstanceState(CoordinatorLayout parent, AppBarLayout abl) {
            Parcelable superState = super.onSaveInstanceState(parent, (View)abl);
            int offset = this.getTopAndBottomOffset();
            int count = abl.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = abl.getChildAt(i);
                int visBottom = child.getBottom() + offset;
                if (child.getTop() + offset > 0 || visBottom < 0) continue;
                SavedState ss = new SavedState(superState);
                ss.firstVisibleChildIndex = i;
                ss.firstVisibleChildAtMinimumHeight = visBottom == ViewCompat.getMinimumHeight((View)child) + abl.getTopInset();
                ss.firstVisibleChildPercentageShown = (float)visBottom / (float)child.getHeight();
                return ss;
            }
            return superState;
        }

        public void onRestoreInstanceState(CoordinatorLayout parent, AppBarLayout appBarLayout, Parcelable state) {
            if (state instanceof SavedState) {
                SavedState ss = (SavedState)state;
                super.onRestoreInstanceState(parent, (View)appBarLayout, ss.getSuperState());
                this.mOffsetToChildIndexOnLayout = ss.firstVisibleChildIndex;
                this.mOffsetToChildIndexOnLayoutPerc = ss.firstVisibleChildPercentageShown;
                this.mOffsetToChildIndexOnLayoutIsMinHeight = ss.firstVisibleChildAtMinimumHeight;
            } else {
                super.onRestoreInstanceState(parent, (View)appBarLayout, state);
                this.mOffsetToChildIndexOnLayout = -1;
            }
        }

        protected static class SavedState
        extends AbsSavedState {
            int firstVisibleChildIndex;
            float firstVisibleChildPercentageShown;
            boolean firstVisibleChildAtMinimumHeight;
            public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

                public SavedState createFromParcel(Parcel source, ClassLoader loader) {
                    return new SavedState(source, loader);
                }

                public SavedState createFromParcel(Parcel source) {
                    return new SavedState(source, null);
                }

                public SavedState[] newArray(int size) {
                    return new SavedState[size];
                }
            };

            public SavedState(Parcel source, ClassLoader loader) {
                super(source, loader);
                this.firstVisibleChildIndex = source.readInt();
                this.firstVisibleChildPercentageShown = source.readFloat();
                this.firstVisibleChildAtMinimumHeight = source.readByte() != 0;
            }

            public SavedState(Parcelable superState) {
                super(superState);
            }

            public void writeToParcel(Parcel dest, int flags) {
                super.writeToParcel(dest, flags);
                dest.writeInt(this.firstVisibleChildIndex);
                dest.writeFloat(this.firstVisibleChildPercentageShown);
                dest.writeByte((byte)(this.firstVisibleChildAtMinimumHeight ? 1 : 0));
            }
        }

        public static abstract class DragCallback {
            public abstract boolean canDrag(@NonNull AppBarLayout var1);
        }
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        public static final int SCROLL_FLAG_SCROLL = 1;
        public static final int SCROLL_FLAG_EXIT_UNTIL_COLLAPSED = 2;
        public static final int SCROLL_FLAG_ENTER_ALWAYS = 4;
        public static final int SCROLL_FLAG_ENTER_ALWAYS_COLLAPSED = 8;
        public static final int SCROLL_FLAG_SNAP = 16;
        static final int FLAG_QUICK_RETURN = 5;
        static final int FLAG_SNAP = 17;
        static final int COLLAPSIBLE_FLAGS = 10;
        int mScrollFlags = 1;
        Interpolator mScrollInterpolator;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.AppBarLayout_Layout);
            this.mScrollFlags = a.getInt(R.styleable.AppBarLayout_Layout_layout_scrollFlags, 0);
            if (a.hasValue(R.styleable.AppBarLayout_Layout_layout_scrollInterpolator)) {
                int resId = a.getResourceId(R.styleable.AppBarLayout_Layout_layout_scrollInterpolator, 0);
                this.mScrollInterpolator = android.view.animation.AnimationUtils.loadInterpolator((Context)c, (int)resId);
            }
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(int width, int height, float weight) {
            super(width, height, weight);
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        @RequiresApi(value=19)
        public LayoutParams(LinearLayout.LayoutParams source) {
            super(source);
        }

        @RequiresApi(value=19)
        public LayoutParams(LayoutParams source) {
            super((LinearLayout.LayoutParams)source);
            this.mScrollFlags = source.mScrollFlags;
            this.mScrollInterpolator = source.mScrollInterpolator;
        }

        public void setScrollFlags(int flags) {
            this.mScrollFlags = flags;
        }

        public int getScrollFlags() {
            return this.mScrollFlags;
        }

        public void setScrollInterpolator(Interpolator interpolator) {
            this.mScrollInterpolator = interpolator;
        }

        public Interpolator getScrollInterpolator() {
            return this.mScrollInterpolator;
        }

        boolean isCollapsible() {
            return (this.mScrollFlags & 1) == 1 && (this.mScrollFlags & 0xA) != 0;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static @interface ScrollFlags {
        }
    }

    public static interface OnOffsetChangedListener {
        public void onOffsetChanged(AppBarLayout var1, int var2);
    }
}

