/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.design.R;
import android.support.design.widget.AnimationUtils;
import android.support.design.widget.CircularBorderDrawable;
import android.support.design.widget.ShadowDrawableWrapper;
import android.support.design.widget.ShadowViewDelegate;
import android.support.design.widget.StateListAnimator;
import android.support.design.widget.VisibilityAwareImageButton;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.Interpolator;

@RequiresApi(value=14)
class FloatingActionButtonImpl {
    static final Interpolator ANIM_INTERPOLATOR = AnimationUtils.FAST_OUT_LINEAR_IN_INTERPOLATOR;
    static final long PRESSED_ANIM_DURATION = 100L;
    static final long PRESSED_ANIM_DELAY = 100L;
    static final int ANIM_STATE_NONE = 0;
    static final int ANIM_STATE_HIDING = 1;
    static final int ANIM_STATE_SHOWING = 2;
    int mAnimState = 0;
    private final StateListAnimator mStateListAnimator;
    ShadowDrawableWrapper mShadowDrawable;
    private float mRotation;
    Drawable mShapeDrawable;
    Drawable mRippleDrawable;
    CircularBorderDrawable mBorderDrawable;
    Drawable mContentBackground;
    float mElevation;
    float mPressedTranslationZ;
    static final int SHOW_HIDE_ANIM_DURATION = 200;
    static final int[] PRESSED_ENABLED_STATE_SET = new int[]{16842919, 16842910};
    static final int[] FOCUSED_ENABLED_STATE_SET = new int[]{16842908, 16842910};
    static final int[] ENABLED_STATE_SET = new int[]{16842910};
    static final int[] EMPTY_STATE_SET = new int[0];
    final VisibilityAwareImageButton mView;
    final ShadowViewDelegate mShadowViewDelegate;
    private final Rect mTmpRect = new Rect();
    private ViewTreeObserver.OnPreDrawListener mPreDrawListener;

    FloatingActionButtonImpl(VisibilityAwareImageButton view, ShadowViewDelegate shadowViewDelegate) {
        this.mView = view;
        this.mShadowViewDelegate = shadowViewDelegate;
        this.mStateListAnimator = new StateListAnimator();
        this.mStateListAnimator.addState(PRESSED_ENABLED_STATE_SET, this.createAnimator(new ElevateToTranslationZAnimation()));
        this.mStateListAnimator.addState(FOCUSED_ENABLED_STATE_SET, this.createAnimator(new ElevateToTranslationZAnimation()));
        this.mStateListAnimator.addState(ENABLED_STATE_SET, this.createAnimator(new ResetElevationAnimation()));
        this.mStateListAnimator.addState(EMPTY_STATE_SET, this.createAnimator(new DisabledElevationAnimation()));
        this.mRotation = this.mView.getRotation();
    }

    void setBackgroundDrawable(ColorStateList backgroundTint, PorterDuff.Mode backgroundTintMode, int rippleColor, int borderWidth) {
        Drawable[] layers;
        this.mShapeDrawable = DrawableCompat.wrap((Drawable)this.createShapeDrawable());
        DrawableCompat.setTintList((Drawable)this.mShapeDrawable, (ColorStateList)backgroundTint);
        if (backgroundTintMode != null) {
            DrawableCompat.setTintMode((Drawable)this.mShapeDrawable, (PorterDuff.Mode)backgroundTintMode);
        }
        GradientDrawable touchFeedbackShape = this.createShapeDrawable();
        this.mRippleDrawable = DrawableCompat.wrap((Drawable)touchFeedbackShape);
        DrawableCompat.setTintList((Drawable)this.mRippleDrawable, (ColorStateList)FloatingActionButtonImpl.createColorStateList(rippleColor));
        if (borderWidth > 0) {
            this.mBorderDrawable = this.createBorderDrawable(borderWidth, backgroundTint);
            layers = new Drawable[]{this.mBorderDrawable, this.mShapeDrawable, this.mRippleDrawable};
        } else {
            this.mBorderDrawable = null;
            layers = new Drawable[]{this.mShapeDrawable, this.mRippleDrawable};
        }
        this.mContentBackground = new LayerDrawable(layers);
        this.mShadowDrawable = new ShadowDrawableWrapper(this.mView.getContext(), this.mContentBackground, this.mShadowViewDelegate.getRadius(), this.mElevation, this.mElevation + this.mPressedTranslationZ);
        this.mShadowDrawable.setAddPaddingForCorners(false);
        this.mShadowViewDelegate.setBackgroundDrawable((Drawable)this.mShadowDrawable);
    }

    void setBackgroundTintList(ColorStateList tint) {
        if (this.mShapeDrawable != null) {
            DrawableCompat.setTintList((Drawable)this.mShapeDrawable, (ColorStateList)tint);
        }
        if (this.mBorderDrawable != null) {
            this.mBorderDrawable.setBorderTint(tint);
        }
    }

    void setBackgroundTintMode(PorterDuff.Mode tintMode) {
        if (this.mShapeDrawable != null) {
            DrawableCompat.setTintMode((Drawable)this.mShapeDrawable, (PorterDuff.Mode)tintMode);
        }
    }

    void setRippleColor(int rippleColor) {
        if (this.mRippleDrawable != null) {
            DrawableCompat.setTintList((Drawable)this.mRippleDrawable, (ColorStateList)FloatingActionButtonImpl.createColorStateList(rippleColor));
        }
    }

    final void setElevation(float elevation) {
        if (this.mElevation != elevation) {
            this.mElevation = elevation;
            this.onElevationsChanged(elevation, this.mPressedTranslationZ);
        }
    }

    float getElevation() {
        return this.mElevation;
    }

    final void setPressedTranslationZ(float translationZ) {
        if (this.mPressedTranslationZ != translationZ) {
            this.mPressedTranslationZ = translationZ;
            this.onElevationsChanged(this.mElevation, translationZ);
        }
    }

    void onElevationsChanged(float elevation, float pressedTranslationZ) {
        if (this.mShadowDrawable != null) {
            this.mShadowDrawable.setShadowSize(elevation, elevation + this.mPressedTranslationZ);
            this.updatePadding();
        }
    }

    void onDrawableStateChanged(int[] state) {
        this.mStateListAnimator.setState(state);
    }

    void jumpDrawableToCurrentState() {
        this.mStateListAnimator.jumpToCurrentState();
    }

    void hide(final @Nullable InternalVisibilityChangedListener listener, final boolean fromUser) {
        if (this.isOrWillBeHidden()) {
            return;
        }
        this.mView.animate().cancel();
        if (this.shouldAnimateVisibilityChange()) {
            this.mAnimState = 1;
            this.mView.animate().scaleX(0.0f).scaleY(0.0f).alpha(0.0f).setDuration(200L).setInterpolator((TimeInterpolator)AnimationUtils.FAST_OUT_LINEAR_IN_INTERPOLATOR).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
                private boolean mCancelled;

                public void onAnimationStart(Animator animation) {
                    FloatingActionButtonImpl.this.mView.internalSetVisibility(0, fromUser);
                    this.mCancelled = false;
                }

                public void onAnimationCancel(Animator animation) {
                    this.mCancelled = true;
                }

                public void onAnimationEnd(Animator animation) {
                    FloatingActionButtonImpl.this.mAnimState = 0;
                    if (!this.mCancelled) {
                        FloatingActionButtonImpl.this.mView.internalSetVisibility(fromUser ? 8 : 4, fromUser);
                        if (listener != null) {
                            listener.onHidden();
                        }
                    }
                }
            });
        } else {
            this.mView.internalSetVisibility(fromUser ? 8 : 4, fromUser);
            if (listener != null) {
                listener.onHidden();
            }
        }
    }

    void show(final @Nullable InternalVisibilityChangedListener listener, final boolean fromUser) {
        if (this.isOrWillBeShown()) {
            return;
        }
        this.mView.animate().cancel();
        if (this.shouldAnimateVisibilityChange()) {
            this.mAnimState = 2;
            if (this.mView.getVisibility() != 0) {
                this.mView.setAlpha(0.0f);
                this.mView.setScaleY(0.0f);
                this.mView.setScaleX(0.0f);
            }
            this.mView.animate().scaleX(1.0f).scaleY(1.0f).alpha(1.0f).setDuration(200L).setInterpolator((TimeInterpolator)AnimationUtils.LINEAR_OUT_SLOW_IN_INTERPOLATOR).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    FloatingActionButtonImpl.this.mView.internalSetVisibility(0, fromUser);
                }

                public void onAnimationEnd(Animator animation) {
                    FloatingActionButtonImpl.this.mAnimState = 0;
                    if (listener != null) {
                        listener.onShown();
                    }
                }
            });
        } else {
            this.mView.internalSetVisibility(0, fromUser);
            this.mView.setAlpha(1.0f);
            this.mView.setScaleY(1.0f);
            this.mView.setScaleX(1.0f);
            if (listener != null) {
                listener.onShown();
            }
        }
    }

    final Drawable getContentBackground() {
        return this.mContentBackground;
    }

    void onCompatShadowChanged() {
    }

    final void updatePadding() {
        Rect rect = this.mTmpRect;
        this.getPadding(rect);
        this.onPaddingUpdated(rect);
        this.mShadowViewDelegate.setShadowPadding(rect.left, rect.top, rect.right, rect.bottom);
    }

    void getPadding(Rect rect) {
        this.mShadowDrawable.getPadding(rect);
    }

    void onPaddingUpdated(Rect padding) {
    }

    void onAttachedToWindow() {
        if (this.requirePreDrawListener()) {
            this.ensurePreDrawListener();
            this.mView.getViewTreeObserver().addOnPreDrawListener(this.mPreDrawListener);
        }
    }

    void onDetachedFromWindow() {
        if (this.mPreDrawListener != null) {
            this.mView.getViewTreeObserver().removeOnPreDrawListener(this.mPreDrawListener);
            this.mPreDrawListener = null;
        }
    }

    boolean requirePreDrawListener() {
        return true;
    }

    CircularBorderDrawable createBorderDrawable(int borderWidth, ColorStateList backgroundTint) {
        Context context = this.mView.getContext();
        CircularBorderDrawable borderDrawable = this.newCircularDrawable();
        borderDrawable.setGradientColors(ContextCompat.getColor((Context)context, (int)R.color.design_fab_stroke_top_outer_color), ContextCompat.getColor((Context)context, (int)R.color.design_fab_stroke_top_inner_color), ContextCompat.getColor((Context)context, (int)R.color.design_fab_stroke_end_inner_color), ContextCompat.getColor((Context)context, (int)R.color.design_fab_stroke_end_outer_color));
        borderDrawable.setBorderWidth(borderWidth);
        borderDrawable.setBorderTint(backgroundTint);
        return borderDrawable;
    }

    CircularBorderDrawable newCircularDrawable() {
        return new CircularBorderDrawable();
    }

    void onPreDraw() {
        float rotation = this.mView.getRotation();
        if (this.mRotation != rotation) {
            this.mRotation = rotation;
            this.updateFromViewRotation();
        }
    }

    private void ensurePreDrawListener() {
        if (this.mPreDrawListener == null) {
            this.mPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    FloatingActionButtonImpl.this.onPreDraw();
                    return true;
                }
            };
        }
    }

    GradientDrawable createShapeDrawable() {
        GradientDrawable d = this.newGradientDrawableForShape();
        d.setShape(1);
        d.setColor(-1);
        return d;
    }

    GradientDrawable newGradientDrawableForShape() {
        return new GradientDrawable();
    }

    boolean isOrWillBeShown() {
        if (this.mView.getVisibility() != 0) {
            return this.mAnimState == 2;
        }
        return this.mAnimState != 1;
    }

    boolean isOrWillBeHidden() {
        if (this.mView.getVisibility() == 0) {
            return this.mAnimState == 1;
        }
        return this.mAnimState != 2;
    }

    private ValueAnimator createAnimator(@NonNull ShadowAnimatorImpl impl) {
        ValueAnimator animator = new ValueAnimator();
        animator.setInterpolator((TimeInterpolator)ANIM_INTERPOLATOR);
        animator.setDuration(100L);
        animator.addListener((Animator.AnimatorListener)impl);
        animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)impl);
        animator.setFloatValues(new float[]{0.0f, 1.0f});
        return animator;
    }

    private static ColorStateList createColorStateList(int selectedColor) {
        int[][] states = new int[3][];
        int[] colors = new int[3];
        int i = 0;
        states[i] = FOCUSED_ENABLED_STATE_SET;
        colors[i] = selectedColor;
        states[++i] = PRESSED_ENABLED_STATE_SET;
        colors[i] = selectedColor;
        states[++i] = new int[0];
        colors[i] = 0;
        ++i;
        return new ColorStateList((int[][])states, colors);
    }

    private boolean shouldAnimateVisibilityChange() {
        return ViewCompat.isLaidOut((View)this.mView) && !this.mView.isInEditMode();
    }

    private void updateFromViewRotation() {
        if (Build.VERSION.SDK_INT == 19) {
            if (this.mRotation % 90.0f != 0.0f) {
                if (this.mView.getLayerType() != 1) {
                    this.mView.setLayerType(1, null);
                }
            } else if (this.mView.getLayerType() != 0) {
                this.mView.setLayerType(0, null);
            }
        }
        if (this.mShadowDrawable != null) {
            this.mShadowDrawable.setRotation(-this.mRotation);
        }
        if (this.mBorderDrawable != null) {
            this.mBorderDrawable.setRotation(-this.mRotation);
        }
    }

    private class DisabledElevationAnimation
    extends ShadowAnimatorImpl {
        DisabledElevationAnimation() {
        }

        @Override
        protected float getTargetShadowSize() {
            return 0.0f;
        }
    }

    private class ElevateToTranslationZAnimation
    extends ShadowAnimatorImpl {
        ElevateToTranslationZAnimation() {
        }

        @Override
        protected float getTargetShadowSize() {
            return FloatingActionButtonImpl.this.mElevation + FloatingActionButtonImpl.this.mPressedTranslationZ;
        }
    }

    private class ResetElevationAnimation
    extends ShadowAnimatorImpl {
        ResetElevationAnimation() {
        }

        @Override
        protected float getTargetShadowSize() {
            return FloatingActionButtonImpl.this.mElevation;
        }
    }

    private abstract class ShadowAnimatorImpl
    extends AnimatorListenerAdapter
    implements ValueAnimator.AnimatorUpdateListener {
        private boolean mValidValues;
        private float mShadowSizeStart;
        private float mShadowSizeEnd;

        private ShadowAnimatorImpl() {
        }

        public void onAnimationUpdate(ValueAnimator animator) {
            if (!this.mValidValues) {
                this.mShadowSizeStart = FloatingActionButtonImpl.this.mShadowDrawable.getShadowSize();
                this.mShadowSizeEnd = this.getTargetShadowSize();
                this.mValidValues = true;
            }
            FloatingActionButtonImpl.this.mShadowDrawable.setShadowSize(this.mShadowSizeStart + (this.mShadowSizeEnd - this.mShadowSizeStart) * animator.getAnimatedFraction());
        }

        public void onAnimationEnd(Animator animator) {
            FloatingActionButtonImpl.this.mShadowDrawable.setShadowSize(this.mShadowSizeEnd);
            this.mValidValues = false;
        }

        protected abstract float getTargetShadowSize();
    }

    static interface InternalVisibilityChangedListener {
        public void onShown();

        public void onHidden();
    }
}

