/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.support.annotation.RestrictTo;
import android.util.StateSet;
import java.util.ArrayList;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class StateListAnimator {
    private final ArrayList<Tuple> tuples = new ArrayList();
    private Tuple lastMatch = null;
    ValueAnimator runningAnimator = null;
    private final Animator.AnimatorListener animationListener = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animator2) {
            if (StateListAnimator.this.runningAnimator == animator2) {
                StateListAnimator.this.runningAnimator = null;
            }
        }
    };

    public void addState(int[] specs, ValueAnimator animator2) {
        Tuple tuple = new Tuple(specs, animator2);
        animator2.addListener(this.animationListener);
        this.tuples.add(tuple);
    }

    public void setState(int[] state) {
        Tuple match = null;
        int count = this.tuples.size();
        for (int i = 0; i < count; ++i) {
            Tuple tuple = this.tuples.get(i);
            if (!StateSet.stateSetMatches((int[])tuple.specs, (int[])state)) continue;
            match = tuple;
            break;
        }
        if (match == this.lastMatch) {
            return;
        }
        if (this.lastMatch != null) {
            this.cancel();
        }
        this.lastMatch = match;
        if (match != null) {
            this.start(match);
        }
    }

    private void start(Tuple match) {
        this.runningAnimator = match.animator;
        this.runningAnimator.start();
    }

    private void cancel() {
        if (this.runningAnimator != null) {
            this.runningAnimator.cancel();
            this.runningAnimator = null;
        }
    }

    public void jumpToCurrentState() {
        if (this.runningAnimator != null) {
            this.runningAnimator.end();
            this.runningAnimator = null;
        }
    }

    static class Tuple {
        final int[] specs;
        final ValueAnimator animator;

        Tuple(int[] specs, ValueAnimator animator2) {
            this.specs = specs;
            this.animator = animator2;
        }
    }
}

