/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.res.TypedArrayUtils;
import android.support.v4.util.SimpleArrayMap;
import android.support.v7.preference.Preference;
import android.support.v7.preference.PreferenceManager;
import android.support.v7.preference.R;
import android.text.TextUtils;
import android.util.AttributeSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class PreferenceGroup
extends Preference {
    private List<Preference> mPreferenceList;
    private boolean mOrderingAsAdded = true;
    private int mCurrentPreferenceOrder = 0;
    private boolean mAttachedToHierarchy = false;
    private int mInitialExpandedChildrenCount = Integer.MAX_VALUE;
    private PreferenceInstanceStateCallback mPreferenceInstanceStateCallback;
    private final SimpleArrayMap<String, Long> mIdRecycleCache = new SimpleArrayMap();
    private final Handler mHandler = new Handler();
    private final Runnable mClearRecycleCacheRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            1 var1_1 = this;
            synchronized (var1_1) {
                PreferenceGroup.this.mIdRecycleCache.clear();
            }
        }
    };

    public PreferenceGroup(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mPreferenceList = new ArrayList<Preference>();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PreferenceGroup, defStyleAttr, defStyleRes);
        this.mOrderingAsAdded = TypedArrayUtils.getBoolean((TypedArray)a, (int)R.styleable.PreferenceGroup_orderingFromXml, (int)R.styleable.PreferenceGroup_orderingFromXml, (boolean)true);
        if (a.hasValue(R.styleable.PreferenceGroup_initialExpandedChildrenCount)) {
            this.mInitialExpandedChildrenCount = TypedArrayUtils.getInt((TypedArray)a, (int)R.styleable.PreferenceGroup_initialExpandedChildrenCount, (int)R.styleable.PreferenceGroup_initialExpandedChildrenCount, (int)-1);
        }
        a.recycle();
    }

    public PreferenceGroup(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public PreferenceGroup(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public void setOrderingAsAdded(boolean orderingAsAdded) {
        this.mOrderingAsAdded = orderingAsAdded;
    }

    public boolean isOrderingAsAdded() {
        return this.mOrderingAsAdded;
    }

    public void setInitialExpandedChildrenCount(int expandedCount) {
        this.mInitialExpandedChildrenCount = expandedCount;
    }

    public int getInitialExpandedChildrenCount() {
        return this.mInitialExpandedChildrenCount;
    }

    public void addItemFromInflater(Preference preference) {
        this.addPreference(preference);
    }

    public int getPreferenceCount() {
        return this.mPreferenceList.size();
    }

    public Preference getPreference(int index) {
        return this.mPreferenceList.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPreference(Preference preference) {
        long id2;
        int insertionIndex;
        if (this.mPreferenceList.contains(preference)) {
            return true;
        }
        if (preference.getOrder() == Integer.MAX_VALUE) {
            if (this.mOrderingAsAdded) {
                preference.setOrder(this.mCurrentPreferenceOrder++);
            }
            if (preference instanceof PreferenceGroup) {
                ((PreferenceGroup)preference).setOrderingAsAdded(this.mOrderingAsAdded);
            }
        }
        if ((insertionIndex = Collections.binarySearch(this.mPreferenceList, preference)) < 0) {
            insertionIndex = insertionIndex * -1 - 1;
        }
        if (!this.onPrepareAddPreference(preference)) {
            return false;
        }
        PreferenceGroup preferenceGroup = this;
        synchronized (preferenceGroup) {
            this.mPreferenceList.add(insertionIndex, preference);
        }
        PreferenceManager preferenceManager = this.getPreferenceManager();
        String key = preference.getKey();
        if (key != null && this.mIdRecycleCache.containsKey((Object)key)) {
            id2 = (Long)this.mIdRecycleCache.get((Object)key);
            this.mIdRecycleCache.remove((Object)key);
        } else {
            id2 = preferenceManager.getNextId();
        }
        preference.onAttachedToHierarchy(preferenceManager, id2);
        preference.assignParent(this);
        if (this.mAttachedToHierarchy) {
            preference.onAttached();
        }
        this.notifyHierarchyChanged();
        return true;
    }

    public boolean removePreference(Preference preference) {
        boolean returnValue = this.removePreferenceInt(preference);
        this.notifyHierarchyChanged();
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removePreferenceInt(Preference preference) {
        PreferenceGroup preferenceGroup = this;
        synchronized (preferenceGroup) {
            boolean success;
            preference.onPrepareForRemoval();
            if (preference.getParent() == this) {
                preference.assignParent(null);
            }
            if (success = this.mPreferenceList.remove(preference)) {
                String key = preference.getKey();
                if (key != null) {
                    this.mIdRecycleCache.put((Object)key, (Object)preference.getId());
                    this.mHandler.removeCallbacks(this.mClearRecycleCacheRunnable);
                    this.mHandler.post(this.mClearRecycleCacheRunnable);
                }
                if (this.mAttachedToHierarchy) {
                    preference.onDetached();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        PreferenceGroup preferenceGroup = this;
        synchronized (preferenceGroup) {
            List<Preference> preferenceList = this.mPreferenceList;
            for (int i = preferenceList.size() - 1; i >= 0; --i) {
                this.removePreferenceInt(preferenceList.get(0));
            }
        }
        this.notifyHierarchyChanged();
    }

    protected boolean onPrepareAddPreference(Preference preference) {
        preference.onParentChanged(this, this.shouldDisableDependents());
        return true;
    }

    public Preference findPreference(CharSequence key) {
        if (TextUtils.equals((CharSequence)this.getKey(), (CharSequence)key)) {
            return this;
        }
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            Preference returnedPreference;
            Preference preference = this.getPreference(i);
            String curKey = preference.getKey();
            if (curKey != null && curKey.equals(key)) {
                return preference;
            }
            if (!(preference instanceof PreferenceGroup) || (returnedPreference = ((PreferenceGroup)preference).findPreference(key)) == null) continue;
            return returnedPreference;
        }
        return null;
    }

    protected boolean isOnSameScreenAsChildren() {
        return true;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isAttached() {
        return this.mAttachedToHierarchy;
    }

    @Override
    public void onAttached() {
        super.onAttached();
        this.mAttachedToHierarchy = true;
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            this.getPreference(i).onAttached();
        }
    }

    @Override
    public void onDetached() {
        super.onDetached();
        this.mAttachedToHierarchy = false;
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            this.getPreference(i).onDetached();
        }
    }

    @Override
    public void notifyDependencyChange(boolean disableDependents) {
        super.notifyDependencyChange(disableDependents);
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            this.getPreference(i).onParentChanged(this, disableDependents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sortPreferences() {
        PreferenceGroup preferenceGroup = this;
        synchronized (preferenceGroup) {
            Collections.sort(this.mPreferenceList);
        }
    }

    @Override
    protected void dispatchSaveInstanceState(Bundle container) {
        super.dispatchSaveInstanceState(container);
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            this.getPreference(i).dispatchSaveInstanceState(container);
        }
    }

    @Override
    protected void dispatchRestoreInstanceState(Bundle container) {
        super.dispatchRestoreInstanceState(container);
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            this.getPreference(i).dispatchRestoreInstanceState(container);
        }
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (this.mPreferenceInstanceStateCallback != null) {
            return this.mPreferenceInstanceStateCallback.saveInstanceState(superState);
        }
        return superState;
    }

    @Override
    protected void onRestoreInstanceState(Parcelable state) {
        if (this.mPreferenceInstanceStateCallback != null) {
            state = this.mPreferenceInstanceStateCallback.restoreInstanceState(state);
        }
        super.onRestoreInstanceState(state);
    }

    final void setPreferenceInstanceStateCallback(PreferenceInstanceStateCallback callback) {
        this.mPreferenceInstanceStateCallback = callback;
    }

    @VisibleForTesting
    final PreferenceInstanceStateCallback getPreferenceInstanceStateCallback() {
        return this.mPreferenceInstanceStateCallback;
    }

    static interface PreferenceInstanceStateCallback {
        public Parcelable saveInstanceState(Parcelable var1);

        public Parcelable restoreInstanceState(Parcelable var1);
    }

    public static interface PreferencePositionCallback {
        public int getPreferenceAdapterPosition(String var1);

        public int getPreferenceAdapterPosition(Preference var1);
    }
}

