/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.runner.screenshot;

import android.graphics.Bitmap;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import android.view.View;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;

final class TakeScreenshotCallable
implements Callable<Bitmap> {
    private static final String TAG = "TakeScreenshotCallable";
    private WeakReference<View> mViewRef;

    private TakeScreenshotCallable(View view) {
        this.mViewRef = new WeakReference<View>(view);
    }

    @Override
    public Bitmap call() {
        Bitmap bitmap = null;
        ((View)this.mViewRef.get()).setDrawingCacheEnabled(true);
        try {
            bitmap = Bitmap.createBitmap((Bitmap)((View)this.mViewRef.get()).getDrawingCache());
        }
        catch (OutOfMemoryError omm) {
            Log.e((String)TAG, (String)"Out of memory exception while trying to take a screenshot.", (Throwable)omm);
        }
        finally {
            ((View)this.mViewRef.get()).setDrawingCacheEnabled(false);
        }
        return bitmap;
    }

    @VisibleForTesting
    static class Factory {
        Factory() {
        }

        Callable<Bitmap> create(View view) {
            return new TakeScreenshotCallable(view);
        }
    }
}

