/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.content.Context;
import android.os.Build;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.transition.R;
import android.support.transition.SceneApi21;
import android.support.transition.SceneIcs;
import android.support.transition.SceneImpl;
import android.support.transition.SceneKitKat;
import android.support.transition.SceneStaticsApi21;
import android.support.transition.SceneStaticsIcs;
import android.support.transition.SceneStaticsImpl;
import android.support.transition.SceneStaticsKitKat;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;

public class Scene {
    private static SceneStaticsImpl sImpl = Build.VERSION.SDK_INT >= 21 ? new SceneStaticsApi21() : (Build.VERSION.SDK_INT >= 19 ? new SceneStaticsKitKat() : new SceneStaticsIcs());
    SceneImpl mImpl;

    public Scene(@NonNull ViewGroup sceneRoot) {
        this.mImpl = this.createSceneImpl();
        this.mImpl.init(sceneRoot);
    }

    public Scene(@NonNull ViewGroup sceneRoot, @NonNull View layout) {
        this.mImpl = this.createSceneImpl();
        this.mImpl.init(sceneRoot, layout);
    }

    private Scene(SceneImpl scene) {
        this.mImpl = scene;
    }

    @NonNull
    public static Scene getSceneForLayout(@NonNull ViewGroup sceneRoot, @LayoutRes int layoutId, @NonNull Context context) {
        Scene scene;
        SparseArray scenes = (SparseArray)sceneRoot.getTag(R.id.transition_scene_layoutid_cache);
        if (scenes == null) {
            scenes = new SparseArray();
            sceneRoot.setTag(R.id.transition_scene_layoutid_cache, (Object)scenes);
        }
        if ((scene = (Scene)scenes.get(layoutId)) != null) {
            return scene;
        }
        scene = new Scene(sImpl.getSceneForLayout(sceneRoot, layoutId, context));
        scenes.put(layoutId, (Object)scene);
        return scene;
    }

    private SceneImpl createSceneImpl() {
        if (Build.VERSION.SDK_INT >= 21) {
            return new SceneApi21();
        }
        if (Build.VERSION.SDK_INT >= 19) {
            return new SceneKitKat();
        }
        return new SceneIcs();
    }

    @NonNull
    public ViewGroup getSceneRoot() {
        return this.mImpl.getSceneRoot();
    }

    public void exit() {
        this.mImpl.exit();
    }

    public void enter() {
        this.mImpl.enter();
    }

    public void setEnterAction(@Nullable Runnable action) {
        this.mImpl.setEnterAction(action);
    }

    public void setExitAction(@Nullable Runnable action) {
        this.mImpl.setExitAction(action);
    }
}

