/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.graphics.Matrix;
import android.os.Build;
import android.support.transition.MatrixUtils;
import android.support.transition.R;
import android.util.Log;
import android.widget.ImageView;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class ImageViewUtils {
    private static final String TAG = "ImageViewUtils";
    private static Method sAnimateTransformMethod;
    private static boolean sAnimateTransformMethodFetched;

    static void startAnimateTransform(ImageView view) {
        if (Build.VERSION.SDK_INT < 21) {
            ImageView.ScaleType scaleType = view.getScaleType();
            view.setTag(R.id.save_scale_type, (Object)scaleType);
            if (scaleType == ImageView.ScaleType.MATRIX) {
                view.setTag(R.id.save_image_matrix, (Object)view.getImageMatrix());
            } else {
                view.setScaleType(ImageView.ScaleType.MATRIX);
            }
            view.setImageMatrix(MatrixUtils.IDENTITY_MATRIX);
        }
    }

    static void animateTransform(ImageView view, Matrix matrix) {
        if (Build.VERSION.SDK_INT < 21) {
            view.setImageMatrix(matrix);
        } else {
            ImageViewUtils.fetchAnimateTransformMethod();
            if (sAnimateTransformMethod != null) {
                try {
                    sAnimateTransformMethod.invoke((Object)view, matrix);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e.getCause());
                }
            }
        }
    }

    private static void fetchAnimateTransformMethod() {
        if (!sAnimateTransformMethodFetched) {
            try {
                sAnimateTransformMethod = ImageView.class.getDeclaredMethod("animateTransform", Matrix.class);
                sAnimateTransformMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                Log.i((String)TAG, (String)"Failed to retrieve animateTransform method", (Throwable)e);
            }
            sAnimateTransformMethodFetched = true;
        }
    }

    static void reserveEndAnimateTransform(final ImageView view, Animator animator) {
        if (Build.VERSION.SDK_INT < 21) {
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    ImageView.ScaleType scaleType = (ImageView.ScaleType)view.getTag(R.id.save_scale_type);
                    view.setScaleType(scaleType);
                    view.setTag(R.id.save_scale_type, null);
                    if (scaleType == ImageView.ScaleType.MATRIX) {
                        view.setImageMatrix((Matrix)view.getTag(R.id.save_image_matrix));
                        view.setTag(R.id.save_image_matrix, null);
                    }
                    animation.removeListener((Animator.AnimatorListener)this);
                }
            });
        }
    }

    private ImageViewUtils() {
    }
}

