/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.nio.charset.Charset;

public class Anonymizer {
    public static String anonymizeUtf8(ILogger logger, String data) throws IOException {
        return Anonymizer.anonymize(logger, data, Charsets.UTF_8);
    }

    public static String anonymize(ILogger logger, String data, Charset charset) throws IOException {
        if (Strings.isNullOrEmpty((String)data)) {
            return "";
        }
        Hasher hasher = Hashing.sha256().newHasher();
        hasher.putBytes(AnalyticsSettings.getInstance(logger).getSalt());
        hasher.putString((CharSequence)data, charset);
        return hasher.hash().toString();
    }
}

