/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.CommonMetricsDataKt;
import com.android.tools.analytics.Environment;
import com.android.tools.analytics.HostData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.google.wireless.android.sdk.stats.GarbageCollectionStats;
import com.google.wireless.android.sdk.stats.JavaProcessStats;
import com.google.wireless.android.sdk.stats.JvmDetails;
import com.google.wireless.android.sdk.stats.ProductDetails;
import java.io.File;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001IB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010=\u001a\u00020>2\b\u0010?\u001a\u0004\u0018\u00010\rH\u0007J\u0012\u0010@\u001a\u00020*2\b\u0010A\u001a\u0004\u0018\u00010\rH\u0007J\u0018\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\r2\u0006\u0010E\u001a\u00020FH\u0003J\u0010\u0010G\u001a\u00020\u00062\u0006\u0010H\u001a\u00020\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001b\u0010\u0002\u001a\u0004\b\u001c\u0010\u001dR(\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020 0\u001f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b!\u0010\u0002\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b&\u0010\u0002\u001a\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b+\u0010\u0002\u001a\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020/8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b0\u0010\u0002\u001a\u0004\b1\u00102R\u001c\u00103\u001a\u0004\u0018\u00010\r8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b4\u0010\u0002\u001a\u0004\b5\u00106R\u001a\u00107\u001a\u00020*8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b8\u0010\u0002\u001a\u0004\b9\u0010-R\u001a\u0010:\u001a\u00020\r8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b;\u0010\u0002\u001a\u0004\b<\u00106\u00a8\u0006J"}, d2={"Lcom/android/tools/analytics/CommonMetricsData;", "", "()V", "EMPTY_SIZE", "", "GIGABYTE", "", "INVALID_NUMBER", "INVALID_POSTFIX", "KILOBYTE", "MEGABYTE", "NO_DIGITS", "OS_NAME_CHROMIUM", "", "OS_NAME_FREE_BSD", "OS_NAME_LINUX", "OS_NAME_MAC", "OS_NAME_WINDOWS", "TERABYTE", "VM_OPTION_MAX_PERM_SIZE", "VM_OPTION_RESERVED_CODE_CACHE_SIZE", "VM_OPTION_SOFT_REF_LRU_POLICY_MS_PER_MB", "VM_OPTION_XMS", "VM_OPTION_XMX", "garbageCollectionStats", "", "Lcom/google/wireless/android/sdk/stats/GarbageCollectionStats;", "getGarbageCollectionStats$annotations", "getGarbageCollectionStats", "()Ljava/util/List;", "garbageCollectionStatsCache", "Ljava/util/HashMap;", "Lcom/android/tools/analytics/CommonMetricsData$GarbageCollectionStatsDiffs;", "getGarbageCollectionStatsCache$annotations", "getGarbageCollectionStatsCache", "()Ljava/util/HashMap;", "javaProcessStats", "Lcom/google/wireless/android/sdk/stats/JavaProcessStats;", "getJavaProcessStats$annotations", "getJavaProcessStats", "()Lcom/google/wireless/android/sdk/stats/JavaProcessStats;", "jvmArchitecture", "Lcom/google/wireless/android/sdk/stats/ProductDetails$CpuArchitecture;", "getJvmArchitecture$annotations", "getJvmArchitecture", "()Lcom/google/wireless/android/sdk/stats/ProductDetails$CpuArchitecture;", "jvmDetails", "Lcom/google/wireless/android/sdk/stats/JvmDetails;", "getJvmDetails$annotations", "getJvmDetails", "()Lcom/google/wireless/android/sdk/stats/JvmDetails;", "majorOsVersion", "getMajorOsVersion$annotations", "getMajorOsVersion", "()Ljava/lang/String;", "osArchitecture", "getOsArchitecture$annotations", "getOsArchitecture", "osName", "getOsName$annotations", "getOsName", "applicationBinaryInterfaceFromString", "Lcom/google/wireless/android/sdk/stats/DeviceInfo$ApplicationBinaryInterface;", "value", "cpuArchitectureFromString", "cpuArchitecture", "parseVmOption", "", "vmOption", "builder", "Lcom/google/wireless/android/sdk/stats/JvmDetails$Builder;", "parseVmOptionSize", "vmOptionSize", "GarbageCollectionStatsDiffs", "shared"})
public final class CommonMetricsData {
    @NotNull
    public static final CommonMetricsData INSTANCE = new CommonMetricsData();
    @NotNull
    public static final String VM_OPTION_XMS = "-Xms";
    @NotNull
    public static final String VM_OPTION_XMX = "-Xmx";
    @NotNull
    public static final String VM_OPTION_MAX_PERM_SIZE = "-XX:MaxPermSize=";
    @NotNull
    public static final String VM_OPTION_RESERVED_CODE_CACHE_SIZE = "-XX:ReservedCodeCacheSize=";
    @NotNull
    public static final String VM_OPTION_SOFT_REF_LRU_POLICY_MS_PER_MB = "-XX:SoftRefLRUPolicyMSPerMB=";
    public static final long KILOBYTE = 1024L;
    public static final long MEGABYTE = 0x100000L;
    public static final long GIGABYTE = 0x40000000L;
    public static final long TERABYTE = 0x10000000000L;
    public static final int NO_DIGITS = -1;
    public static final int INVALID_POSTFIX = -2;
    public static final int INVALID_NUMBER = -3;
    public static final int EMPTY_SIZE = -4;
    @NotNull
    public static final String OS_NAME_FREE_BSD = "freebsd";
    @NotNull
    public static final String OS_NAME_LINUX = "linux";
    @NotNull
    public static final String OS_NAME_MAC = "macosx";
    @NotNull
    public static final String OS_NAME_WINDOWS = "windows";
    @NotNull
    public static final String OS_NAME_CHROMIUM = "chromium";
    @NotNull
    private static final HashMap<String, GarbageCollectionStatsDiffs> garbageCollectionStatsCache = new HashMap();

    private CommonMetricsData() {
    }

    @NotNull
    public static final HashMap<String, GarbageCollectionStatsDiffs> getGarbageCollectionStatsCache() {
        return garbageCollectionStatsCache;
    }

    @VisibleForTesting
    @JvmStatic
    public static /* synthetic */ void getGarbageCollectionStatsCache$annotations() {
    }

    @NotNull
    public static final ProductDetails.CpuArchitecture getOsArchitecture() {
        ProductDetails.CpuArchitecture jvmArchitecture = INSTANCE.getJvmArchitecture();
        String string = Environment.Companion.getInstance().getSystemProperty(Environment.SystemProperty.OS_NAME);
        Intrinsics.checkNotNull((Object)string);
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String os = string2;
        if (jvmArchitecture == ProductDetails.CpuArchitecture.X86_64 && StringsKt.startsWith$default((String)os, (String)"mac", (boolean)false, (int)2, null) && CommonMetricsDataKt.isRosetta()) {
            return ProductDetails.CpuArchitecture.X86_ON_ARM;
        }
        if (jvmArchitecture == ProductDetails.CpuArchitecture.X86) {
            if (StringsKt.startsWith$default((String)os, (String)"win", (boolean)false, (int)2, null)) {
                String w6432 = Environment.Companion.getInstance().getVariable(Environment.EnvironmentVariable.PROCESSOR_ARCHITEW6432);
                if (w6432 != null && StringsKt.contains$default((CharSequence)w6432, (CharSequence)"64", (boolean)false, (int)2, null)) {
                    return ProductDetails.CpuArchitecture.X86_64;
                }
            } else if (StringsKt.startsWith$default((String)os, (String)OS_NAME_LINUX, (boolean)false, (int)2, null)) {
                String s = Environment.Companion.getInstance().getVariable(Environment.EnvironmentVariable.HOSTTYPE);
                return CommonMetricsData.cpuArchitectureFromString(s);
            }
        }
        return jvmArchitecture;
    }

    @JvmStatic
    public static /* synthetic */ void getOsArchitecture$annotations() {
    }

    @NotNull
    public static final ProductDetails.CpuArchitecture getJvmArchitecture() {
        String arch = Environment.Companion.getInstance().getSystemProperty(Environment.SystemProperty.OS_ARCH);
        return CommonMetricsData.cpuArchitectureFromString(arch);
    }

    @JvmStatic
    public static /* synthetic */ void getJvmArchitecture$annotations() {
    }

    @NotNull
    public static final String getOsName() {
        String os = Environment.Companion.getInstance().getSystemProperty(Environment.SystemProperty.OS_NAME);
        if (os == null || ((CharSequence)os).length() == 0) {
            return "unknown";
        }
        String string = os;
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String osLower = string2;
        if (StringsKt.startsWith$default((String)osLower, (String)"mac", (boolean)false, (int)2, null)) {
            os = OS_NAME_MAC;
        } else if (StringsKt.startsWith$default((String)osLower, (String)"win", (boolean)false, (int)2, null)) {
            os = OS_NAME_WINDOWS;
        } else if (StringsKt.startsWith$default((String)osLower, (String)OS_NAME_LINUX, (boolean)false, (int)2, null)) {
            os = new File("/dev/.cros_milestone").exists() ? OS_NAME_CHROMIUM : OS_NAME_LINUX;
        } else if (os.length() > 32) {
            String string3 = os.substring(0, 32);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            os = string3;
        }
        return os;
    }

    @JvmStatic
    public static /* synthetic */ void getOsName$annotations() {
    }

    @Nullable
    public static final String getMajorOsVersion() {
        Matcher m;
        if (Intrinsics.areEqual((Object)INSTANCE.getOsName(), (Object)OS_NAME_CHROMIUM)) {
            return FilesKt.readText((File)new File("/dev/.cros_milestone"), (Charset)Charsets.UTF_8);
        }
        Pattern p = Pattern.compile("(\\d+)\\.(\\d+).*");
        String osVers = Environment.Companion.getInstance().getSystemProperty(Environment.SystemProperty.OS_VERSION);
        if (osVers != null && ((CharSequence)osVers).length() > 0 && (m = p.matcher(osVers)).matches()) {
            return m.group(1) + "." + m.group(2);
        }
        return null;
    }

    @JvmStatic
    public static /* synthetic */ void getMajorOsVersion$annotations() {
    }

    @NotNull
    public static final JvmDetails getJvmDetails() {
        RuntimeMXBean runtimeMXBean = HostData.getRuntimeBean();
        Intrinsics.checkNotNull((Object)runtimeMXBean);
        RuntimeMXBean runtime = runtimeMXBean;
        JvmDetails.Builder builder = JvmDetails.newBuilder().setName(Strings.nullToEmpty((String)runtime.getVmName())).setVendor(Strings.nullToEmpty((String)runtime.getVmVendor())).setVersion(Strings.nullToEmpty((String)runtime.getVmVersion()));
        for (String vmOption : runtime.getInputArguments()) {
            Intrinsics.checkNotNullExpressionValue((Object)vmOption, (String)"vmOption");
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
            CommonMetricsData.parseVmOption(vmOption, builder);
        }
        JvmDetails jvmDetails = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)jvmDetails, (String)"builder.build()");
        return jvmDetails;
    }

    @JvmStatic
    public static /* synthetic */ void getJvmDetails$annotations() {
    }

    @NotNull
    public static final JavaProcessStats getJavaProcessStats() {
        MemoryMXBean memoryMXBean = HostData.getMemoryBean();
        Intrinsics.checkNotNull((Object)memoryMXBean);
        MemoryMXBean memoryBean2 = memoryMXBean;
        ClassLoadingMXBean classLoadingMXBean = HostData.getClassLoadingBean();
        Intrinsics.checkNotNull((Object)classLoadingMXBean);
        ClassLoadingMXBean classLoadingBean2 = classLoadingMXBean;
        JavaProcessStats.Builder builder = JavaProcessStats.newBuilder().setHeapMemoryUsage(memoryBean2.getHeapMemoryUsage().getUsed()).setNonHeapMemoryUsage(memoryBean2.getNonHeapMemoryUsage().getUsed()).setLoadedClassCount(classLoadingBean2.getLoadedClassCount()).addAllGarbageCollectionStats((Iterable)INSTANCE.getGarbageCollectionStats());
        ThreadMXBean threadMXBean = HostData.getThreadBean();
        Intrinsics.checkNotNull((Object)threadMXBean);
        JavaProcessStats javaProcessStats = builder.setThreadCount(threadMXBean.getThreadCount()).build();
        Intrinsics.checkNotNullExpressionValue((Object)javaProcessStats, (String)"newBuilder()\n        .se\u2026adCount)\n        .build()");
        return javaProcessStats;
    }

    @JvmStatic
    public static /* synthetic */ void getJavaProcessStats$annotations() {
    }

    @NotNull
    public static final List<GarbageCollectionStats> getGarbageCollectionStats() {
        ArrayList<GarbageCollectionStats> stats = new ArrayList<GarbageCollectionStats>();
        List<GarbageCollectorMXBean> list = HostData.getGarbageCollectorBeans();
        Intrinsics.checkNotNull(list);
        for (GarbageCollectorMXBean gc : list) {
            String name = gc.getName();
            GarbageCollectionStatsDiffs previous = garbageCollectionStatsCache.get(name);
            if (previous == null) {
                previous = new GarbageCollectionStatsDiffs();
            }
            GarbageCollectionStatsDiffs current = new GarbageCollectionStatsDiffs();
            current.setCollections(gc.getCollectionCount());
            long collectionsDiff = current.getCollections() - previous.getCollections();
            current.setTime(gc.getCollectionTime());
            long timeDiff = current.getTime() - previous.getTime();
            Map map = garbageCollectionStatsCache;
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            map.put(name, current);
            stats.add(GarbageCollectionStats.newBuilder().setName(gc.getName()).setGcCollections(collectionsDiff).setGcTime(timeDiff).build());
        }
        return stats;
    }

    @JvmStatic
    @VisibleForTesting
    public static /* synthetic */ void getGarbageCollectionStats$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final ProductDetails.CpuArchitecture cpuArchitectureFromString(@Nullable String cpuArchitecture) {
        if (cpuArchitecture == null || ((CharSequence)cpuArchitecture).length() == 0) {
            return ProductDetails.CpuArchitecture.UNKNOWN_CPU_ARCHITECTURE;
        }
        if (StringsKt.equals((String)cpuArchitecture, (String)"x86_64", (boolean)true) || StringsKt.equals((String)cpuArchitecture, (String)"ia64", (boolean)true) || StringsKt.equals((String)cpuArchitecture, (String)"amd64", (boolean)true)) {
            return ProductDetails.CpuArchitecture.X86_64;
        }
        if (StringsKt.equals((String)cpuArchitecture, (String)"x86", (boolean)true)) {
            return ProductDetails.CpuArchitecture.X86;
        }
        if (StringsKt.equals((String)cpuArchitecture, (String)"aarch64", (boolean)true)) {
            return ProductDetails.CpuArchitecture.ARM;
        }
        return cpuArchitecture.length() == 4 && cpuArchitecture.charAt(0) == 'i' && StringsKt.indexOf$default((CharSequence)cpuArchitecture, (String)"86", (int)0, (boolean)false, (int)6, null) == 2 ? ProductDetails.CpuArchitecture.X86 : ProductDetails.CpuArchitecture.UNKNOWN_CPU_ARCHITECTURE;
    }

    @JvmStatic
    @NotNull
    public static final DeviceInfo.ApplicationBinaryInterface applicationBinaryInterfaceFromString(@Nullable String value) {
        DeviceInfo.ApplicationBinaryInterface applicationBinaryInterface;
        if (value == null) {
            return DeviceInfo.ApplicationBinaryInterface.UNKNOWN_ABI;
        }
        switch (value) {
            case "armeabi-v6j": {
                applicationBinaryInterface = DeviceInfo.ApplicationBinaryInterface.ARME_ABI_V6J;
                break;
            }
            case "armeabi-v6l": {
                applicationBinaryInterface = DeviceInfo.ApplicationBinaryInterface.ARME_ABI_V6L;
                break;
            }
            case "armeabi-v7a": {
                applicationBinaryInterface = DeviceInfo.ApplicationBinaryInterface.ARME_ABI_V7A;
                break;
            }
            case "armeabi": {
                applicationBinaryInterface = DeviceInfo.ApplicationBinaryInterface.ARME_ABI;
                break;
            }
            case "arm64-v8a": {
                applicationBinaryInterface = DeviceInfo.ApplicationBinaryInterface.ARM64_V8A_ABI;
                break;
            }
            case "mips": {
                applicationBinaryInterface = DeviceInfo.ApplicationBinaryInterface.MIPS_ABI;
                break;
            }
            case "mips-r2": {
                applicationBinaryInterface = DeviceInfo.ApplicationBinaryInterface.MIPS_R2_ABI;
                break;
            }
            case "x86": {
                applicationBinaryInterface = DeviceInfo.ApplicationBinaryInterface.X86_ABI;
                break;
            }
            case "x86_64": {
                applicationBinaryInterface = DeviceInfo.ApplicationBinaryInterface.X86_64_ABI;
                break;
            }
            default: {
                applicationBinaryInterface = DeviceInfo.ApplicationBinaryInterface.UNKNOWN_ABI;
            }
        }
        return applicationBinaryInterface;
    }

    @JvmStatic
    private static final void parseVmOption(String vmOption, JvmDetails.Builder builder) {
        if (StringsKt.startsWith$default((String)vmOption, (String)VM_OPTION_XMS, (boolean)false, (int)2, null)) {
            String string = vmOption.substring(4);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            builder.setMinimumHeapSize(CommonMetricsData.parseVmOptionSize(string));
        } else if (StringsKt.startsWith$default((String)vmOption, (String)VM_OPTION_XMX, (boolean)false, (int)2, null)) {
            String string = vmOption.substring(4);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            builder.setMaximumHeapSize(CommonMetricsData.parseVmOptionSize(string));
        } else if (StringsKt.startsWith$default((String)vmOption, (String)VM_OPTION_MAX_PERM_SIZE, (boolean)false, (int)2, null)) {
            String string = vmOption.substring(16);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            builder.setMaximumPermanentSpaceSize(CommonMetricsData.parseVmOptionSize(string));
        } else if (StringsKt.startsWith$default((String)vmOption, (String)VM_OPTION_RESERVED_CODE_CACHE_SIZE, (boolean)false, (int)2, null)) {
            String string = vmOption.substring(26);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            builder.setMaximumCodeCacheSize(CommonMetricsData.parseVmOptionSize(string));
        } else if (StringsKt.startsWith$default((String)vmOption, (String)VM_OPTION_SOFT_REF_LRU_POLICY_MS_PER_MB, (boolean)false, (int)2, null)) {
            String string = vmOption.substring(28);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            builder.setSoftReferenceLruPolicy(CommonMetricsData.parseVmOptionSize(string));
        }
        switch (vmOption) {
            case "-XX:+UseConcMarkSweepGC": {
                builder.setGarbageCollector(JvmDetails.GarbageCollector.CONCURRENT_MARK_SWEEP_GC);
                break;
            }
            case "-XX:+UseParallelGC": {
                builder.setGarbageCollector(JvmDetails.GarbageCollector.PARALLEL_GC);
                break;
            }
            case "-XX:+UseParallelOldGC": {
                builder.setGarbageCollector(JvmDetails.GarbageCollector.PARALLEL_OLD_GC);
                break;
            }
            case "-XX:+UseSerialGC": {
                builder.setGarbageCollector(JvmDetails.GarbageCollector.SERIAL_GC);
                break;
            }
            case "-XX:+UseG1GC": {
                builder.setGarbageCollector(JvmDetails.GarbageCollector.SERIAL_GC);
            }
        }
    }

    @VisibleForTesting
    @JvmStatic
    public static final long parseVmOptionSize(@NotNull String vmOptionSize) {
        Intrinsics.checkNotNullParameter((Object)vmOptionSize, (String)"vmOptionSize");
        if (Strings.isNullOrEmpty((String)vmOptionSize)) {
            return -4L;
        }
        try {
            int n = vmOptionSize.length();
            for (int i = 0; i < n; ++i) {
                char c = vmOptionSize.charAt(i);
                if (Character.isDigit(c)) continue;
                if (i == 0) {
                    return -1L;
                }
                String string = vmOptionSize.substring(0, i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String digits = string;
                long value = Long.parseLong(digits);
                char c2 = c;
                return (c2 == 't' ? true : c2 == 'T') ? value * 0x10000000000L : ((c2 == 'g' ? true : c2 == 'G') ? value * 0x40000000L : ((c2 == 'm' ? true : c2 == 'M') ? value * 0x100000L : ((c2 == 'k' ? true : c2 == 'K') ? value * 1024L : -2L)));
            }
            return Long.parseLong(vmOptionSize);
        }
        catch (NumberFormatException e) {
            return -3L;
        }
    }

    @VisibleForTesting
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lcom/android/tools/analytics/CommonMetricsData$GarbageCollectionStatsDiffs;", "", "()V", "collections", "", "getCollections", "()J", "setCollections", "(J)V", "time", "getTime", "setTime", "shared"})
    public static final class GarbageCollectionStatsDiffs {
        private volatile long collections;
        private volatile long time;

        public final long getCollections() {
            return this.collections;
        }

        public final void setCollections(long l) {
            this.collections = l;
        }

        public final long getTime() {
            return this.time;
        }

        public final void setTime(long l) {
            this.time = l;
        }
    }
}

