/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.UsageTracker;
import com.google.wireless.android.play.playlog.proto.ClientAnalytics;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class JournalingUsageTracker
extends UsageTracker {
    private final Path mSpoolLocation;
    private final Object mGate = new Object();
    private FileLock mLock = null;
    private FileChannel mChannel = null;
    private OutputStream mOutputStream = null;
    private int mCurrentLogCount = 0;
    private ScheduledFuture<?> mJournalTimeout;
    private int mScheduleVersion = 0;
    private boolean mClosed;

    public JournalingUsageTracker(AnalyticsSettings analyticsSettings, ScheduledExecutorService scheduler, Path spoolLocation) {
        super(analyticsSettings, scheduler);
        this.mSpoolLocation = spoolLocation;
        try {
            this.newTrackFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize first usage tracking spool file", e);
        }
    }

    private void newTrackFile() throws IOException {
        Path spoolFile = Paths.get(this.mSpoolLocation.toString(), UUID.randomUUID().toString() + ".trk");
        Files.createDirectories(spoolFile.getParent(), new FileAttribute[0]);
        FileOutputStream fileOutputStream = new FileOutputStream(spoolFile.toFile());
        this.mOutputStream = fileOutputStream;
        this.mChannel = fileOutputStream.getChannel();
        try {
            this.mLock = this.mChannel.tryLock();
        }
        catch (OverlappingFileLockException e) {
            this.mChannel.close();
            this.mOutputStream.close();
            throw new IOException("Unable to lock usage tracking spool file", e);
        }
        if (this.mLock == null) {
            this.mChannel.close();
            this.mOutputStream.close();
            throw new IOException("Unable to lock usage tracking spool file, file already locked");
        }
        this.mCurrentLogCount = 0;
    }

    private void closeTrackFile() throws IOException {
        if (this.mLock != null) {
            this.mLock.release();
            this.mLock = null;
        }
        if (this.mChannel != null) {
            this.mChannel.close();
            this.mChannel = null;
        }
        if (this.mOutputStream != null) {
            this.mOutputStream.close();
            this.mOutputStream = null;
        }
    }

    @Override
    public void logDetails(final ClientAnalytics.LogEvent.Builder logEvent) {
        if (this.mClosed) {
            throw new RuntimeException("UsageTracker already closed.");
        }
        this.getScheduler().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = JournalingUsageTracker.this.mGate;
                synchronized (object) {
                    try {
                        logEvent.build().writeDelimitedTo(JournalingUsageTracker.this.mOutputStream);
                        JournalingUsageTracker.this.mOutputStream.flush();
                        JournalingUsageTracker.this.mChannel.force(false);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failure writing logDetails to usage tracking spool file", e);
                    }
                    JournalingUsageTracker.this.mCurrentLogCount++;
                    if (JournalingUsageTracker.this.getMaxJournalSize() > 0 && JournalingUsageTracker.this.mCurrentLogCount >= JournalingUsageTracker.this.getMaxJournalSize()) {
                        JournalingUsageTracker.this.switchTrackFile();
                        if (JournalingUsageTracker.this.mJournalTimeout != null) {
                            JournalingUsageTracker.this.scheduleJournalTimeout(JournalingUsageTracker.this.getMaxJournalTime());
                        }
                    }
                }
            }
        });
    }

    private void switchTrackFile() {
        try {
            this.closeTrackFile();
            this.newTrackFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Failure switching to new usage tracking spool file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.mGate;
        synchronized (object) {
            this.mClosed = true;
            this.closeTrackFile();
            if (this.mJournalTimeout != null) {
                this.mJournalTimeout.cancel(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxJournalTime(long duration, TimeUnit unit) {
        Object object = this.mGate;
        synchronized (object) {
            super.setMaxJournalTime(duration, unit);
            this.scheduleJournalTimeout(this.getMaxJournalTime());
        }
    }

    private void scheduleJournalTimeout(long maxJournalTime) {
        int currentScheduleVersion = ++this.mScheduleVersion;
        if (this.mJournalTimeout != null) {
            this.mJournalTimeout.cancel(false);
        }
        this.mJournalTimeout = this.getScheduler().schedule(() -> {
            Object object = this.mGate;
            synchronized (object) {
                if (this.mCurrentLogCount > 0) {
                    this.switchTrackFile();
                }
                if (this.mScheduleVersion == currentScheduleVersion) {
                    this.scheduleJournalTimeout(maxJournalTime);
                }
            }
        }, maxJournalTime, TimeUnit.NANOSECONDS);
    }
}

