/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.stamp;

import com.android.apksig.SigningCertificateLineage;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.util.Pair;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class V2SourceStampSigner {
    public static final int V2_SOURCE_STAMP_BLOCK_ID = 1845461005;
    private final ApkSigningBlockUtils.SignerConfig mSourceStampSignerConfig;
    private final Map<Integer, Map<ContentDigestAlgorithm, byte[]>> mSignatureSchemeDigestInfos;
    private final boolean mSourceStampTimestampEnabled;

    private V2SourceStampSigner(Builder builder) {
        this.mSourceStampSignerConfig = builder.mSourceStampSignerConfig;
        this.mSignatureSchemeDigestInfos = builder.mSignatureSchemeDigestInfos;
        this.mSourceStampTimestampEnabled = builder.mSourceStampTimestampEnabled;
    }

    public static Pair<byte[], Integer> generateSourceStampBlock(ApkSigningBlockUtils.SignerConfig sourceStampSignerConfig, Map<Integer, Map<ContentDigestAlgorithm, byte[]>> signatureSchemeDigestInfos) throws SignatureException, NoSuchAlgorithmException, InvalidKeyException {
        return new Builder(sourceStampSignerConfig, signatureSchemeDigestInfos).build().generateSourceStampBlock();
    }

    public Pair<byte[], Integer> generateSourceStampBlock() throws SignatureException, NoSuchAlgorithmException, InvalidKeyException {
        if (this.mSourceStampSignerConfig.certificates.isEmpty()) {
            throw new SignatureException("No certificates configured for signer");
        }
        ArrayList<Pair<Integer, byte[]>> signatureSchemeDigests = new ArrayList<Pair<Integer, byte[]>>();
        V2SourceStampSigner.getSignedDigestsFor(3, this.mSignatureSchemeDigestInfos, this.mSourceStampSignerConfig, signatureSchemeDigests);
        V2SourceStampSigner.getSignedDigestsFor(2, this.mSignatureSchemeDigestInfos, this.mSourceStampSignerConfig, signatureSchemeDigests);
        V2SourceStampSigner.getSignedDigestsFor(1, this.mSignatureSchemeDigestInfos, this.mSourceStampSignerConfig, signatureSchemeDigests);
        Collections.sort(signatureSchemeDigests, Comparator.comparing(Pair::getFirst));
        SourceStampBlock sourceStampBlock = new SourceStampBlock();
        try {
            sourceStampBlock.stampCertificate = this.mSourceStampSignerConfig.certificates.get(0).getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new SignatureException("Retrieving the encoded form of the stamp certificate failed", e);
        }
        sourceStampBlock.signedDigests = signatureSchemeDigests;
        sourceStampBlock.stampAttributes = V2SourceStampSigner.encodeStampAttributes(this.generateStampAttributes(this.mSourceStampSignerConfig.signingCertificateLineage));
        sourceStampBlock.signedStampAttributes = ApkSigningBlockUtils.generateSignaturesOverData(this.mSourceStampSignerConfig, sourceStampBlock.stampAttributes);
        byte[] sourceStampSignerBlock = ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedElements(new byte[][]{sourceStampBlock.stampCertificate, ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(sourceStampBlock.signedDigests), sourceStampBlock.stampAttributes, ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(sourceStampBlock.signedStampAttributes)});
        return Pair.of(ApkSigningBlockUtils.encodeAsLengthPrefixedElement(sourceStampSignerBlock), 1845461005);
    }

    private static void getSignedDigestsFor(int signatureSchemeVersion, Map<Integer, Map<ContentDigestAlgorithm, byte[]>> mSignatureSchemeDigestInfos, ApkSigningBlockUtils.SignerConfig mSourceStampSignerConfig, List<Pair<Integer, byte[]>> signatureSchemeDigests) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (!mSignatureSchemeDigestInfos.containsKey(signatureSchemeVersion)) {
            return;
        }
        Map<ContentDigestAlgorithm, byte[]> digestInfo = mSignatureSchemeDigestInfos.get(signatureSchemeVersion);
        ArrayList<Pair<Integer, byte[]>> digests = new ArrayList<Pair<Integer, byte[]>>();
        for (Map.Entry<ContentDigestAlgorithm, byte[]> digest : digestInfo.entrySet()) {
            digests.add(Pair.of(digest.getKey().getId(), digest.getValue()));
        }
        Collections.sort(digests, Comparator.comparing(Pair::getFirst));
        byte[] digestBytes = ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(digests);
        List<Pair<Integer, byte[]>> signedDigest = ApkSigningBlockUtils.generateSignaturesOverData(mSourceStampSignerConfig, digestBytes);
        signatureSchemeDigests.add(Pair.of(signatureSchemeVersion, ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(signedDigest)));
    }

    private static byte[] encodeStampAttributes(Map<Integer, byte[]> stampAttributes) {
        int payloadSize = 0;
        for (byte[] attributeValue : stampAttributes.values()) {
            payloadSize += 8 + attributeValue.length;
        }
        ByteBuffer result = ByteBuffer.allocate(4 + payloadSize);
        result.order(ByteOrder.LITTLE_ENDIAN);
        result.putInt(payloadSize);
        for (Map.Entry<Integer, byte[]> stampAttribute : stampAttributes.entrySet()) {
            result.putInt(4 + stampAttribute.getValue().length);
            result.putInt(stampAttribute.getKey());
            result.put(stampAttribute.getValue());
        }
        return result.array();
    }

    private Map<Integer, byte[]> generateStampAttributes(SigningCertificateLineage lineage) {
        HashMap<Integer, byte[]> stampAttributes = new HashMap<Integer, byte[]>();
        if (this.mSourceStampTimestampEnabled) {
            long timestamp = Instant.now().getEpochSecond();
            if (timestamp > 0L) {
                ByteBuffer attributeBuffer = ByteBuffer.allocate(8);
                attributeBuffer.order(ByteOrder.LITTLE_ENDIAN);
                attributeBuffer.putLong(timestamp);
                stampAttributes.put(-465807034, attributeBuffer.array());
            } else {
                throw new IllegalStateException("Received an invalid value from Instant#getTimestamp: " + timestamp);
            }
        }
        if (lineage != null) {
            stampAttributes.put(-1654455305, lineage.encodeSigningCertificateLineage());
        }
        return stampAttributes;
    }

    public static class Builder {
        private final ApkSigningBlockUtils.SignerConfig mSourceStampSignerConfig;
        private final Map<Integer, Map<ContentDigestAlgorithm, byte[]>> mSignatureSchemeDigestInfos;
        private boolean mSourceStampTimestampEnabled = true;

        public Builder(ApkSigningBlockUtils.SignerConfig sourceStampSignerConfig, Map<Integer, Map<ContentDigestAlgorithm, byte[]>> signatureSchemeDigestInfos) {
            this.mSourceStampSignerConfig = sourceStampSignerConfig;
            this.mSignatureSchemeDigestInfos = signatureSchemeDigestInfos;
        }

        public Builder setSourceStampTimestampEnabled(boolean value) {
            this.mSourceStampTimestampEnabled = value;
            return this;
        }

        public V2SourceStampSigner build() {
            return new V2SourceStampSigner(this);
        }
    }

    private static final class SourceStampBlock {
        public byte[] stampCertificate;
        public List<Pair<Integer, byte[]>> signedDigests;
        public byte[] stampAttributes;
        public List<Pair<Integer, byte[]>> signedStampAttributes;

        private SourceStampBlock() {
        }
    }
}

