/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v2;

import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.v2.Aapt2;
import com.android.builder.internal.aapt.v2.Aapt2Daemon;
import com.android.builder.internal.aapt.v2.Aapt2Exception;
import com.android.ide.common.res2.CompileResourceRequest;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0005$%&'(BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0018\u001a\u00020\u0019H\u0007J\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u0017H\u0003J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0017H\u0003J\b\u0010\u001f\u001a\u00020\u001bH\u0007J\b\u0010 \u001a\u00020!H\u0007J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00170#H\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager;", "", "logger", "Lcom/android/utils/ILogger;", "daemonFactory", "Lkotlin/Function1;", "", "Lcom/android/builder/internal/aapt/v2/Aapt2Daemon;", "expiryTime", "", "expiryTimeUnit", "Ljava/util/concurrent/TimeUnit;", "listener", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$Listener;", "timeSource", "Lcom/google/common/base/Ticker;", "(Lcom/android/utils/ILogger;Lkotlin/jvm/functions/Function1;JLjava/util/concurrent/TimeUnit;Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$Listener;Lcom/google/common/base/Ticker;)V", "expiryTimeNanoSeconds", "latestDisplayId", "getLogger", "()Lcom/android/utils/ILogger;", "pool", "", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$LeasableAaptDaemon;", "leaseDaemon", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$LeasedAaptDaemon;", "maintain", "", "newAaptDaemon", "returnProcess", "key", "shutdown", "stats", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$Stats;", "takeExpiredDaemonsFromPool", "", "LeasableAaptDaemon", "LeasedAaptDaemon", "Listener", "NoOpListener", "Stats", "builder"})
@ThreadSafe
public final class Aapt2DaemonManager {
    private final long expiryTimeNanoSeconds;
    @GuardedBy(value="this")
    private int latestDisplayId;
    @GuardedBy(value="this")
    private final List<LeasableAaptDaemon> pool;
    @NotNull
    private final ILogger logger;
    private final Function1<Integer, Aapt2Daemon> daemonFactory;
    private final Listener listener;
    private final Ticker timeSource;

    @NotNull
    public final synchronized LeasedAaptDaemon leaseDaemon() {
        LeasableAaptDaemon leasableAaptDaemon;
        Object v0;
        block2: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)this.pool;
            for (Object t : iterable2) {
                LeasableAaptDaemon it = (LeasableAaptDaemon)t;
                if (!(!it.getBusy())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((leasableAaptDaemon = (LeasableAaptDaemon)v0) == null) {
            leasableAaptDaemon = this.newAaptDaemon();
        }
        LeasableAaptDaemon daemon = leasableAaptDaemon;
        daemon.setBusy(true);
        return new LeasedAaptDaemon(daemon, (Function1<? super LeasableAaptDaemon, Unit>)((Function1)new Function1<LeasableAaptDaemon, Unit>(this){

            public final void invoke(@NotNull LeasableAaptDaemon p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Aapt2DaemonManager.access$returnProcess((Aapt2DaemonManager)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Aapt2DaemonManager.class);
            }

            public final String getName() {
                return "returnProcess";
            }

            public final String getSignature() {
                return "returnProcess(Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$LeasableAaptDaemon;)V";
            }
        }));
    }

    public final void maintain() {
        List<LeasableAaptDaemon> expiredDaemons = this.takeExpiredDaemonsFromPool();
        Iterable $receiver$iv = expiredDaemons;
        for (Object element$iv : $receiver$iv) {
            LeasableAaptDaemon it = (LeasableAaptDaemon)element$iv;
            it.shutdown();
        }
    }

    public final synchronized void shutdown() {
        LeasableAaptDaemon it;
        boolean bl;
        Iterable $receiver$iv;
        block6: {
            $receiver$iv = this.pool;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    it = (LeasableAaptDaemon)element$iv;
                    if (!it.getBusy()) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            throw (Throwable)new IllegalStateException("AAPT Process manager cannot be shut down while daemons are in use");
        }
        if (!this.pool.isEmpty()) {
            this.listener.lastDaemonStopped();
        }
        $receiver$iv = this.pool;
        for (Object element$iv : $receiver$iv) {
            it = (LeasableAaptDaemon)element$iv;
            it.shutdown();
        }
        this.pool.clear();
    }

    @GuardedBy(value="this")
    private final LeasableAaptDaemon newAaptDaemon() {
        int n = this.latestDisplayId;
        this.latestDisplayId = n + 1;
        int displayId = n;
        Aapt2Daemon process = (Aapt2Daemon)this.daemonFactory.invoke((Object)displayId);
        LeasableAaptDaemon daemon = new LeasableAaptDaemon(process, this.timeSource.read(), false, 4, null);
        if (this.pool.isEmpty()) {
            this.listener.firstDaemonStarted(this);
        }
        this.pool.add(daemon);
        return daemon;
    }

    private final synchronized void returnProcess(LeasableAaptDaemon key) {
        if (Intrinsics.areEqual((Object)((Object)key.getDaemon().getState()), (Object)((Object)Aapt2Daemon.State.RUNNING)) ^ true) {
            this.pool.remove(key);
            if (this.pool.isEmpty()) {
                this.listener.lastDaemonStopped();
            }
            return;
        }
        key.setLastUsedNanoSeconds(this.timeSource.read());
        key.setBusy(false);
    }

    private final synchronized List<LeasableAaptDaemon> takeExpiredDaemonsFromPool() {
        List expired = new ArrayList();
        long expireHorizon = this.timeSource.read() - this.expiryTimeNanoSeconds;
        ArrayList oldPool = new ArrayList(this.pool);
        this.pool.clear();
        for (LeasableAaptDaemon daemon : oldPool) {
            if (daemon.getBusy() || daemon.getLastUsedNanoSeconds() >= expireHorizon) {
                LeasableAaptDaemon leasableAaptDaemon = daemon;
                Intrinsics.checkExpressionValueIsNotNull((Object)leasableAaptDaemon, (String)"daemon");
                this.pool.add(leasableAaptDaemon);
                continue;
            }
            LeasableAaptDaemon leasableAaptDaemon = daemon;
            Intrinsics.checkExpressionValueIsNotNull((Object)leasableAaptDaemon, (String)"daemon");
            expired.add(leasableAaptDaemon);
        }
        if (this.pool.isEmpty()) {
            this.listener.lastDaemonStopped();
        }
        return expired;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized Stats stats() {
        int n;
        void $receiver$iv;
        Stats stats;
        Iterable iterable = this.pool;
        int n2 = this.pool.size();
        Stats stats2 = stats;
        Stats stats3 = stats;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            n = 0;
        } else {
            void var2_5;
            int count$iv = 0;
            for (Object element$iv : $receiver$iv) {
                LeasableAaptDaemon it = (LeasableAaptDaemon)element$iv;
                if (!it.getBusy()) continue;
                ++count$iv;
            }
            n = var2_5;
        }
        int n3 = n;
        stats2(n2, n3);
        return stats3;
    }

    @NotNull
    public final ILogger getLogger() {
        return this.logger;
    }

    public Aapt2DaemonManager(@NotNull ILogger logger, @NotNull Function1<? super Integer, ? extends Aapt2Daemon> daemonFactory, long expiryTime, @NotNull TimeUnit expiryTimeUnit, @NotNull Listener listener, @NotNull Ticker timeSource) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull(daemonFactory, (String)"daemonFactory");
        Intrinsics.checkParameterIsNotNull((Object)((Object)expiryTimeUnit), (String)"expiryTimeUnit");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)timeSource, (String)"timeSource");
        this.logger = logger;
        this.daemonFactory = daemonFactory;
        this.listener = listener;
        this.timeSource = timeSource;
        this.expiryTimeNanoSeconds = expiryTimeUnit.toNanos(expiryTime);
        Aapt2DaemonManager aapt2DaemonManager = this;
        aapt2DaemonManager.pool = list = (List)new ArrayList();
    }

    public /* synthetic */ Aapt2DaemonManager(ILogger iLogger, Function1 function1, long l, TimeUnit timeUnit, Listener listener, Ticker ticker, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            listener = new NoOpListener();
        }
        if ((n & 0x20) != 0) {
            Ticker ticker2 = Ticker.systemTicker();
            Intrinsics.checkExpressionValueIsNotNull((Object)ticker2, (String)"Ticker.systemTicker()");
            ticker = ticker2;
        }
        this(iLogger, (Function1<? super Integer, ? extends Aapt2Daemon>)function1, l, timeUnit, listener, ticker);
    }

    public static final /* synthetic */ void access$returnProcess(Aapt2DaemonManager $this, @NotNull LeasableAaptDaemon key) {
        $this.returnProcess(key);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$LeasableAaptDaemon;", "", "daemon", "Lcom/android/builder/internal/aapt/v2/Aapt2Daemon;", "lastUsedNanoSeconds", "", "busy", "", "(Lcom/android/builder/internal/aapt/v2/Aapt2Daemon;JZ)V", "getBusy", "()Z", "setBusy", "(Z)V", "getDaemon", "()Lcom/android/builder/internal/aapt/v2/Aapt2Daemon;", "getLastUsedNanoSeconds", "()J", "setLastUsedNanoSeconds", "(J)V", "shutdown", "", "builder"})
    public static final class LeasableAaptDaemon {
        @NotNull
        private final Aapt2Daemon daemon;
        private long lastUsedNanoSeconds;
        private boolean busy;

        public final void shutdown() {
            this.daemon.shutDown();
        }

        @NotNull
        public final Aapt2Daemon getDaemon() {
            return this.daemon;
        }

        public final long getLastUsedNanoSeconds() {
            return this.lastUsedNanoSeconds;
        }

        public final void setLastUsedNanoSeconds(long l) {
            this.lastUsedNanoSeconds = l;
        }

        public final boolean getBusy() {
            return this.busy;
        }

        public final void setBusy(boolean bl) {
            this.busy = bl;
        }

        public LeasableAaptDaemon(@NotNull Aapt2Daemon daemon, long lastUsedNanoSeconds, boolean busy) {
            Intrinsics.checkParameterIsNotNull((Object)daemon, (String)"daemon");
            this.daemon = daemon;
            this.lastUsedNanoSeconds = lastUsedNanoSeconds;
            this.busy = busy;
        }

        public /* synthetic */ LeasableAaptDaemon(Aapt2Daemon aapt2Daemon, long l, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(aapt2Daemon, l, bl);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B#\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\u0007H\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0017R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$LeasedAaptDaemon;", "Ljava/io/Closeable;", "Lcom/android/builder/internal/aapt/v2/Aapt2;", "leasableDaemon", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$LeasableAaptDaemon;", "closeAction", "Lkotlin/Function1;", "", "(Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$LeasableAaptDaemon;Lkotlin/jvm/functions/Function1;)V", "leaseValid", "", "close", "compile", "request", "Lcom/android/ide/common/res2/CompileResourceRequest;", "logger", "Lcom/android/utils/ILogger;", "link", "Lcom/android/builder/internal/aapt/AaptPackageConfig;", "builder"})
    @NotThreadSafe
    public static final class LeasedAaptDaemon
    implements Closeable,
    Aapt2 {
        private boolean leaseValid;
        private final LeasableAaptDaemon leasableDaemon;
        private final Function1<LeasableAaptDaemon, Unit> closeAction;

        @Override
        public void compile(@NotNull CompileResourceRequest request, @NotNull ILogger logger) throws Aapt2Exception {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
            Preconditions.checkState((boolean)this.leaseValid, (String)"Leased process is already closed", (Object[])new Object[0]);
            this.leasableDaemon.getDaemon().compile(request, logger);
        }

        @Override
        public void link(@NotNull AaptPackageConfig request, @NotNull ILogger logger) throws Aapt2Exception {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
            Preconditions.checkState((boolean)this.leaseValid, (String)"Leased process is already closed", (Object[])new Object[0]);
            this.leasableDaemon.getDaemon().link(request, logger);
        }

        @Override
        public void close() {
            Preconditions.checkState((boolean)this.leaseValid, (String)"Leased process is already closed", (Object[])new Object[0]);
            this.closeAction.invoke((Object)this.leasableDaemon);
            this.leaseValid = false;
        }

        public LeasedAaptDaemon(@NotNull LeasableAaptDaemon leasableDaemon, @NotNull Function1<? super LeasableAaptDaemon, Unit> closeAction) {
            Intrinsics.checkParameterIsNotNull((Object)leasableDaemon, (String)"leasableDaemon");
            Intrinsics.checkParameterIsNotNull(closeAction, (String)"closeAction");
            this.leasableDaemon = leasableDaemon;
            this.closeAction = closeAction;
            this.leaseValid = true;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&\u00a8\u0006\u0007"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$Listener;", "", "firstDaemonStarted", "", "manager", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager;", "lastDaemonStopped", "builder"})
    public static interface Listener {
        public void firstDaemonStarted(@NotNull Aapt2DaemonManager var1);

        public void lastDaemonStopped();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$NoOpListener;", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$Listener;", "()V", "firstDaemonStarted", "", "manager", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager;", "lastDaemonStopped", "builder"})
    public static final class NoOpListener
    implements Listener {
        @Override
        public void firstDaemonStarted(@NotNull Aapt2DaemonManager manager) {
            Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        }

        @Override
        public void lastDaemonStopped() {
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$Stats;", "", "poolSize", "", "busyCount", "(II)V", "getBusyCount", "()I", "getPoolSize", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "builder"})
    public static final class Stats {
        private final int poolSize;
        private final int busyCount;

        public final int getPoolSize() {
            return this.poolSize;
        }

        public final int getBusyCount() {
            return this.busyCount;
        }

        public Stats(int poolSize, int busyCount) {
            this.poolSize = poolSize;
            this.busyCount = busyCount;
        }

        public final int component1() {
            return this.poolSize;
        }

        public final int component2() {
            return this.busyCount;
        }

        @NotNull
        public final Stats copy(int poolSize, int busyCount) {
            return new Stats(poolSize, busyCount);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Stats copy$default(Stats stats, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = stats.poolSize;
            }
            if ((n3 & 2) != 0) {
                n2 = stats.busyCount;
            }
            return stats.copy(n, n2);
        }

        public String toString() {
            return "Stats(poolSize=" + this.poolSize + ", busyCount=" + this.busyCount + ")";
        }

        public int hashCode() {
            return this.poolSize * 31 + this.busyCount;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Stats)) break block3;
                    Stats stats = (Stats)object;
                    if (!(this.poolSize == stats.poolSize) || !(this.busyCount == stats.busyCount)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

