/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.Resource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;

public interface ProgramResource
extends Resource {
    public static ProgramResource fromFile(Kind kind, Path file) {
        return new FileResource(kind, file, null);
    }

    public static ProgramResource fromBytes(Origin origin, Kind kind, byte[] bytes, Set<String> typeDescriptors) {
        return new ByteResource(origin, kind, bytes, typeDescriptors);
    }

    public Kind getKind();

    public InputStream getByteStream() throws ResourceException;

    public Set<String> getClassDescriptors();

    public static class ByteResource
    implements ProgramResource {
        private final Origin origin;
        private final Kind kind;
        private final byte[] bytes;
        private final Set<String> classDescriptors;

        private ByteResource(Origin origin, Kind kind, byte[] bytes, Set<String> classDescriptors) {
            assert (bytes != null);
            this.origin = origin;
            this.kind = kind;
            this.bytes = bytes;
            this.classDescriptors = classDescriptors;
        }

        @Override
        public Origin getOrigin() {
            return this.origin;
        }

        @Override
        public Kind getKind() {
            return this.kind;
        }

        @Override
        public InputStream getByteStream() throws ResourceException {
            return new ByteArrayInputStream(this.bytes);
        }

        @Override
        public Set<String> getClassDescriptors() {
            return this.classDescriptors;
        }
    }

    public static class FileResource
    implements ProgramResource {
        private final Origin origin;
        private final Kind kind;
        private final Path file;
        private final Set<String> classDescriptors;

        private FileResource(Kind kind, Path file, Set<String> classDescriptors) {
            this.origin = new PathOrigin(file);
            this.kind = kind;
            this.file = file;
            this.classDescriptors = classDescriptors;
        }

        @Override
        public Origin getOrigin() {
            return this.origin;
        }

        @Override
        public Kind getKind() {
            return this.kind;
        }

        @Override
        public InputStream getByteStream() throws ResourceException {
            try {
                return Files.newInputStream(this.file, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new ResourceException(this.getOrigin(), (Throwable)e);
            }
        }

        @Override
        public Set<String> getClassDescriptors() {
            return this.classDescriptors;
        }
    }

    public static enum Kind {
        CF,
        DEX;

    }
}

