/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf;

import com.android.tools.r8.cf.CfRegisterAllocator;
import com.android.tools.r8.cf.FixedLocalValue;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstClass;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Load;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Pop;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.StackValue;
import com.android.tools.r8.ir.code.Store;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LoadStoreHelper {
    private final IRCode code;
    private final Map<Value, DexType> types;

    public LoadStoreHelper(IRCode code, Map<Value, DexType> types) {
        this.code = code;
        this.types = types;
    }

    public void insertLoadsAndStores() {
        for (BasicBlock block : this.code.blocks) {
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                Instruction current = (Instruction)it.next();
                current.insertLoadAndStores(it, this);
            }
        }
    }

    public void insertPhiMoves(CfRegisterAllocator allocator) {
        for (BasicBlock block : this.code.blocks) {
            if (block.getPhis().isEmpty()) continue;
            assert (!block.entry().isMoveException());
            for (int predIndex = 0; predIndex < block.getPredecessors().size(); ++predIndex) {
                BasicBlock pred = block.getPredecessors().get(predIndex);
                List<Phi> phis = block.getPhis();
                ArrayList<PhiMove> moves = new ArrayList<PhiMove>(phis.size());
                for (Phi phi : phis) {
                    Value value = phi.getOperand(predIndex);
                    if (allocator.getRegisterForValue(phi) == allocator.getRegisterForValue(value)) continue;
                    moves.add(new PhiMove(phi, value));
                }
                InstructionListIterator it = pred.listIterator(pred.getInstructions().size());
                it.previous();
                this.movePhis(moves, it);
            }
            allocator.addToLiveAtEntrySet(block, block.getPhis());
        }
        this.code.blocks.forEach(BasicBlock::clearUserInfo);
    }

    private StackValue createStackValue(Value value, int height) {
        if (value.outType().isObject()) {
            return StackValue.forObjectType(this.types.get(value), height);
        }
        return StackValue.forNonObjectType(value.outType(), height);
    }

    private StackValue createStackValue(DexType type, int height) {
        if (type.isPrimitiveType()) {
            return StackValue.forNonObjectType(ValueType.fromDexType(type), height);
        }
        return StackValue.forObjectType(type, height);
    }

    public void loadInValues(Instruction instruction, InstructionListIterator it) {
        int topOfStack = 0;
        it.previous();
        for (int i = 0; i < instruction.inValues().size(); ++i) {
            Value value = instruction.inValues().get(i);
            StackValue stackValue = this.createStackValue(value, topOfStack++);
            LoadStoreHelper.add(this.load(stackValue, value), instruction, it);
            value.removeUser(instruction);
            instruction.replaceValue(i, (Value)stackValue);
        }
        it.next();
    }

    public void storeOutValue(Instruction instruction, InstructionListIterator it) {
        if (instruction.outValue() instanceof StackValue) {
            assert (instruction.isConstInstruction());
            return;
        }
        if (!instruction.outValue().isUsed()) {
            this.popOutValue(instruction.outValue(), instruction, it);
            return;
        }
        StackValue newOutValue = this.createStackValue(instruction.outValue(), 0);
        Value oldOutValue = instruction.swapOutValue(newOutValue);
        Store store = new Store(oldOutValue, newOutValue);
        instruction.moveDebugValues(store);
        LoadStoreHelper.add(store, instruction, it);
    }

    public void popOutValue(Value value, Instruction instruction, InstructionListIterator it) {
        StackValue newOutValue = this.createStackValue(value, 0);
        instruction.swapOutValue(newOutValue);
        LoadStoreHelper.add(new Pop(newOutValue), instruction, it);
    }

    public void popOutType(DexType type, Instruction instruction, InstructionListIterator it) {
        StackValue newOutValue = this.createStackValue(type, 0);
        instruction.swapOutValue(newOutValue);
        LoadStoreHelper.add(new Pop(newOutValue), instruction, it);
    }

    private void movePhis(List<PhiMove> moves, InstructionListIterator it) {
        StackValue tmp;
        int topOfStack = 0;
        ArrayList<StackValue> temps = new ArrayList<StackValue>(moves.size());
        for (PhiMove move : moves) {
            tmp = this.createStackValue(move.phi, topOfStack++);
            LoadStoreHelper.add(this.load(tmp, move.operand), move.phi.getBlock(), Position.none(), it);
            temps.add(tmp);
            move.operand.removePhiUser(move.phi);
        }
        for (int i = moves.size() - 1; i >= 0; --i) {
            PhiMove move;
            move = moves.get(i);
            tmp = (StackValue)temps.get(i);
            FixedLocalValue out = new FixedLocalValue(move.phi);
            LoadStoreHelper.add(new Store((Value)out, tmp), move.phi.getBlock(), Position.none(), it);
            move.phi.replaceUsers(out);
        }
    }

    private Instruction load(StackValue stackValue, Value value) {
        if (value.isConstant()) {
            ConstInstruction constant = value.getConstInstruction();
            if (constant.isConstNumber()) {
                return new ConstNumber((Value)stackValue, constant.asConstNumber().getRawValue());
            }
            if (constant.isConstString()) {
                return new ConstString((Value)stackValue, constant.asConstString().getValue());
            }
            if (constant.isConstClass()) {
                return new ConstClass((Value)stackValue, constant.asConstClass().getValue());
            }
            throw new Unreachable("Unexpected constant value: " + value);
        }
        return new Load(stackValue, value);
    }

    private static void add(Instruction newInstruction, Instruction existingInstruction, InstructionListIterator it) {
        LoadStoreHelper.add(newInstruction, existingInstruction.getBlock(), existingInstruction.getPosition(), it);
    }

    private static void add(Instruction newInstruction, BasicBlock block, Position position, InstructionListIterator it) {
        newInstruction.setBlock(block);
        newInstruction.setPosition(position);
        it.add(newInstruction);
    }

    private static class PhiMove {
        final Phi phi;
        final Value operand;

        public PhiMove(Phi phi, Value operand) {
            this.phi = phi;
            this.operand = operand;
        }
    }
}

