/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.naming.NamingLens;

public class DexField
extends Descriptor<DexEncodedField, DexField>
implements PresortedComparable<DexField> {
    public final DexType clazz;
    public final DexType type;
    public final DexString name;

    DexField(DexType clazz, DexType type, DexString name) {
        this.clazz = clazz;
        this.type = type;
        this.name = name;
        if (!name.isValidFieldName()) {
            throw new CompilationError("Field name '" + name.toString() + "' cannot be represented in dex format.");
        }
    }

    @Override
    public int computeHashCode() {
        return this.clazz.hashCode() + this.type.hashCode() * 7 + this.name.hashCode() * 31;
    }

    @Override
    public boolean computeEquals(Object other) {
        if (other instanceof DexField) {
            DexField o = (DexField)other;
            return this.clazz.equals(o.clazz) && this.type.equals(o.type) && this.name.equals(o.name);
        }
        return false;
    }

    public String toString() {
        return "Field " + this.type + " " + this.clazz + "." + this.name;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        if (indexedItems.addField(this)) {
            this.clazz.collectIndexedItems(indexedItems);
            this.type.collectIndexedItems(indexedItems);
            indexedItems.getRenamedName(this).collectIndexedItems(indexedItems);
        }
    }

    @Override
    public int getOffset(ObjectToOffsetMapping mapping) {
        return mapping.getOffsetFor(this);
    }

    @Override
    public int compareTo(DexField other) {
        return this.sortedCompareTo(other.getSortedIndex());
    }

    @Override
    public int slowCompareTo(DexField other) {
        int result = this.clazz.slowCompareTo(other.clazz);
        if (result != 0) {
            return result;
        }
        result = this.name.slowCompareTo(other.name);
        if (result != 0) {
            return result;
        }
        return this.type.slowCompareTo(other.type);
    }

    @Override
    public int slowCompareTo(DexField other, NamingLens namingLens) {
        int result = this.clazz.slowCompareTo(other.clazz, namingLens);
        if (result != 0) {
            return result;
        }
        result = namingLens.lookupName(this).slowCompareTo(namingLens.lookupName(other));
        if (result != 0) {
            return result;
        }
        return this.type.slowCompareTo(other.type, namingLens);
    }

    @Override
    public int layeredCompareTo(DexField other, NamingLens namingLens) {
        int result = this.clazz.compareTo(other.clazz);
        if (result != 0) {
            return result;
        }
        result = namingLens.lookupName(this).compareTo(namingLens.lookupName(other));
        if (result != 0) {
            return result;
        }
        return this.type.compareTo(other.type);
    }

    @Override
    public boolean match(DexEncodedField entry) {
        return entry.field.name == this.name && entry.field.type == this.type;
    }

    @Override
    public DexType getHolder() {
        return this.clazz;
    }

    @Override
    public String toSmaliString() {
        return this.clazz.toSmaliString() + "->" + this.name + ":" + this.type.toSmaliString();
    }

    @Override
    public String toSourceString() {
        return this.type.toSourceString() + " " + this.clazz.toSourceString() + "." + this.name.toSourceString();
    }
}

