/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.naming.ClassNaming;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.naming.Range;
import com.android.tools.r8.utils.ThrowingConsumer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ClassNamingForNameMapper
implements ClassNaming {
    public final String originalName;
    private final String renamedName;
    private final ImmutableMap<MemberNaming.MethodSignature, MemberNaming> methodMembers;
    private final ImmutableMap<MemberNaming.FieldSignature, MemberNaming> fieldMembers;
    public final Map<String, MappedRangesOfName> mappedRangesByName;

    static Builder builder(String renamedName, String originalName) {
        return new Builder(renamedName, originalName);
    }

    private ClassNamingForNameMapper(String renamedName, String originalName, Map<MemberNaming.MethodSignature, MemberNaming> methodMembers, Map<MemberNaming.FieldSignature, MemberNaming> fieldMembers, Map<String, MappedRangesOfName> mappedRangesByName) {
        this.renamedName = renamedName;
        this.originalName = originalName;
        this.methodMembers = ImmutableMap.copyOf(methodMembers);
        this.fieldMembers = ImmutableMap.copyOf(fieldMembers);
        this.mappedRangesByName = mappedRangesByName;
    }

    @Override
    public MemberNaming lookup(MemberNaming.Signature renamedSignature) {
        if (renamedSignature.kind() == MemberNaming.Signature.SignatureKind.METHOD) {
            assert (renamedSignature instanceof MemberNaming.MethodSignature);
            return this.methodMembers.get(renamedSignature);
        }
        assert (renamedSignature.kind() == MemberNaming.Signature.SignatureKind.FIELD);
        assert (renamedSignature instanceof MemberNaming.FieldSignature);
        return this.fieldMembers.get(renamedSignature);
    }

    @Override
    public MemberNaming lookupByOriginalSignature(MemberNaming.Signature original) {
        if (original.kind() == MemberNaming.Signature.SignatureKind.METHOD) {
            for (MemberNaming memberNaming : this.methodMembers.values()) {
                if (!memberNaming.signature.equals(original)) continue;
                return memberNaming;
            }
            return null;
        }
        assert (original.kind() == MemberNaming.Signature.SignatureKind.FIELD);
        for (MemberNaming memberNaming : this.fieldMembers.values()) {
            if (!memberNaming.signature.equals(original)) continue;
            return memberNaming;
        }
        return null;
    }

    public List<MemberNaming> lookupByOriginalName(String originalName) {
        ArrayList<MemberNaming> result = new ArrayList<MemberNaming>();
        for (MemberNaming naming : this.methodMembers.values()) {
            if (!naming.signature.name.equals(originalName)) continue;
            result.add(naming);
        }
        for (MemberNaming naming : this.fieldMembers.values()) {
            if (!naming.signature.name.equals(originalName)) continue;
            result.add(naming);
        }
        return result;
    }

    @Override
    public <T extends Throwable> void forAllMemberNaming(ThrowingConsumer<MemberNaming, T> consumer) throws T {
        this.forAllFieldNaming(consumer);
        this.forAllMethodNaming(consumer);
    }

    @Override
    public <T extends Throwable> void forAllFieldNaming(ThrowingConsumer<MemberNaming, T> consumer) throws T {
        for (MemberNaming naming : this.fieldMembers.values()) {
            consumer.accept(naming);
        }
    }

    @Override
    public <T extends Throwable> void forAllMethodNaming(ThrowingConsumer<MemberNaming, T> consumer) throws T {
        for (MemberNaming naming : this.methodMembers.values()) {
            consumer.accept(naming);
        }
    }

    void write(Writer writer) throws IOException {
        writer.append(this.originalName);
        writer.append(" -> ");
        writer.append(this.renamedName);
        writer.append(":\n");
        this.forAllMemberNaming(m -> {
            if (!m.isMethodNaming()) {
                writer.append("    ").append(m.toString()).append('\n');
            }
        });
        ArrayList rangeList = new ArrayList();
        for (MappedRangesOfName ranges : this.mappedRangesByName.values()) {
            rangeList.addAll(ranges.mappedRanges);
        }
        rangeList.sort((lhs, rhs) -> ((MappedRange)lhs).sequenceNumber - ((MappedRange)rhs).sequenceNumber);
        for (MappedRange range : rangeList) {
            writer.append("    ").append(range.toString()).append('\n');
        }
    }

    public String toString() {
        try {
            StringWriter writer = new StringWriter();
            this.write(writer);
            return writer.toString();
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassNamingForNameMapper)) {
            return false;
        }
        ClassNamingForNameMapper that = (ClassNamingForNameMapper)o;
        return this.originalName.equals(that.originalName) && this.renamedName.equals(that.renamedName) && this.methodMembers.equals(that.methodMembers) && this.fieldMembers.equals(that.fieldMembers) && this.mappedRangesByName.equals(that.mappedRangesByName);
    }

    public int hashCode() {
        int result = this.originalName.hashCode();
        result = 31 * result + this.renamedName.hashCode();
        result = 31 * result + this.methodMembers.hashCode();
        result = 31 * result + this.fieldMembers.hashCode();
        result = 31 * result + this.mappedRangesByName.hashCode();
        return result;
    }

    public static class MappedRange {
        private static int nextSequenceNumber = 0;
        public final Range obfuscatedRange;
        public final MemberNaming.MethodSignature signature;
        public final Object originalRange;
        public final String obfuscatedName;
        private final int sequenceNumber = this.getNextSequenceNumber();

        private synchronized int getNextSequenceNumber() {
            return nextSequenceNumber++;
        }

        private MappedRange(Range obfuscatedRange, MemberNaming.MethodSignature signature, Object originalRange, String obfuscatedName) {
            assert (obfuscatedRange != null || originalRange == null);
            assert (originalRange == null || originalRange instanceof Integer || originalRange instanceof Range);
            this.obfuscatedRange = obfuscatedRange;
            this.signature = signature;
            this.originalRange = originalRange;
            this.obfuscatedName = obfuscatedName;
        }

        public int originalLineFromObfuscated(int obfuscatedLineNumber) {
            if (this.obfuscatedRange == null) {
                return obfuscatedLineNumber;
            }
            assert (this.obfuscatedRange.contains(obfuscatedLineNumber));
            if (this.originalRange == null) {
                return obfuscatedLineNumber;
            }
            if (this.originalRange instanceof Integer) {
                return (Integer)this.originalRange;
            }
            assert (this.originalRange instanceof Range);
            return ((Range)this.originalRange).from + obfuscatedLineNumber - this.obfuscatedRange.from;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.obfuscatedRange != null) {
                builder.append(this.obfuscatedRange).append(':');
            }
            builder.append(this.signature);
            if (this.originalRange != null) {
                builder.append(":").append(this.originalRange);
            }
            builder.append(" -> ").append(this.obfuscatedName);
            return builder.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MappedRange)) {
                return false;
            }
            MappedRange that = (MappedRange)o;
            return Objects.equals(this.obfuscatedRange, that.obfuscatedRange) && Objects.equals(this.originalRange, that.originalRange) && this.signature.equals(that.signature) && this.obfuscatedName.equals(that.obfuscatedName);
        }

        public int hashCode() {
            int result = Objects.hashCode(this.obfuscatedRange);
            result = 31 * result + Objects.hashCode(this.originalRange);
            result = 31 * result + this.signature.hashCode();
            result = 31 * result + this.obfuscatedName.hashCode();
            return result;
        }
    }

    public static class MappedRangesOfName {
        private final List<MappedRange> mappedRanges;

        MappedRangesOfName(List<MappedRange> mappedRanges) {
            this.mappedRanges = mappedRanges;
        }

        public MappedRange firstRangeForLine(int line) {
            MappedRange bestRange = null;
            for (MappedRange range : this.mappedRanges) {
                if (range.obfuscatedRange == null) {
                    if (bestRange != null) continue;
                    bestRange = range;
                    continue;
                }
                if (!range.obfuscatedRange.contains(line)) continue;
                return range;
            }
            return bestRange;
        }

        public List<MappedRange> allRangesForLine(int line) {
            MappedRange noLineRange = null;
            for (int i = 0; i < this.mappedRanges.size(); ++i) {
                int j;
                MappedRange rangeI = this.mappedRanges.get(i);
                if (rangeI.obfuscatedRange == null) {
                    if (noLineRange != null) continue;
                    noLineRange = rangeI;
                    continue;
                }
                if (!rangeI.obfuscatedRange.contains(line)) continue;
                for (j = i + 1; j < this.mappedRanges.size() && Objects.equals(this.mappedRanges.get((int)j).obfuscatedRange, rangeI.obfuscatedRange); ++j) {
                }
                return this.mappedRanges.subList(i, j);
            }
            return noLineRange == null ? Collections.emptyList() : Collections.singletonList(noLineRange);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MappedRangesOfName that = (MappedRangesOfName)o;
            return this.mappedRanges.equals(that.mappedRanges);
        }

        public int hashCode() {
            return this.mappedRanges.hashCode();
        }
    }

    public static class Builder
    extends ClassNaming.Builder {
        private final String originalName;
        private final String renamedName;
        private final Map<MemberNaming.MethodSignature, MemberNaming> methodMembers = new HashMap<MemberNaming.MethodSignature, MemberNaming>();
        private final Map<MemberNaming.FieldSignature, MemberNaming> fieldMembers = new HashMap<MemberNaming.FieldSignature, MemberNaming>();
        private final Map<String, List<MappedRange>> mappedRangesByName = new HashMap<String, List<MappedRange>>();

        private Builder(String renamedName, String originalName) {
            this.originalName = originalName;
            this.renamedName = renamedName;
        }

        @Override
        public ClassNaming.Builder addMemberEntry(MemberNaming entry) {
            if (entry.isMethodNaming()) {
                this.methodMembers.put((MemberNaming.MethodSignature)entry.getRenamedSignature(), entry);
            } else {
                this.fieldMembers.put((MemberNaming.FieldSignature)entry.getRenamedSignature(), entry);
            }
            return this;
        }

        @Override
        public ClassNamingForNameMapper build() {
            Map<String, MappedRangesOfName> map;
            if (this.mappedRangesByName.isEmpty()) {
                map = Collections.emptyMap();
            } else {
                map = new HashMap(this.mappedRangesByName.size());
                for (Map.Entry<String, List<MappedRange>> entry : this.mappedRangesByName.entrySet()) {
                    map.put(entry.getKey(), new MappedRangesOfName(entry.getValue()));
                }
            }
            return new ClassNamingForNameMapper(this.renamedName, this.originalName, this.methodMembers, this.fieldMembers, map);
        }

        @Override
        public void addMappedRange(Range obfuscatedRange, MemberNaming.MethodSignature originalSignature, Object originalRange, String obfuscatedName) {
            this.mappedRangesByName.computeIfAbsent(obfuscatedName, k -> new ArrayList()).add(new MappedRange(obfuscatedRange, originalSignature, originalRange, obfuscatedName));
        }
    }
}

