/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.MethodAccessFlags;

public final class ClassAndMemberPublicizer {
    private final DexItemFactory factory;
    private final DexApplication application;

    private ClassAndMemberPublicizer(DexApplication application, DexItemFactory factory) {
        this.application = application;
        this.factory = factory;
    }

    public static DexApplication run(DexApplication application, DexItemFactory factory) {
        return new ClassAndMemberPublicizer(application, factory).run();
    }

    private DexApplication run() {
        for (DexClass dexClass : this.application.classes()) {
            dexClass.accessFlags.promoteToPublic();
            dexClass.forEachMethod(this::publicizeMethod);
            dexClass.forEachField(field -> field.accessFlags.promoteToPublic());
        }
        return this.application;
    }

    private void publicizeMethod(DexEncodedMethod method) {
        MethodAccessFlags accessFlags = method.accessFlags;
        if (accessFlags.isPublic()) {
            return;
        }
        if (this.factory.isClassConstructor(method.method)) {
            return;
        }
        if (!accessFlags.isPrivate()) {
            accessFlags.unsetProtected();
            accessFlags.setPublic();
            return;
        }
        assert (accessFlags.isPrivate());
        if (this.factory.isConstructor(method.method)) {
            return;
        }
        if (!accessFlags.isStatic()) {
            return;
        }
        accessFlags.unsetPrivate();
        accessFlags.setPublic();
    }
}

