/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.shaking.ProguardConfiguration;
import java.util.ArrayList;
import java.util.List;

public class ProguardKeepAttributes {
    public static final String SOURCE_FILE = "SourceFile";
    public static final String SOURCE_DIR = "SourceDir";
    public static final String INNER_CLASSES = "InnerClasses";
    public static final String ENCLOSING_METHOD = "EnclosingMethod";
    public static final String SIGNATURE = "Signature";
    public static final String EXCEPTIONS = "Exceptions";
    public static final String SOURCE_DEBUG_EXTENSION = "SourceDebugExtension";
    public static final String RUNTIME_VISIBLE_ANNOTATIONS = "RuntimeVisibleAnnotations";
    public static final String RUNTIME_INVISIBLE_ANNOTATIONS = "RuntimeInvisibleAnnotations";
    public static final String RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS = "RuntimeVisibleParameterAnnotations";
    public static final String RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS = "RuntimeInvisibleParameterAnnotations";
    public static final String RUNTIME_VISIBLE_TYPE_ANNOTATIONS = "RuntimeVisibleTypeAnnotations";
    public static final String RUNTIME_INVISIBLE_TYPE_ANNOTATIONS = "RuntimeInvisibleTypeAnnotations";
    public static final String ANNOTATION_DEFAULT = "AnnotationDefault";
    public static final List<String> KEEP_ALL = ImmutableList.of("*");
    public boolean sourceFile = false;
    public boolean sourceDir = false;
    public boolean innerClasses = false;
    public boolean enclosingMethod = false;
    public boolean signature = false;
    public boolean exceptions = false;
    public boolean sourceDebugExtension = false;
    public boolean runtimeVisibleAnnotations = false;
    public boolean runtimeInvisibleAnnotations = false;
    public boolean runtimeVisibleParameterAnnotations = false;
    public boolean runtimeInvisibleParameterAnnotations = false;
    public boolean runtimeVisibleTypeAnnotations = false;
    public boolean runtimeInvisibleTypeAnnotations = false;
    public boolean annotationDefault = false;

    private ProguardKeepAttributes() {
    }

    public static ProguardKeepAttributes filterOnlySignatures() {
        ProguardKeepAttributes result = new ProguardKeepAttributes();
        result.applyPatterns(KEEP_ALL);
        result.signature = false;
        return result;
    }

    private boolean update(boolean previous, String text, List<String> patterns) {
        for (String pattern : patterns) {
            if (previous) {
                return true;
            }
            if (pattern.charAt(0) == '!') {
                if (!this.matches(pattern, 1, text, 0)) continue;
                break;
            }
            previous = this.matches(pattern, 0, text, 0);
        }
        return previous;
    }

    private boolean matches(String pattern, int patternPos, String text, int textPos) {
        while (patternPos < pattern.length()) {
            char next;
            if ((next = pattern.charAt(patternPos++)) == '*') {
                while (textPos < text.length()) {
                    if (!this.matches(pattern, patternPos, text, textPos++)) continue;
                    return true;
                }
                return patternPos >= pattern.length();
            }
            if (textPos >= text.length() || text.charAt(textPos) != next) {
                return false;
            }
            ++textPos;
        }
        return textPos == text.length();
    }

    public static ProguardKeepAttributes fromPatterns(List<String> patterns) {
        ProguardKeepAttributes keepAttributes = new ProguardKeepAttributes();
        keepAttributes.applyPatterns(patterns);
        return keepAttributes;
    }

    public void applyPatterns(List<String> patterns) {
        this.sourceFile = this.update(this.sourceFile, SOURCE_FILE, patterns);
        this.sourceDir = this.update(this.sourceDir, SOURCE_DIR, patterns);
        this.innerClasses = this.update(this.innerClasses, INNER_CLASSES, patterns);
        this.enclosingMethod = this.update(this.enclosingMethod, ENCLOSING_METHOD, patterns);
        this.signature = this.update(this.signature, SIGNATURE, patterns);
        this.exceptions = this.update(this.exceptions, EXCEPTIONS, patterns);
        this.sourceDebugExtension = this.update(this.sourceDebugExtension, SOURCE_DEBUG_EXTENSION, patterns);
        this.runtimeVisibleAnnotations = this.update(this.runtimeVisibleAnnotations, RUNTIME_VISIBLE_ANNOTATIONS, patterns);
        this.runtimeInvisibleAnnotations = this.update(this.runtimeInvisibleAnnotations, RUNTIME_INVISIBLE_ANNOTATIONS, patterns);
        this.runtimeVisibleParameterAnnotations = this.update(this.runtimeVisibleParameterAnnotations, RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS, patterns);
        this.runtimeInvisibleParameterAnnotations = this.update(this.runtimeInvisibleParameterAnnotations, RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS, patterns);
        this.runtimeVisibleTypeAnnotations = this.update(this.runtimeVisibleTypeAnnotations, RUNTIME_VISIBLE_TYPE_ANNOTATIONS, patterns);
        this.runtimeInvisibleTypeAnnotations = this.update(this.runtimeInvisibleTypeAnnotations, RUNTIME_INVISIBLE_TYPE_ANNOTATIONS, patterns);
        this.annotationDefault = this.update(this.annotationDefault, ANNOTATION_DEFAULT, patterns);
    }

    public void ensureValid(boolean forceProguardCompatibility, ProguardConfiguration.Builder compatibility) {
        if (forceProguardCompatibility && this.innerClasses != this.enclosingMethod) {
            this.enclosingMethod = true;
            this.innerClasses = true;
            compatibility.addKeepAttributePatterns(ImmutableList.of(INNER_CLASSES, ENCLOSING_METHOD));
        }
        if (this.innerClasses && !this.enclosingMethod) {
            throw new CompilationError("Attribute InnerClasses requires EnclosingMethod attribute. Check -keepattributes directive.");
        }
        if (!this.innerClasses && this.enclosingMethod) {
            throw new CompilationError("Attribute EnclosingMethod requires InnerClasses attribute. Check -keepattributes directive.");
        }
        if (this.signature && !this.innerClasses) {
            throw new CompilationError("Attribute Signature requires InnerClasses attribute. Check -keepattributes directive.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProguardKeepAttributes)) {
            return false;
        }
        ProguardKeepAttributes other = (ProguardKeepAttributes)o;
        return this.sourceFile == other.sourceFile && this.sourceDir == other.sourceDir && this.innerClasses == other.innerClasses && this.enclosingMethod == other.enclosingMethod && this.signature == other.signature && this.exceptions == other.exceptions && this.sourceDebugExtension == other.sourceDebugExtension && this.runtimeVisibleAnnotations == other.runtimeVisibleAnnotations && this.runtimeInvisibleAnnotations == other.runtimeInvisibleAnnotations && this.runtimeVisibleParameterAnnotations == other.runtimeVisibleParameterAnnotations && this.runtimeInvisibleParameterAnnotations == other.runtimeInvisibleParameterAnnotations && this.runtimeVisibleTypeAnnotations == other.runtimeVisibleTypeAnnotations && this.runtimeInvisibleTypeAnnotations == other.runtimeInvisibleTypeAnnotations && this.annotationDefault == other.annotationDefault;
    }

    public int hashCode() {
        return (this.sourceFile ? 1 : 0) + (this.sourceDir ? 2 : 0) + (this.innerClasses ? 4 : 0) + (this.enclosingMethod ? 8 : 0) + (this.signature ? 16 : 0) + (this.exceptions ? 32 : 0) + (this.sourceDebugExtension ? 64 : 0) + (this.runtimeVisibleAnnotations ? 128 : 0) + (this.runtimeInvisibleAnnotations ? 256 : 0) + (this.runtimeVisibleParameterAnnotations ? 512 : 0) + (this.runtimeInvisibleParameterAnnotations ? 1024 : 0) + (this.runtimeVisibleTypeAnnotations ? 2048 : 0) + (this.runtimeInvisibleTypeAnnotations ? 4096 : 0) + (this.annotationDefault ? 8192 : 0);
    }

    public boolean isEmpty() {
        return !this.sourceFile && !this.sourceDir && !this.innerClasses && !this.enclosingMethod && !this.signature && !this.exceptions && !this.sourceDebugExtension && !this.runtimeVisibleAnnotations && !this.runtimeInvisibleAnnotations && !this.runtimeVisibleParameterAnnotations && !this.runtimeInvisibleParameterAnnotations && !this.runtimeVisibleTypeAnnotations && !this.runtimeInvisibleTypeAnnotations && !this.annotationDefault;
    }

    public StringBuilder append(StringBuilder builder) {
        ArrayList<String> attributes = new ArrayList<String>();
        if (this.sourceFile) {
            attributes.add(SOURCE_FILE);
        }
        if (this.sourceDir) {
            attributes.add(SOURCE_DIR);
        }
        if (this.innerClasses) {
            attributes.add(INNER_CLASSES);
        }
        if (this.enclosingMethod) {
            attributes.add(ENCLOSING_METHOD);
        }
        if (this.signature) {
            attributes.add(SIGNATURE);
        }
        if (this.exceptions) {
            attributes.add(EXCEPTIONS);
        }
        if (this.sourceDebugExtension) {
            attributes.add(SOURCE_DEBUG_EXTENSION);
        }
        if (this.runtimeVisibleAnnotations) {
            attributes.add(RUNTIME_INVISIBLE_ANNOTATIONS);
        }
        if (this.runtimeInvisibleAnnotations) {
            attributes.add(RUNTIME_INVISIBLE_ANNOTATIONS);
        }
        if (this.runtimeVisibleParameterAnnotations) {
            attributes.add(RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS);
        }
        if (this.runtimeInvisibleParameterAnnotations) {
            attributes.add(RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS);
        }
        if (this.runtimeVisibleTypeAnnotations) {
            attributes.add(RUNTIME_VISIBLE_TYPE_ANNOTATIONS);
        }
        if (this.runtimeInvisibleTypeAnnotations) {
            attributes.add(RUNTIME_INVISIBLE_TYPE_ANNOTATIONS);
        }
        if (this.annotationDefault) {
            attributes.add(ANNOTATION_DEFAULT);
        }
        if (attributes.size() > 0) {
            builder.append("-keepattributes ");
            builder.append(String.join((CharSequence)",", attributes));
        }
        return builder;
    }

    public String toString() {
        return this.append(new StringBuilder()).toString();
    }
}

