/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.BaseInstructionFactory;
import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.graph.OffsetToObjectMapping;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;

public class InstructionFactory
extends BaseInstructionFactory {
    private static Instruction readFrom(ShortBufferBytecodeStream stream, OffsetToObjectMapping mapping) {
        int high = stream.nextByte();
        int opcode = stream.nextByte();
        return InstructionFactory.create(high, opcode, stream, mapping);
    }

    public Instruction[] readSequenceFrom(ByteBuffer buffer, int startIndex, int length, OffsetToObjectMapping mapping) {
        return this.readSequenceFrom(buffer.asShortBuffer(), startIndex, length, mapping);
    }

    public Instruction[] readSequenceFrom(ShortBuffer buffer, int startIndex, int length, OffsetToObjectMapping mapping) {
        ShortBufferBytecodeStream range = new ShortBufferBytecodeStream(buffer, startIndex, length);
        ArrayList<Instruction> insn = new ArrayList<Instruction>(length);
        while (range.hasMore()) {
            Instruction instruction = InstructionFactory.readFrom(range, mapping);
            insn.add(instruction);
        }
        return insn.toArray(new Instruction[insn.size()]);
    }

    private static class ShortBufferBytecodeStream
    implements BytecodeStream {
        private final int length;
        private final int startIndex;
        private final ShortBuffer source;
        private int offset = 0;
        private int nextByte;
        private boolean cacheContainsValidByte = false;

        ShortBufferBytecodeStream(ShortBuffer source, int startIndex, int length) {
            this.startIndex = startIndex;
            this.length = length;
            this.source = source;
        }

        @Override
        public int nextShort() {
            assert (!this.cacheContainsValidByte) : "Unread byte in cache.";
            assert (this.offset < this.length);
            short result = this.source.get(this.startIndex + this.offset);
            ++this.offset;
            return result;
        }

        @Override
        public int nextByte() {
            if (this.cacheContainsValidByte) {
                this.cacheContainsValidByte = false;
                return this.nextByte;
            }
            int next = this.nextShort();
            this.nextByte = next & 0xFF;
            this.cacheContainsValidByte = true;
            return next >> 8 & 0xFF;
        }

        @Override
        public boolean hasMore() {
            return this.length - this.offset > 0;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }
    }
}

