/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AccessFlags;
import java.util.List;
import java.util.function.BooleanSupplier;

public class MethodAccessFlags
extends AccessFlags {
    private static final int SHARED_FLAGS = 7679;
    private static final int CF_FLAGS = 7679;
    private static final int DEX_FLAGS = 204287;

    @Override
    protected List<String> getNames() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(super.getNames())).add("synchronized")).add("bridge")).add("varargs")).add("native")).add("abstract")).add("strictfp")).build();
    }

    @Override
    protected List<BooleanSupplier> getPredicates() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(super.getPredicates())).add(this::isSynchronized)).add(this::isBridge)).add(this::isVarargs)).add(this::isNative)).add(this::isAbstract)).add(this::isStrict)).build();
    }

    private MethodAccessFlags(int flags) {
        super(flags);
    }

    public MethodAccessFlags copy() {
        return new MethodAccessFlags(this.flags);
    }

    public static MethodAccessFlags fromSharedAccessFlags(int access, boolean isConstructor) {
        assert ((access & 0x1DFF) == access);
        return MethodAccessFlags.fromCfAccessFlags(access, isConstructor);
    }

    public static MethodAccessFlags fromCfAccessFlags(int access, boolean isConstructor) {
        return new MethodAccessFlags(access & 0x1DFF | (isConstructor ? 65536 : 0));
    }

    public static MethodAccessFlags fromDexAccessFlags(int access) {
        MethodAccessFlags flags = new MethodAccessFlags(access & 0x31DFF);
        if (flags.isDeclaredSynchronized()) {
            flags.setSynchronized();
            flags.unsetDeclaredSynchronized();
        }
        return flags;
    }

    @Override
    public int getAsDexAccessFlags() {
        MethodAccessFlags copy = this.copy();
        if (copy.isSynchronized() && !copy.isNative()) {
            copy.unsetSynchronized();
            copy.setDeclaredSynchronized();
        }
        return copy.flags;
    }

    @Override
    public int getAsCfAccessFlags() {
        return this.flags & 0xFFFEFFFF;
    }

    public boolean isSynchronized() {
        return this.isSet(32);
    }

    public void setSynchronized() {
        this.set(32);
    }

    public void unsetSynchronized() {
        this.unset(32);
    }

    public boolean isBridge() {
        return this.isSet(64);
    }

    public void setBridge() {
        this.set(64);
    }

    public void unsetBridge() {
        this.unset(64);
    }

    public boolean isVarargs() {
        return this.isSet(128);
    }

    public void setVarargs() {
        this.set(128);
    }

    public boolean isNative() {
        return this.isSet(256);
    }

    public void setNative() {
        this.set(256);
    }

    public boolean isAbstract() {
        return this.isSet(1024);
    }

    public void setAbstract() {
        this.set(1024);
    }

    public void unsetAbstract() {
        this.unset(1024);
    }

    public boolean isStrict() {
        return this.isSet(2048);
    }

    public void setStrict() {
        this.set(2048);
    }

    public boolean isConstructor() {
        return this.isSet(65536);
    }

    public void setConstructor() {
        this.set(65536);
    }

    public void unsetConstructor() {
        this.unset(65536);
    }

    private boolean isDeclaredSynchronized() {
        return this.isSet(131072);
    }

    private void setDeclaredSynchronized() {
        this.set(131072);
    }

    private void unsetDeclaredSynchronized() {
        this.unset(131072);
    }
}

