/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.synthetic;

import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.JarApplicationReader;
import com.android.tools.r8.graph.JarClassFileReader;
import com.android.tools.r8.graph.JarCode;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.InternalOptions;
import java.io.IOException;
import java.util.function.BiFunction;

public abstract class TemplateMethodCode
extends JarCode {
    private final String templateMethodName;
    private final String templateMethodDesc;

    protected TemplateMethodCode(InternalOptions options, DexMethod method, String name, String desc) {
        super(method, Origin.unknown(), new JarClassFileReader.ReparseContext(), new JarApplicationReader(options));
        this.templateMethodName = name;
        this.templateMethodDesc = desc;
    }

    public void setUpContext(DexProgramClass owner) {
        assert (this.context != null);
        this.context.owner = owner;
        this.context.classCache = this.getClassAsBytes();
    }

    @Override
    protected BiFunction<String, String, JarCode> createCodeLocator(JarClassFileReader.ReparseContext context) {
        return this::getCodeOrNull;
    }

    private JarCode getCodeOrNull(String name, String desc) {
        return name.equals(this.templateMethodName) && desc.equals(this.templateMethodDesc) ? this : null;
    }

    private byte[] getClassAsBytes() {
        Class<?> clazz = this.getClass();
        String s = clazz.getSimpleName() + ".class";
        for (Class<?> outer = clazz.getEnclosingClass(); outer != null; outer = outer.getEnclosingClass()) {
            s = outer.getSimpleName() + '$' + s;
        }
        try {
            return ByteStreams.toByteArray(clazz.getResourceAsStream(s));
        }
        catch (IOException e) {
            throw new Unreachable();
        }
    }
}

