/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.shaking.KeepReason;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.Set;

public class ReasonPrinter {
    private final Set<DexDefinition> itemsQueried;
    private ReasonFormatter formatter;
    private final Map<DexEncodedField, KeepReason> liveFields;
    private final Map<DexEncodedMethod, KeepReason> liveMethods;
    private final Map<DexDefinition, KeepReason> reachablityReasons;
    private final Map<DexType, KeepReason> instantiatedTypes;

    ReasonPrinter(Set<DexDefinition> itemsQueried, Map<DexEncodedField, KeepReason> liveFields, Map<DexEncodedMethod, KeepReason> liveMethods, Map<DexDefinition, KeepReason> reachablityReasons, Map<DexType, KeepReason> instantiatedTypes) {
        this.itemsQueried = itemsQueried;
        this.liveFields = liveFields;
        this.liveMethods = liveMethods;
        this.reachablityReasons = reachablityReasons;
        this.instantiatedTypes = instantiatedTypes;
    }

    public void run(DexApplication application) {
        this.formatter = new ReasonFormatter();
        for (DexClass dexClass : application.classes()) {
            if (this.itemsQueried.contains(dexClass)) {
                this.printReasonFor(dexClass);
            }
            Arrays.stream(dexClass.staticFields()).filter(this.itemsQueried::contains).forEach(this::printReasonFor);
            Arrays.stream(dexClass.instanceFields()).filter(this.itemsQueried::contains).forEach(this::printReasonFor);
            Arrays.stream(dexClass.directMethods()).filter(this.itemsQueried::contains).forEach(this::printReasonFor);
            Arrays.stream(dexClass.virtualMethods()).filter(this.itemsQueried::contains).forEach(this::printReasonFor);
        }
    }

    private void printNoIdeaWhy(DexItem item, ReasonFormatter formatter) {
        formatter.startItem(item);
        formatter.pushEmptyPrefix();
        formatter.addReason("is kept for unknown reason.");
        formatter.popPrefix();
        formatter.endItem();
    }

    private void printOnlyAbstractShell(DexItem item, ReasonFormatter formatter) {
        formatter.startItem(item);
        KeepReason reachableReason = this.reachablityReasons.get(item);
        if (reachableReason != null) {
            formatter.pushPrefix("is not kept, only its abstract declaration is needed because it ");
            reachableReason.print(formatter);
            formatter.popPrefix();
        } else {
            formatter.pushEmptyPrefix();
            formatter.addReason("is not kept, only its abstract declaration is.");
            formatter.popPrefix();
        }
        formatter.endItem();
    }

    private void printReasonFor(DexClass item) {
        KeepReason reason = this.instantiatedTypes.get(item.type);
        if (reason == null) {
            if (item.accessFlags.isAbstract()) {
                this.printOnlyAbstractShell(item, this.formatter);
            } else {
                this.printNoIdeaWhy(item, this.formatter);
            }
        } else {
            this.formatter.startItem(item);
            this.formatter.pushIsLivePrefix();
            reason.print(this.formatter);
            this.formatter.popPrefix();
            this.formatter.endItem();
        }
    }

    private void printReasonFor(DexEncodedMethod item) {
        KeepReason reasonLive = this.liveMethods.get(item);
        if (reasonLive == null) {
            if (item.accessFlags.isAbstract()) {
                this.printOnlyAbstractShell(item, this.formatter);
            } else {
                this.printNoIdeaWhy(item.method, this.formatter);
            }
        } else {
            this.formatter.addMethodReferenceReason(item);
        }
    }

    private void printReasonFor(DexEncodedField item) {
        KeepReason reason = this.liveFields.get(item);
        if (reason == null) {
            this.printNoIdeaWhy(item.field, this.formatter);
        } else {
            this.formatter.startItem(item.field);
            this.formatter.pushIsLivePrefix();
            reason.print(this.formatter);
            this.formatter.popPrefix();
            reason = this.reachablityReasons.get(item);
            if (reason != null) {
                this.formatter.pushIsReachablePrefix();
                reason.print(this.formatter);
                this.formatter.popPrefix();
            }
            this.formatter.endItem();
        }
    }

    public static ReasonPrinter getNoOpPrinter() {
        return new NoOpReasonPrinter();
    }

    private static class NoOpReasonPrinter
    extends ReasonPrinter {
        NoOpReasonPrinter() {
            super(Collections.emptySet(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        }

        @Override
        public void run(DexApplication application) {
        }
    }

    class ReasonFormatter {
        private final Set<DexItem> seen = Sets.newIdentityHashSet();
        private final Deque<String> prefixes = new ArrayDeque<String>();
        private int indentation = -1;
        private PrintStream output = System.out;

        ReasonFormatter() {
        }

        void pushIsLivePrefix() {
            this.prefixes.push("is live because ");
        }

        void pushIsReachablePrefix() {
            this.prefixes.push("is reachable because ");
        }

        void pushPrefix(String prefix) {
            this.prefixes.push(prefix);
        }

        void pushEmptyPrefix() {
            this.prefixes.push("");
        }

        void popPrefix() {
            this.prefixes.pop();
        }

        void startItem(DexItem item) {
            ++this.indentation;
            this.indent();
            this.output.println(item.toSourceString());
        }

        private void indent() {
            for (int i = 0; i < this.indentation; ++i) {
                this.output.print("  ");
            }
        }

        void addReason(String thing) {
            this.indent();
            this.output.print("|- ");
            String prefix = this.prefixes.peek();
            this.output.print(prefix);
            this.output.println(thing);
        }

        void addMessage(String thing) {
            this.indent();
            this.output.print("|  ");
            this.output.println(thing);
        }

        void endItem() {
            --this.indentation;
        }

        void addMethodReferenceReason(DexEncodedMethod method) {
            if (!this.seen.add(method.method)) {
                return;
            }
            this.startItem(method);
            KeepReason reason = (KeepReason)ReasonPrinter.this.reachablityReasons.get(method);
            if (reason != null) {
                this.pushIsReachablePrefix();
                reason.print(this);
                this.popPrefix();
            }
            if ((reason = (KeepReason)ReasonPrinter.this.liveMethods.get(method)) != null) {
                this.pushIsLivePrefix();
                reason.print(this);
                this.popPrefix();
            }
            this.endItem();
        }

        void addTypeLivenessReason(DexType type) {
            if (!this.seen.add(type)) {
                return;
            }
            this.startItem(type);
            this.pushIsLivePrefix();
            KeepReason reason = (KeepReason)ReasonPrinter.this.instantiatedTypes.get(type);
            if (reason != null) {
                reason.print(this);
            }
            this.popPrefix();
            this.endItem();
        }
    }
}

