/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.ByteDataView;
import com.android.tools.r8.DataEntryResource;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.OutputBuilder;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ZipUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class ArchiveBuilder
implements OutputBuilder {
    private final Path archive;
    private final Origin origin;
    private ZipOutputStream stream = null;
    private boolean closed = false;
    private int openCount = 0;

    public ArchiveBuilder(Path archive) {
        this.archive = archive;
        this.origin = new PathOrigin(archive);
    }

    @Override
    public synchronized void open() {
        assert (!this.closed);
        ++this.openCount;
    }

    @Override
    public synchronized void close(DiagnosticsHandler handler) {
        assert (!this.closed);
        --this.openCount;
        if (this.openCount == 0) {
            this.closed = true;
            try {
                this.getStreamRaw().close();
                this.stream = null;
            }
            catch (IOException e) {
                handler.error(new ExceptionDiagnostic(e, this.origin));
            }
        }
    }

    private ZipOutputStream getStreamRaw() throws IOException {
        if (this.stream != null) {
            return this.stream;
        }
        this.stream = new ZipOutputStream(Files.newOutputStream(this.archive, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));
        return this.stream;
    }

    private synchronized ZipOutputStream getStream(DiagnosticsHandler handler) {
        assert (!this.closed);
        try {
            this.getStreamRaw();
        }
        catch (IOException e) {
            handler.error(new ExceptionDiagnostic(e, this.origin));
        }
        return this.stream;
    }

    private void handleIOException(IOException e, DiagnosticsHandler handler) {
        if (e instanceof ZipException && e.getMessage().startsWith("duplicate entry")) {
            handler.warning(new ExceptionDiagnostic(e, this.origin));
        } else {
            handler.error(new ExceptionDiagnostic(e, this.origin));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDirectory(String name, DiagnosticsHandler handler) {
        if (name.charAt(name.length() - 1) != '/') {
            name = name + '/';
        }
        ZipEntry entry = new ZipEntry(name);
        entry.setTime(0L);
        ZipOutputStream zip2 = this.getStream(handler);
        ArchiveBuilder archiveBuilder = this;
        synchronized (archiveBuilder) {
            try {
                zip2.putNextEntry(entry);
                zip2.closeEntry();
            }
            catch (IOException e) {
                this.handleIOException(e, handler);
            }
        }
    }

    @Override
    public void addFile(String name, DataEntryResource content, DiagnosticsHandler handler) {
        try (InputStream in = content.getByteStream();){
            this.addFile(name, ByteDataView.of(ByteStreams.toByteArray(in)), handler);
        }
        catch (IOException e) {
            this.handleIOException(e, handler);
        }
        catch (ResourceException e) {
            handler.error(new StringDiagnostic("Failed to open input: " + e.getMessage(), content.getOrigin()));
        }
    }

    @Override
    public synchronized void addFile(String name, ByteDataView content, DiagnosticsHandler handler) {
        try {
            ZipUtils.writeToZipStream(this.getStream(handler), name, content, 0);
        }
        catch (IOException e) {
            this.handleIOException(e, handler);
        }
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public Path getPath() {
        return this.archive;
    }
}

