/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.graph.PresortedComparable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class OrderedMergingIterator<T extends KeyedDexItem<S>, S extends PresortedComparable<S>>
implements Iterator<T> {
    private final T[] one;
    private final T[] other;
    private int oneIndex = 0;
    private int otherIndex = 0;

    public OrderedMergingIterator(T[] one, T[] other) {
        this.one = one;
        this.other = other;
    }

    private static <T> T getNextChecked(T[] array, int position) {
        if (position >= array.length) {
            throw new NoSuchElementException();
        }
        return array[position];
    }

    @Override
    public boolean hasNext() {
        return this.oneIndex < this.one.length || this.otherIndex < this.other.length;
    }

    @Override
    public T next() {
        if (this.oneIndex >= this.one.length) {
            return (T)((KeyedDexItem)OrderedMergingIterator.getNextChecked(this.other, this.otherIndex++));
        }
        if (this.otherIndex >= this.other.length) {
            return (T)((KeyedDexItem)OrderedMergingIterator.getNextChecked(this.one, this.oneIndex++));
        }
        int comparison = ((KeyedDexItem)this.one[this.oneIndex]).getKey().compareTo(((KeyedDexItem)this.other[this.otherIndex]).getKey());
        if (comparison < 0) {
            return this.one[this.oneIndex++];
        }
        if (comparison == 0) {
            throw new InternalCompilerError("Source arrays are not disjoint.");
        }
        return this.other[this.otherIndex++];
    }
}

