/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.ClassKind;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.desugar.InterfaceMethodRewriter;
import com.android.tools.r8.ir.desugar.LambdaRewriter;
import com.android.tools.r8.utils.ClassMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class ProgramClassCollection
extends ClassMap<DexProgramClass> {
    public static ProgramClassCollection create(List<DexProgramClass> classes, ApplicationReader.ProgramClassConflictResolver conflictResolver) {
        ConcurrentHashMap<DexType, Supplier<DexProgramClass>> map2 = new ConcurrentHashMap<DexType, Supplier<DexProgramClass>>();
        for (DexProgramClass clazz : classes) {
            map2.merge(clazz.type, clazz, (a, b) -> conflictResolver.resolveClassConflict((DexProgramClass)a.get(), (DexProgramClass)b.get()));
        }
        return new ProgramClassCollection(map2);
    }

    private ProgramClassCollection(ConcurrentHashMap<DexType, Supplier<DexProgramClass>> classes) {
        super(classes, null);
    }

    @Override
    public String toString() {
        return "program classes: " + super.toString();
    }

    @Override
    DexProgramClass resolveClassConflict(DexProgramClass a, DexProgramClass b) {
        return ProgramClassCollection.resolveClassConflictImpl(a, b);
    }

    @Override
    Supplier<DexProgramClass> getTransparentSupplier(DexProgramClass clazz) {
        return clazz;
    }

    @Override
    ClassKind getClassKind() {
        return ClassKind.PROGRAM;
    }

    public static DexProgramClass resolveClassConflictImpl(DexProgramClass a, DexProgramClass b) {
        assert (a.type == b.type);
        if (a.originatesFromDexResource() && b.originatesFromDexResource() && a.accessFlags.isSynthetic() && b.accessFlags.isSynthetic() && ProgramClassCollection.assumeClassesAreEqual(a)) {
            return a;
        }
        throw new CompilationError("Program type already present: " + a.type.toSourceString());
    }

    private static boolean assumeClassesAreEqual(DexProgramClass a) {
        return LambdaRewriter.hasLambdaClassPrefix(a.type) || InterfaceMethodRewriter.hasDispatchClassSuffix(a.type) || a.type.descriptor.toString().equals("L$r8$twr$utility;");
    }
}

