/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.ClassFileInput;
import com.android.builder.dexing.FileBasedClassFileEntry;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Predicate;
import java.util.stream.Stream;

final class DirectoryBasedClassFileInput
implements ClassFileInput {
    private final Path rootPath;

    public DirectoryBasedClassFileInput(Path rootPath) {
        this.rootPath = rootPath;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Stream<ClassFileEntry> entries(Predicate<String> filter) throws IOException {
        Predicate<String> predicate = CLASS_MATCHER.and(filter);
        return Files.walk(this.rootPath, new FileVisitOption[0]).filter(p3 -> predicate.test(p3.toString())).map(this::createEntryFromPath);
    }

    @Override
    public Path getPath() {
        return this.rootPath;
    }

    private ClassFileEntry createEntryFromPath(Path path) {
        return new FileBasedClassFileEntry(this.rootPath, path, this);
    }
}

