/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa.back;

import com.android.dx.rop.code.CstInsn;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.ssa.BasicRegisterMapper;
import com.android.dx.ssa.NormalSsaInsn;
import com.android.dx.ssa.RegisterMapper;
import com.android.dx.ssa.SsaMethod;
import com.android.dx.ssa.back.InterferenceGraph;
import com.android.dx.ssa.back.RegisterAllocator;
import com.android.dx.util.BitIntSet;
import java.util.BitSet;

public class FirstFitAllocator
extends RegisterAllocator {
    private static final boolean PRESLOT_PARAMS = true;
    private final BitSet mapped;

    public FirstFitAllocator(SsaMethod ssaMeth, InterferenceGraph interference) {
        super(ssaMeth, interference);
        this.mapped = new BitSet(ssaMeth.getRegCount());
    }

    @Override
    public boolean wantsParamsMovedHigh() {
        return true;
    }

    @Override
    public RegisterMapper allocateRegisters() {
        int oldRegCount = this.ssaMeth.getRegCount();
        BasicRegisterMapper mapper = new BasicRegisterMapper(oldRegCount);
        int nextNewRegister = 0;
        nextNewRegister = this.ssaMeth.getParamWidth();
        for (int i4 = 0; i4 < oldRegCount; ++i4) {
            if (this.mapped.get(i4)) continue;
            int maxCategory = this.getCategoryForSsaReg(i4);
            BitIntSet current = new BitIntSet(oldRegCount);
            this.interference.mergeInterferenceSet(i4, current);
            boolean isPreslotted = false;
            int newReg = 0;
            if (this.isDefinitionMoveParam(i4)) {
                NormalSsaInsn defInsn = (NormalSsaInsn)this.ssaMeth.getDefinitionForRegister(i4);
                newReg = this.paramNumberFromMoveParam(defInsn);
                mapper.addMapping(i4, newReg, maxCategory);
                isPreslotted = true;
            } else {
                mapper.addMapping(i4, nextNewRegister, maxCategory);
                newReg = nextNewRegister;
            }
            for (int j4 = i4 + 1; j4 < oldRegCount; ++j4) {
                if (this.mapped.get(j4) || this.isDefinitionMoveParam(j4) || current.has(j4) || isPreslotted && maxCategory < this.getCategoryForSsaReg(j4)) continue;
                this.interference.mergeInterferenceSet(j4, current);
                maxCategory = Math.max(maxCategory, this.getCategoryForSsaReg(j4));
                mapper.addMapping(j4, newReg, maxCategory);
                this.mapped.set(j4);
            }
            this.mapped.set(i4);
            if (isPreslotted) continue;
            nextNewRegister += maxCategory;
        }
        return mapper;
    }

    private int paramNumberFromMoveParam(NormalSsaInsn ndefInsn) {
        CstInsn origInsn = (CstInsn)ndefInsn.getOriginalRopInsn();
        return ((CstInteger)origInsn.getConstant()).getValue();
    }
}

