/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.merge;

import com.android.builder.merge.DelegateIncrementalFileMergerInput;
import com.android.builder.merge.IncrementalFileMergerInput;
import com.android.ide.common.resources.FileStatus;
import com.android.utils.ImmutableCollectors;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.function.Function;

public class RenameIncrementalFileMergerInput
extends DelegateIncrementalFileMergerInput {
    private final Function<String, String> rename;
    private final Function<String, String> inverseRename;
    private final BiMap<String, String> renameCache;

    public RenameIncrementalFileMergerInput(IncrementalFileMergerInput input, Function<String, String> rename, Function<String, String> inverseRename) {
        super(input);
        this.rename = rename;
        this.inverseRename = inverseRename;
        this.renameCache = HashBiMap.create();
    }

    private String directRename(String source) {
        return (String)this.renameCache.computeIfAbsent((Object)source, this.rename);
    }

    private String inverseRename(String destination) {
        return (String)this.renameCache.inverse().computeIfAbsent((Object)destination, this.inverseRename);
    }

    @Override
    public ImmutableSet<String> getUpdatedPaths() {
        return (ImmutableSet)super.getUpdatedPaths().stream().map(this::directRename).collect(ImmutableCollectors.toImmutableSet());
    }

    @Override
    public ImmutableSet<String> getAllPaths() {
        return (ImmutableSet)super.getAllPaths().stream().map(this::directRename).collect(ImmutableCollectors.toImmutableSet());
    }

    @Override
    public FileStatus getFileStatus(String path) {
        return super.getFileStatus(this.inverseRename(path));
    }

    @Override
    public InputStream openPath(String path) {
        return super.openPath(this.inverseRename(path));
    }
}

