/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.errors;

import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.IssueReporter;
import com.android.utils.ILogger;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/builder/errors/DefaultIssueReporter;", "Lcom/android/builder/errors/IssueReporter;", "logger", "Lcom/android/utils/ILogger;", "(Lcom/android/utils/ILogger;)V", "warnings", "", "Lcom/android/builder/errors/IssueReporter$Type;", "hasIssue", "", "type", "reportIssue", "", "severity", "Lcom/android/builder/errors/IssueReporter$Severity;", "exception", "Lcom/android/builder/errors/EvalIssueException;", "builder"})
public final class DefaultIssueReporter
extends IssueReporter {
    @NotNull
    private final ILogger logger;
    @NotNull
    private final Set<IssueReporter.Type> warnings;

    public DefaultIssueReporter(@NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.warnings = new LinkedHashSet();
    }

    @Override
    protected void reportIssue(@NotNull IssueReporter.Type type, @NotNull IssueReporter.Severity severity, @NotNull EvalIssueException exception) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        if (severity == IssueReporter.Severity.ERROR) {
            throw exception;
        }
        this.warnings.add(type);
        StringBuilder stringBuilder = new StringBuilder(exception.getMessage());
        List<String> list = exception.getMultilineMessage();
        if (list != null) {
            StringBuilder cfr_ignored_0 = (StringBuilder)CollectionsKt.joinTo$default((Iterable)list, (Appendable)stringBuilder, (CharSequence)"\n", null, null, (int)0, null, null, (int)124, null);
        }
        this.logger.warning(stringBuilder.toString(), new Object[0]);
    }

    @Override
    public boolean hasIssue(@NotNull IssueReporter.Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.warnings.contains((Object)type);
    }
}

