/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.manifest;

import com.android.aapt.Resources;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProtoXmlHelper {
    public static final String NO_NAMESPACE_URI = "";
    public static final int NO_RESOURCE_ID = 0;
    public static final int DECIMAL_INTEGER_TYPE_ID = 16;
    public static final int HEX_INTEGER_TYPE_ID = 17;
    public static final int BOOLEAN_TYPE_ID = 18;
    public static final int BOOLEAN_TRUE = -1;
    public static final int BOOLEAN_FALSE = 0;

    public static Optional<Resources.XmlAttribute> findAttributeWithName(Resources.XmlElement el, String name) {
        return ProtoXmlHelper.findAttribute(el, NO_NAMESPACE_URI, name);
    }

    public static Optional<Resources.XmlAttribute> findAttribute(Resources.XmlElement el, String namespaceUri, String name) {
        return el.getAttributeList().stream().filter(ProtoXmlHelper.attributeWithName(name).and(ProtoXmlHelper.attributeWithNamespaceUri(namespaceUri))).findFirst();
    }

    public static boolean getAttributeValueAsBoolean(Resources.XmlAttribute attribute) {
        Preconditions.checkArgument((attribute.getCompiledItem().getPrim().getType() == 18 ? 1 : 0) != 0, (Object)"Attribute type mismatch. Expected a boolean.");
        return attribute.getCompiledItem().getPrim().getData() != 0;
    }

    public static Resources.XmlAttribute.Builder setAttributeValueAsBoolean(Resources.XmlAttribute.Builder attributeBuilder, boolean value) {
        attributeBuilder.clearValue();
        return attributeBuilder.setCompiledItem(Resources.Item.newBuilder().setPrim(Resources.Primitive.newBuilder().setType(18).setData(value ? -1 : 0)));
    }

    public static Resources.XmlAttribute.Builder setAttributeValueAsDecimalInteger(Resources.XmlAttribute.Builder attributeBuilder, int value) {
        attributeBuilder.setValue(String.valueOf(value));
        return attributeBuilder.setCompiledItem(Resources.Item.newBuilder().setPrim(Resources.Primitive.newBuilder().setType(16).setData(value)));
    }

    public static Resources.XmlAttribute.Builder findOrCreateAttributeBuilder(Resources.XmlElement.Builder el, String name) {
        return ProtoXmlHelper.findOrCreateAttributeBuilder(el, NO_NAMESPACE_URI, name);
    }

    public static Resources.XmlAttribute.Builder findOrCreateAttributeBuilder(Resources.XmlElement.Builder el, String namespaceUri, String name) {
        return el.getAttributeBuilderList().stream().filter(ProtoXmlHelper.attributeWithName(name).and(ProtoXmlHelper.attributeWithNamespaceUri(namespaceUri))).findFirst().orElseGet(() -> {
            el.addAttribute(Resources.XmlAttribute.newBuilder().setName(name).setNamespaceUri(namespaceUri).build());
            return el.getAttributeBuilder(el.getAttributeCount() - 1);
        });
    }

    public static Resources.XmlElement.Builder removeAttribute(Resources.XmlElement.Builder el, String namespaceUri, String name) {
        for (int i = 0; i < el.getAttributeCount(); ++i) {
            if (!el.getAttribute(i).getName().equals(name) || !el.getAttribute(i).getNamespaceUri().equals(namespaceUri)) continue;
            el.removeAttribute(i);
            return el;
        }
        return el;
    }

    public static Optional<Resources.XmlElement> getFirstElement(Resources.XmlNode rootNode, String elementName) {
        List elements = ProtoXmlHelper.findElements(rootNode, elementName).collect(Collectors.toList());
        return elements.isEmpty() ? Optional.empty() : Optional.of(elements.get(0));
    }

    public static Resources.XmlElement getExactlyOneElement(Resources.XmlNode rootNode, String elementName) {
        List elements = ProtoXmlHelper.findElements(rootNode, elementName).collect(Collectors.toList());
        Preconditions.checkState((elements.size() == 1 ? 1 : 0) != 0, (Object)String.format("Expected exactly one <%s> element.", elementName));
        return (Resources.XmlElement)elements.get(0);
    }

    public static Resources.XmlElement.Builder getFirstOrCreateElementBuilder(Resources.XmlNode.Builder rootNode, String elementName) {
        List elements = ProtoXmlHelper.findElementBuilders(rootNode, elementName).collect(Collectors.toList());
        if (!elements.isEmpty()) {
            return (Resources.XmlElement.Builder)elements.get(0);
        }
        Preconditions.checkArgument((boolean)rootNode.hasElement(), (Object)"Expecting an element node.");
        Resources.XmlElement.Builder rootElementBuilder = rootNode.getElementBuilder();
        rootElementBuilder.addChild(Resources.XmlNode.newBuilder().setElement(Resources.XmlElement.newBuilder().setName(elementName)));
        return rootElementBuilder.getChildBuilder(rootElementBuilder.getChildCount() - 1).getElementBuilder();
    }

    public static Resources.XmlElement.Builder getExactlyOneElementBuilder(Resources.XmlNode.Builder rootNode, String elementName) {
        List elements = ProtoXmlHelper.findElementBuilders(rootNode, elementName).collect(Collectors.toList());
        Preconditions.checkState((elements.size() == 1 ? 1 : 0) != 0, (Object)String.format("Expected exactly one <%s> element.", elementName));
        return (Resources.XmlElement.Builder)elements.get(0);
    }

    public static Stream<? extends Resources.XmlNode> flattened(Resources.XmlNode node) {
        return Stream.concat(Stream.of(node), node.hasElement() ? node.getElement().getChildList().stream().flatMap(ProtoXmlHelper::flattened) : Stream.empty());
    }

    public static Stream<? extends Resources.XmlNode.Builder> flattenedBuilders(Resources.XmlNode.Builder node) {
        return Stream.concat(Stream.of(node), node.hasElement() ? node.getElementBuilder().getChildBuilderList().stream().flatMap(ProtoXmlHelper::flattenedBuilders) : Stream.empty());
    }

    public static Stream<Resources.XmlElement> findElements(Resources.XmlNode rootNode, String name) {
        return ProtoXmlHelper.flattened(rootNode).map(node -> node.getElement()).filter(ProtoXmlHelper.elementWithName(name).and(ProtoXmlHelper.elementWithEmptyNamespace()));
    }

    public static Stream<Resources.XmlElement.Builder> findElementBuilders(Resources.XmlNode.Builder rootNode, String name) {
        return ProtoXmlHelper.flattenedBuilders(rootNode).filter(Resources.XmlNode.Builder::hasElement).map(Resources.XmlNode.Builder::getElementBuilder).filter(ProtoXmlHelper.elementWithName(name).and(ProtoXmlHelper.elementWithEmptyNamespace()));
    }

    public static Predicate<Resources.XmlElementOrBuilder> elementWithEmptyNamespace() {
        return element -> element.getNamespaceUri().isEmpty();
    }

    public static Predicate<Resources.XmlElementOrBuilder> elementWithName(String name) {
        Preconditions.checkNotNull((Object)name);
        return element -> name.equals(element.getName());
    }

    public static Predicate<Resources.XmlAttributeOrBuilder> attributeWithName(String name) {
        Preconditions.checkNotNull((Object)name);
        return attribute -> name.equals(attribute.getName());
    }

    public static Predicate<Resources.XmlAttributeOrBuilder> attributeWithNamespaceUri(String namespaceUri) {
        Preconditions.checkNotNull((Object)namespaceUri);
        return attribute -> namespaceUri.equals(attribute.getNamespaceUri());
    }

    private ProtoXmlHelper() {
    }
}

