/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.mergers;

import com.android.tools.build.bundletool.utils.ProtoUtils;
import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

class MergingUtils {
    public static <T> Optional<T> getSameValueOrNonNull(@Nullable T nullableValue, T otherValue) {
        Preconditions.checkNotNull(otherValue);
        if (nullableValue == null || nullableValue.equals(otherValue)) {
            return Optional.of(otherValue);
        }
        return Optional.empty();
    }

    public static <T> T getMergedValueOrNonNull(@Nullable T nullableValue, T otherValue, BiFunction<T, T, T> mergeFn) {
        Preconditions.checkNotNull(otherValue);
        if (nullableValue != null) {
            return mergeFn.apply(nullableValue, otherValue);
        }
        return otherValue;
    }

    public static <T extends Message> T mergeProtos(@Nullable T nullableValue, T otherValue) {
        Preconditions.checkNotNull(otherValue);
        return (T)(nullableValue == null ? otherValue : ProtoUtils.mergeFromProtos(nullableValue, (Message[])new Message[]{otherValue}));
    }

    private MergingUtils() {
    }
}

