/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.mergers.ModuleSplitsToShardMerger;
import com.android.tools.build.bundletool.mergers.SameTargetingMerger;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.splitters.AbiNativeLibrariesSplitter;
import com.android.tools.build.bundletool.splitters.ModuleSplitSplitter;
import com.android.tools.build.bundletool.splitters.ScreenDensityResourcesSplitter;
import com.android.tools.build.bundletool.splitters.SplittingPipeline;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class BundleSharder {
    private static final String SHARD_MODULE_NAME = "standalone";
    private final ImmutableList<BundleModule> modules;
    private final ImmutableList<OptimizationDimension> shardingDimensions;

    public BundleSharder(ImmutableList<BundleModule> modules, ImmutableList<OptimizationDimension> optimizationDimensions) {
        Preconditions.checkArgument((!modules.isEmpty() ? 1 : 0) != 0, (Object)"At least one module is required.");
        this.modules = modules;
        this.shardingDimensions = optimizationDimensions;
    }

    public ImmutableList<ModuleSplit> shardBundle() {
        BundleModule mergedModules = this.mergeModules(this.modules);
        ImmutableList<ModuleSplit> moduleSplits = this.generateSplits(mergedModules);
        return this.combineSplitsToShards(moduleSplits);
    }

    private BundleModule mergeModules(ImmutableList<BundleModule> modules) {
        if (modules.size() > 1) {
            throw new CommandExecutionException("Only single module bundles are currently supported for standalone APKs.", new Object[0]);
        }
        BundleModule mergedModule = (BundleModule)modules.get(0);
        return BundleModule.builder().setName(BundleModuleName.create(SHARD_MODULE_NAME)).addEntries((Collection<ModuleEntry>)mergedModule.getEntries()).build();
    }

    private ImmutableList<ModuleSplit> generateSplits(BundleModule module) {
        ImmutableList.Builder rawSplits = ImmutableList.builder();
        SplittingPipeline nativePipeline = this.createNativeLibrariesSplittingPipeline();
        rawSplits.addAll(nativePipeline.split(ModuleSplit.forNativeLibraries(module)));
        SplittingPipeline resourcesPipeline = this.createResourcesSplittingPipeline();
        rawSplits.addAll(resourcesPipeline.split(ModuleSplit.forResources(module)));
        rawSplits.add((Object)ModuleSplit.forAssets(module));
        rawSplits.add((Object)ModuleSplit.forCode(module));
        rawSplits.add((Object)ModuleSplit.forRoot(module));
        ImmutableList<ModuleSplit> mergedSplits = new SameTargetingMerger().merge((ImmutableCollection<ModuleSplit>)rawSplits.build());
        long masterSplitCount = mergedSplits.stream().filter(ModuleSplit::isMasterSplit).count();
        Preconditions.checkState((masterSplitCount == 1L ? 1 : 0) != 0, (String)"Expected one master split, got %s.", (long)masterSplitCount);
        return mergedSplits;
    }

    private SplittingPipeline createNativeLibrariesSplittingPipeline() {
        ImmutableList.Builder nativeSplitters = ImmutableList.builder();
        if (this.shardingDimensions.contains((Object)OptimizationDimension.ABI)) {
            nativeSplitters.add((Object)new AbiNativeLibrariesSplitter());
        }
        return SplittingPipeline.create((ImmutableList<ModuleSplitSplitter>)nativeSplitters.build());
    }

    private SplittingPipeline createResourcesSplittingPipeline() {
        ImmutableList.Builder resourceSplitters = ImmutableList.builder();
        if (this.shardingDimensions.contains((Object)OptimizationDimension.DENSITY)) {
            resourceSplitters.add((Object)new ScreenDensityResourcesSplitter());
        }
        return SplittingPipeline.create((ImmutableList<ModuleSplitSplitter>)resourceSplitters.build());
    }

    private ImmutableList<ModuleSplit> combineSplitsToShards(ImmutableList<ModuleSplit> splits) {
        ImmutableList<ModuleSplit> abiSplits = BundleSharder.filterByTargeting(splits, Targeting.ApkTargeting::hasAbiTargeting);
        ImmutableList<ModuleSplit> densitySplits = BundleSharder.filterByTargeting(splits, Targeting.ApkTargeting::hasScreenDensityTargeting);
        ImmutableList masterSplits = (ImmutableList)splits.stream().filter(split -> !abiSplits.contains(split) && !densitySplits.contains(split)).collect(ImmutableList.toImmutableList());
        Preconditions.checkState((masterSplits.size() == 1 ? 1 : 0) != 0, (String)"Expecting exactly one master split, got %s.", (int)masterSplits.size());
        Preconditions.checkState((((ModuleSplit)masterSplits.get(0)).isMasterSplit() && ((ModuleSplit)masterSplits.get(0)).getTargeting().equals(Targeting.ApkTargeting.getDefaultInstance()) ? 1 : 0) != 0, (Object)"Master split is expected to have default targeting and appropriate properties.");
        Preconditions.checkState((boolean)Sets.intersection((Set)Sets.newHashSet(abiSplits), (Set)Sets.newHashSet(densitySplits)).isEmpty(), (Object)"No split is expected to have both ABI and screen density targeting.");
        ImmutableList.Builder splitGroups = ImmutableList.builder();
        splitGroups.add((Object)masterSplits);
        if (!abiSplits.isEmpty()) {
            splitGroups.add(abiSplits);
        }
        if (!densitySplits.isEmpty()) {
            splitGroups.add(densitySplits);
        }
        return (ImmutableList)Lists.cartesianProduct((List)splitGroups.build()).stream().map(ImmutableList::copyOf).map(splitsOfShard -> new ModuleSplitsToShardMerger().merge((ImmutableCollection<ModuleSplit>)splitsOfShard)).map(Iterables::getOnlyElement).collect(ImmutableList.toImmutableList());
    }

    private static ImmutableList<ModuleSplit> filterByTargeting(ImmutableList<ModuleSplit> splits, Predicate<Targeting.ApkTargeting> predicate) {
        return (ImmutableList)splits.stream().filter(split -> predicate.test(split.getTargeting())).collect(ImmutableList.toImmutableList());
    }
}

