/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.mergers.SameTargetingMerger;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.splitters.AbiNativeLibrariesSplitter;
import com.android.tools.build.bundletool.splitters.LanguageResourcesSplitter;
import com.android.tools.build.bundletool.splitters.ModuleSplitSplitter;
import com.android.tools.build.bundletool.splitters.ScreenDensityResourcesSplitter;
import com.android.tools.build.bundletool.splitters.SplittingPipeline;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Int32Value;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;

public class ModuleSplitter {
    private final BundleModule module;
    private final ImmutableList<OptimizationDimension> optimizationDimensions;
    private final SuffixManager suffixManager = new SuffixManager();

    public ModuleSplitter(BundleModule module, ImmutableList<OptimizationDimension> optimizationDimensions) {
        this.optimizationDimensions = optimizationDimensions;
        this.module = module;
    }

    public ImmutableList<ModuleSplit> splitModule() {
        if (ModuleSplitter.targetsOnlyPreL(this.module)) {
            throw new CommandExecutionException("Cannot split module '%s' because it does not target devices on Android L or above.", this.module.getName());
        }
        ImmutableList.Builder splits = ImmutableList.builder();
        SplittingPipeline resourcesPipeline = this.createResourcesSplittingPipeline();
        splits.addAll(resourcesPipeline.split(ModuleSplit.forResources(this.module)));
        SplittingPipeline nativePipeline = this.createNativeLibrariesSplittingPipeline();
        splits.addAll(nativePipeline.split(ModuleSplit.forNativeLibraries(this.module)));
        SplittingPipeline assetsPipeline = this.createAssetsSplittingPipeline();
        splits.addAll(assetsPipeline.split(ModuleSplit.forAssets(this.module)));
        splits.add((Object)ModuleSplit.forCode(this.module));
        splits.add((Object)ModuleSplit.forRoot(this.module));
        ImmutableList<ModuleSplit> mergedSplits = new SameTargetingMerger().merge((ImmutableCollection<ModuleSplit>)splits.build());
        ImmutableList defaultTargetingSplits = (ImmutableList)mergedSplits.stream().filter(split -> split.getTargeting().equals(Targeting.ApkTargeting.getDefaultInstance())).collect(ImmutableList.toImmutableList());
        Preconditions.checkState((defaultTargetingSplits.size() == 1 ? 1 : 0) != 0, (Object)"Expected one split with default targeting.");
        return (ImmutableList)mergedSplits.stream().map(this::addLPlusTargeting).map(this::writeSplitIdInManifest).collect(ImmutableList.toImmutableList());
    }

    public ModuleSplit writeSplitIdInManifest(ModuleSplit moduleSplit) {
        String resolvedSuffix = this.suffixManager.resolveSuffix(moduleSplit.getSuffix());
        return moduleSplit.writeSplitIdInManifest(resolvedSuffix);
    }

    private SplittingPipeline createResourcesSplittingPipeline() {
        ImmutableList.Builder resourceSplitters = ImmutableList.builder();
        if (this.optimizationDimensions.contains((Object)OptimizationDimension.DENSITY)) {
            resourceSplitters.add((Object)new ScreenDensityResourcesSplitter());
        }
        if (this.optimizationDimensions.contains((Object)OptimizationDimension.LANGUAGE)) {
            resourceSplitters.add((Object)new LanguageResourcesSplitter());
        }
        return SplittingPipeline.create((ImmutableList<ModuleSplitSplitter>)resourceSplitters.build());
    }

    private SplittingPipeline createNativeLibrariesSplittingPipeline() {
        ImmutableList.Builder nativeSplitters = ImmutableList.builder();
        if (this.optimizationDimensions.contains((Object)OptimizationDimension.ABI)) {
            nativeSplitters.add((Object)new AbiNativeLibrariesSplitter());
        }
        return SplittingPipeline.create((ImmutableList<ModuleSplitSplitter>)nativeSplitters.build());
    }

    private SplittingPipeline createAssetsSplittingPipeline() {
        ImmutableList.Builder assetsSplitters = ImmutableList.builder();
        return SplittingPipeline.create((ImmutableList<ModuleSplitSplitter>)assetsSplitters.build());
    }

    private static boolean targetsOnlyPreL(BundleModule module) {
        Optional<Integer> maxSdkVersion = module.getManifest().getMaxSdkVersion();
        return maxSdkVersion.isPresent() && maxSdkVersion.get() < 21;
    }

    private ModuleSplit addLPlusTargeting(ModuleSplit split) {
        Preconditions.checkState((!split.getTargeting().hasSdkVersionTargeting() ? 1 : 0) != 0, (Object)"Split already targets SDK version.");
        return split.toBuilder().setTargeting(split.getTargeting().toBuilder().setSdkVersionTargeting(Targeting.SdkVersionTargeting.newBuilder().addValue(Targeting.SdkVersion.newBuilder().setMin(Int32Value.newBuilder().setValue(21)))).build()).build();
    }

    private static class SuffixManager {
        @GuardedBy(value="this")
        private final Set<String> usedSuffixes = new HashSet<String>();

        private SuffixManager() {
        }

        synchronized String resolveSuffix(String proposedSuffix) {
            String currentProposal = proposedSuffix;
            int serialNumber = 1;
            while (this.usedSuffixes.contains(currentProposal)) {
                currentProposal = String.format("%s_%d", proposedSuffix, ++serialNumber);
            }
            this.usedSuffixes.add(currentProposal);
            return currentProposal;
        }
    }
}

