/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib;

import java.nio.ByteBuffer;
import shadow.bundletool.com.android.ddmlib.AllocationInfo;
import shadow.bundletool.com.android.ddmlib.ByteBufferUtil;

public class AllocationsParser {
    private static String descriptorToDot(String str) {
        int array = 0;
        while (str.startsWith("[")) {
            str = str.substring(1);
            ++array;
        }
        int len = str.length();
        if (len >= 2 && str.charAt(0) == 'L' && str.charAt(len - 1) == ';') {
            str = str.substring(1, len - 1);
            str = str.replace('/', '.');
        } else if ("C".equals(str)) {
            str = "char";
        } else if ("B".equals(str)) {
            str = "byte";
        } else if ("Z".equals(str)) {
            str = "boolean";
        } else if ("S".equals(str)) {
            str = "short";
        } else if ("I".equals(str)) {
            str = "int";
        } else if ("J".equals(str)) {
            str = "long";
        } else if ("F".equals(str)) {
            str = "float";
        } else if ("D".equals(str)) {
            str = "double";
        }
        for (int a = 0; a < array; ++a) {
            str = str + "[]";
        }
        return str;
    }

    private static void readStringTable(ByteBuffer data2, String[] strings) {
        int count = strings.length;
        for (int i = 0; i < count; ++i) {
            int nameLen = data2.getInt();
            String descriptor = ByteBufferUtil.getString(data2, nameLen);
            strings[i] = AllocationsParser.descriptorToDot(descriptor);
        }
    }

    public static AllocationInfo[] parse(ByteBuffer data2) {
        data2 = AllocationsParser.fixAllocOverflow(data2);
        int messageHdrLen = data2.get() & 0xFF;
        int entryHdrLen = data2.get() & 0xFF;
        int stackFrameLen = data2.get() & 0xFF;
        int numEntries = data2.getShort() & 0xFFFF;
        int offsetToStrings = data2.getInt();
        int numClassNames = data2.getShort() & 0xFFFF;
        int numMethodNames = data2.getShort() & 0xFFFF;
        int numFileNames = data2.getShort() & 0xFFFF;
        data2.position(offsetToStrings);
        String[] classNames = new String[numClassNames];
        String[] methodNames = new String[numMethodNames];
        String[] fileNames = new String[numFileNames];
        AllocationsParser.readStringTable(data2, classNames);
        AllocationsParser.readStringTable(data2, methodNames);
        AllocationsParser.readStringTable(data2, fileNames);
        data2.position(messageHdrLen);
        AllocationInfo[] allocations = new AllocationInfo[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            int totalSize = data2.getInt();
            int threadId = data2.getShort() & 0xFFFF;
            int classNameIndex = data2.getShort() & 0xFFFF;
            int stackDepth = data2.get() & 0xFF;
            for (int skip = 9; skip < entryHdrLen; ++skip) {
                data2.get();
            }
            StackTraceElement[] steArray = new StackTraceElement[stackDepth];
            for (int sti = 0; sti < stackDepth; ++sti) {
                int methodClassNameIndex = data2.getShort() & 0xFFFF;
                int methodNameIndex = data2.getShort() & 0xFFFF;
                int methodSourceFileIndex = data2.getShort() & 0xFFFF;
                short lineNumber = data2.getShort();
                String methodClassName = classNames[methodClassNameIndex];
                String methodName = methodNames[methodNameIndex];
                String methodSourceFile = fileNames[methodSourceFileIndex];
                steArray[sti] = new StackTraceElement(methodClassName, methodName, methodSourceFile, lineNumber);
                for (int skip = 8; skip < stackFrameLen; ++skip) {
                    data2.get();
                }
            }
            allocations[i] = new AllocationInfo(numEntries - i, classNames[classNameIndex], totalSize, (short)threadId, steArray);
        }
        return allocations;
    }

    private static ByteBuffer fixAllocOverflow(ByteBuffer original) {
        int i;
        ByteBuffer output = ByteBuffer.allocate(original.capacity());
        int messageHdrLen = original.get() & 0xFF;
        output.put((byte)messageHdrLen);
        int entryHdrLen = original.get() & 0xFF;
        output.put((byte)entryHdrLen);
        int stackFrameLen = original.get() & 0xFF;
        output.put((byte)stackFrameLen);
        int numEntries = original.getShort() & 0xFFFF;
        if (numEntries != 0) {
            original.rewind();
            return original;
        }
        int offsetToStrings = original.getInt();
        if (offsetToStrings - messageHdrLen < entryHdrLen + stackFrameLen) {
            original.rewind();
            return original;
        }
        numEntries = 65535;
        output.putShort((short)numEntries);
        output.putInt(offsetToStrings);
        int numClassNames = original.getShort() & 0xFFFF;
        output.putShort((short)numClassNames);
        int numMethodNames = original.getShort() & 0xFFFF;
        output.putShort((short)numMethodNames);
        int numFileNames = original.getShort() & 0xFFFF;
        output.putShort((short)numFileNames);
        for (i = output.position(); i < messageHdrLen; ++i) {
            output.put((byte)0);
        }
        original.position(messageHdrLen);
        for (i = 0; i < numEntries; ++i) {
            output.putInt(original.getInt());
            output.putShort(original.getShort());
            output.putShort(original.getShort());
            int stackDepth = original.get() & 0xFF;
            output.put((byte)stackDepth);
            for (int skip = 9; skip < entryHdrLen; ++skip) {
                output.put(original.get());
            }
            for (int sti = 0; sti < stackDepth; ++sti) {
                output.putShort(original.getShort());
                output.putShort(original.getShort());
                output.putShort(original.getShort());
                output.putShort(original.getShort());
                for (int skip = 8; skip < stackFrameLen; ++skip) {
                    output.put(original.get());
                }
            }
        }
        original.position(offsetToStrings);
        int stringOffset = output.position();
        while (original.hasRemaining()) {
            output.put(original.get());
        }
        int end = output.position();
        output.position(5);
        output.putInt(stringOffset);
        output.position(end);
        output.flip();
        return output;
    }
}

