/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import shadow.bundletool.com.android.ddmlib.ByteBufferUtil;
import shadow.bundletool.com.android.ddmlib.ChunkHandler;
import shadow.bundletool.com.android.ddmlib.Client;
import shadow.bundletool.com.android.ddmlib.ClientData;
import shadow.bundletool.com.android.ddmlib.Log;
import shadow.bundletool.com.android.ddmlib.MonitorThread;

final class HandleAppName
extends ChunkHandler {
    public static final int CHUNK_APNM = ChunkHandler.type("APNM");
    private static final HandleAppName mInst = new HandleAppName();

    private HandleAppName() {
    }

    public static void register(MonitorThread mt) {
        mt.registerChunkHandler(CHUNK_APNM, mInst);
    }

    @Override
    public void clientReady(Client client) throws IOException {
    }

    @Override
    public void clientDisconnected(Client client) {
    }

    @Override
    public void handleChunk(Client client, int type, ByteBuffer data2, boolean isReply, int msgId) {
        Log.d("ddm-appname", "handling " + ChunkHandler.name(type));
        if (type == CHUNK_APNM) {
            assert (!isReply);
            HandleAppName.handleAPNM(client, data2);
        } else {
            this.handleUnknownChunk(client, type, data2, isReply, msgId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleAPNM(Client client, ByteBuffer data2) {
        ClientData cd;
        int appNameLen = data2.getInt();
        String appName = ByteBufferUtil.getString(data2, appNameLen);
        int userId = -1;
        boolean validUserId = false;
        if (data2.hasRemaining()) {
            try {
                userId = data2.getInt();
                validUserId = true;
            }
            catch (BufferUnderflowException e) {
                int expectedPacketLength = 8 + appNameLen * 2;
                Log.e("ddm-appname", "Insufficient data in APNM chunk to retrieve user id.");
                Log.e("ddm-appname", "Actual chunk length: " + data2.capacity());
                Log.e("ddm-appname", "Expected chunk length: " + expectedPacketLength);
            }
        }
        Log.d("ddm-appname", "APNM: app='" + appName + "'");
        ClientData clientData = cd = client.getClientData();
        synchronized (clientData) {
            cd.setClientDescription(appName);
            if (validUserId) {
                cd.setUserId(userId);
            }
        }
        client = HandleAppName.checkDebuggerPortForAppName(client, appName);
        if (client != null) {
            client.update(1);
        }
    }
}

