/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.utils.Reporter;

@Keep
public class AssertionsConfiguration {
    private final AssertionTransformation transformation;
    private final AssertionTransformationScope scope;
    private final String value;

    AssertionsConfiguration(AssertionTransformation transformation, AssertionTransformationScope scope, String value) {
        this.transformation = transformation;
        this.scope = scope;
        this.value = value;
    }

    public AssertionTransformation getTransformation() {
        return this.transformation;
    }

    public AssertionTransformationScope getScope() {
        return this.scope;
    }

    public String getValue() {
        return this.value;
    }

    static Builder builder(Reporter reporter) {
        return new Builder(reporter);
    }

    @Keep
    public static class Builder {
        Reporter reporter;
        private AssertionTransformation transformation;
        private AssertionTransformationScope scope;
        private String value;

        private Builder(Reporter reporter) {
            this.reporter = reporter;
        }

        public Builder setTransformation(AssertionTransformation transformation) {
            this.transformation = transformation;
            return this;
        }

        public Builder setEnable() {
            this.setTransformation(AssertionTransformation.ENABLE);
            return this;
        }

        public Builder setDisable() {
            this.setTransformation(AssertionTransformation.DISABLE);
            return this;
        }

        public Builder setPassthrough() {
            this.setTransformation(AssertionTransformation.PASSTHROUGH);
            return this;
        }

        public Builder setScopeAll() {
            this.scope = AssertionTransformationScope.ALL;
            this.value = null;
            return this;
        }

        public Builder setScopePackage(String packageName) {
            this.scope = AssertionTransformationScope.PACKAGE;
            this.value = packageName;
            return this;
        }

        public Builder setScopeClass(String className) {
            this.scope = AssertionTransformationScope.CLASS;
            this.value = className;
            return this;
        }

        public AssertionsConfiguration build() {
            if (this.transformation == null) {
                this.reporter.error("No transformation specified for building AccertionConfiguration");
            }
            if (this.scope == null) {
                this.reporter.error("No scope specified for building AccertionConfiguration");
            }
            if (this.scope == AssertionTransformationScope.PACKAGE && this.value == null) {
                this.reporter.error("No package name specified for building AccertionConfiguration");
            }
            if (this.scope == AssertionTransformationScope.CLASS && this.value == null) {
                this.reporter.error("No class name specified for building AccertionConfiguration");
            }
            return new AssertionsConfiguration(this.transformation, this.scope, this.value);
        }

        public static AssertionsConfiguration enableAllAssertions(Builder builder) {
            return builder.setEnable().setScopeAll().build();
        }

        public static AssertionsConfiguration disableAllAssertions(Builder builder) {
            return builder.setDisable().setScopeAll().build();
        }

        public static AssertionsConfiguration passthroughAllAssertions(Builder builder) {
            return builder.setPassthrough().setScopeAll().build();
        }
    }

    public static enum AssertionTransformationScope {
        ALL,
        PACKAGE,
        CLASS;

    }

    @Keep
    public static enum AssertionTransformation {
        ENABLE,
        DISABLE,
        PASSTHROUGH;

    }
}

