/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.dex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.ByteBufferProvider;
import shadow.bundletool.com.android.tools.r8.ByteDataView;
import shadow.bundletool.com.android.tools.r8.DataDirectoryResource;
import shadow.bundletool.com.android.tools.r8.DataEntryResource;
import shadow.bundletool.com.android.tools.r8.DataResourceConsumer;
import shadow.bundletool.com.android.tools.r8.DataResourceProvider;
import shadow.bundletool.com.android.tools.r8.DexFilePerClassFileConsumer;
import shadow.bundletool.com.android.tools.r8.DexIndexedConsumer;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.ProgramConsumer;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ObjectArrays;
import shadow.bundletool.com.android.tools.r8.dex.ClassesChecksum;
import shadow.bundletool.com.android.tools.r8.dex.CodeToKeep;
import shadow.bundletool.com.android.tools.r8.dex.FileWriter;
import shadow.bundletool.com.android.tools.r8.dex.Marker;
import shadow.bundletool.com.android.tools.r8.dex.MethodToCodeObjectMapping;
import shadow.bundletool.com.android.tools.r8.dex.MixedSectionCollection;
import shadow.bundletool.com.android.tools.r8.dex.ResourceAdapter;
import shadow.bundletool.com.android.tools.r8.dex.VirtualFile;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.features.FeatureSplitConfiguration;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationDirectory;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexCode;
import shadow.bundletool.com.android.tools.r8.graph.DexDebugInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedArray;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexTypeList;
import shadow.bundletool.com.android.tools.r8.graph.DexValue;
import shadow.bundletool.com.android.tools.r8.graph.EnclosingMethodAttribute;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.graph.InnerClassAttribute;
import shadow.bundletool.com.android.tools.r8.graph.ObjectToOffsetMapping;
import shadow.bundletool.com.android.tools.r8.graph.ParameterAnnotationsList;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.naming.ProguardMapSupplier;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.ExceptionUtils;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;

public class ApplicationWriter {
    public final DexApplication application;
    public final AppView<?> appView;
    public final GraphLense graphLense;
    public final NamingLens namingLens;
    public final InternalOptions options;
    private final CodeToKeep desugaredLibraryCodeToKeep;
    public List<Marker> markers;
    public List<DexString> markerStrings;
    public DexIndexedConsumer programConsumer;
    public final ProguardMapSupplier proguardMapSupplier;

    public ApplicationWriter(DexApplication application, AppView<?> appView, InternalOptions options, List<Marker> markers, GraphLense graphLense, NamingLens namingLens, ProguardMapSupplier proguardMapSupplier) {
        this(application, appView, options, markers, graphLense, namingLens, proguardMapSupplier, null);
    }

    public ApplicationWriter(DexApplication application, AppView<?> appView, InternalOptions options, List<Marker> markers, GraphLense graphLense, NamingLens namingLens, ProguardMapSupplier proguardMapSupplier, DexIndexedConsumer consumer) {
        assert (application != null);
        this.application = application;
        this.appView = appView;
        assert (options != null);
        this.options = options;
        this.desugaredLibraryCodeToKeep = CodeToKeep.createCodeToKeep(options, namingLens);
        this.markers = markers;
        this.graphLense = graphLense;
        this.namingLens = namingLens;
        this.proguardMapSupplier = proguardMapSupplier;
        this.programConsumer = consumer;
    }

    private Iterable<VirtualFile> distribute(ExecutorService executorService) throws ExecutionException, IOException {
        VirtualFile.Distributor distributor = this.options.isGeneratingDexFilePerClassFile() ? new VirtualFile.FilePerInputClassDistributor(this, this.options.getDexFilePerClassFileConsumer().combineSyntheticClassesWithPrimaryClass()) : (!this.options.canUseMultidex() && this.options.mainDexKeepRules.isEmpty() && this.application.mainDexList.isEmpty() && this.options.enableMainDexListCheck ? new VirtualFile.MonoDexDistributor(this, this.options) : new VirtualFile.FillFilesDistributor(this, this.options, executorService));
        Collection<VirtualFile> result = ((VirtualFile.Distributor)distributor).run();
        return result;
    }

    private void encodeChecksums(Iterable<VirtualFile> files) {
        List<DexProgramClass> classes = this.application.classes();
        Reference2LongOpenHashMap<DexString> inputChecksums = new Reference2LongOpenHashMap<DexString>(classes.size());
        for (DexProgramClass clazz : classes) {
            inputChecksums.put(clazz.getType().descriptor, clazz.getChecksum());
        }
        for (VirtualFile file : files) {
            ClassesChecksum toWrite = new ClassesChecksum();
            for (DexProgramClass clazz : file.classes()) {
                DexString desc = clazz.type.descriptor;
                toWrite.addChecksum(desc.toString(), inputChecksums.getLong(desc));
            }
            file.injectString(this.application.dexItemFactory.createString(toWrite.toJsonString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ExecutorService executorService) throws IOException, ExecutionException {
        this.application.timing.begin("DexApplication.write");
        ProguardMapSupplier.ProguardMapAndId proguardMapAndId = null;
        if (this.proguardMapSupplier != null && this.options.proguardMapConsumer != null) {
            proguardMapAndId = this.proguardMapSupplier.getProguardMapAndId();
        }
        assert (proguardMapAndId == null || this.markers != null && this.markers.size() == 1);
        if (this.markers != null && !this.markers.isEmpty()) {
            if (proguardMapAndId != null) {
                this.markers.get(0).setPgMapId(proguardMapAndId.id);
            }
            this.markerStrings = new ArrayList<DexString>(this.markers.size());
            for (Marker marker : this.markers) {
                this.markerStrings.add(this.application.dexItemFactory.createString(marker.toString()));
            }
        }
        try {
            this.insertAttributeAnnotations();
            ArrayList<Future<Boolean>> dexDataFutures = new ArrayList<Future<Boolean>>();
            Iterable<VirtualFile> virtualFiles = this.distribute(executorService);
            if (this.options.encodeChecksums) {
                this.encodeChecksums(virtualFiles);
            }
            this.application.dexItemFactory.sort(this.namingLens);
            assert (this.markers == null || this.markers.isEmpty() || this.application.dexItemFactory.extractMarkers() != null);
            SortAnnotations sortAnnotations = new SortAnnotations();
            this.application.classes().forEach(clazz -> clazz.addDependencies(sortAnnotations));
            for (VirtualFile virtualFile : virtualFiles) {
                if (virtualFile.isEmpty()) continue;
                dexDataFutures.add(executorService.submit(() -> {
                    ProgramConsumer byteBufferProvider;
                    ProgramConsumer consumer;
                    if (this.programConsumer != null) {
                        consumer = this.programConsumer;
                        byteBufferProvider = this.programConsumer;
                    } else if (virtualFile.getPrimaryClassDescriptor() != null) {
                        consumer = this.options.getDexFilePerClassFileConsumer();
                        byteBufferProvider = this.options.getDexFilePerClassFileConsumer();
                    } else if (virtualFile.getFeatureSplit() != null) {
                        ProgramConsumer featureConsumer = virtualFile.getFeatureSplit().getProgramConsumer();
                        assert (featureConsumer instanceof DexIndexedConsumer);
                        consumer = featureConsumer;
                        byteBufferProvider = (DexIndexedConsumer)featureConsumer;
                    } else {
                        consumer = this.options.getDexIndexedConsumer();
                        byteBufferProvider = this.options.getDexIndexedConsumer();
                    }
                    ObjectToOffsetMapping objectMapping = virtualFile.computeMapping(this.application);
                    MethodToCodeObjectMapping codeMapping = this.rewriteCodeWithJumboStrings(objectMapping, virtualFile.classes(), this.application);
                    FileWriter.ByteBufferResult result = this.writeDexFile(objectMapping, codeMapping, (ByteBufferProvider)((Object)byteBufferProvider));
                    ByteDataView data2 = new ByteDataView(result.buffer.array(), result.buffer.arrayOffset(), result.length);
                    if (consumer instanceof DexFilePerClassFileConsumer) {
                        ((DexFilePerClassFileConsumer)consumer).accept(virtualFile.getPrimaryClassDescriptor(), data2, virtualFile.getClassDescriptors(), (DiagnosticsHandler)this.options.reporter);
                    } else {
                        consumer.accept(virtualFile.getId(), data2, virtualFile.getClassDescriptors(), this.options.reporter);
                    }
                    data2.invalidate();
                    byteBufferProvider.releaseByteBuffer(result.buffer.asByteBuffer());
                    return true;
                }));
            }
            ThreadUtils.awaitFutures(dexDataFutures);
            if (this.options.desugaredLibraryKeepRuleConsumer != null && !this.desugaredLibraryCodeToKeep.isNop()) {
                assert (!this.options.isDesugaredLibraryCompilation());
                this.desugaredLibraryCodeToKeep.generateKeepRules(this.options);
            }
            this.options.reporter.failIfPendingErrors();
            ApplicationWriter.supplyAdditionalConsumers(this.application, this.appView, this.graphLense, this.namingLens, this.options, proguardMapAndId == null ? null : proguardMapAndId.map);
        }
        finally {
            this.application.timing.end();
        }
    }

    public static void supplyAdditionalConsumers(DexApplication application, AppView<?> appView, GraphLense graphLense, NamingLens namingLens, InternalOptions options, String proguardMapContent) {
        DataResourceConsumer dataResourceConsumer;
        if (options.configurationConsumer != null) {
            ExceptionUtils.withConsumeResourceHandler(options.reporter, options.configurationConsumer, options.getProguardConfiguration().getParsedConfiguration());
            ExceptionUtils.withFinishedResourceHandler(options.reporter, options.configurationConsumer);
        }
        if (proguardMapContent != null) {
            assert (ApplicationWriter.validateProguardMapParses(proguardMapContent));
            ExceptionUtils.withConsumeResourceHandler(options.reporter, options.proguardMapConsumer, proguardMapContent);
            ExceptionUtils.withFinishedResourceHandler(options.reporter, options.proguardMapConsumer);
        }
        if (options.mainDexListConsumer != null) {
            ExceptionUtils.withConsumeResourceHandler(options.reporter, options.mainDexListConsumer, ApplicationWriter.writeMainDexList(application, namingLens));
            ExceptionUtils.withFinishedResourceHandler(options.reporter, options.mainDexListConsumer);
        }
        if ((dataResourceConsumer = options.dataResourceConsumer) != null) {
            ImmutableList<DataResourceProvider> dataResourceProviders = application.dataResourceProviders;
            ResourceAdapter resourceAdapter = new ResourceAdapter(appView, application.dexItemFactory, graphLense, namingLens, options);
            ApplicationWriter.adaptAndPassDataResources(options, dataResourceConsumer, dataResourceProviders, resourceAdapter);
            if (!appView.appServices().isEmpty()) {
                appView.appServices().visit((service, implementations) -> {
                    String serviceName = DescriptorUtils.descriptorToJavaType(namingLens.lookupDescriptor((DexType)service).toString());
                    dataResourceConsumer.accept(DataEntryResource.fromBytes(StringUtils.lines(implementations.stream().map(namingLens::lookupDescriptor).map(DexString::toString).map(DescriptorUtils::descriptorToJavaType).collect(Collectors.toList())).getBytes(), "META-INF/services/" + serviceName, Origin.unknown()), (DiagnosticsHandler)options.reporter);
                });
            }
        }
        if (options.featureSplitConfiguration != null) {
            for (FeatureSplitConfiguration.DataResourceProvidersAndConsumer entry : options.featureSplitConfiguration.getDataResourceProvidersAndConsumers()) {
                ResourceAdapter resourceAdapter = new ResourceAdapter(appView, application.dexItemFactory, graphLense, namingLens, options);
                ApplicationWriter.adaptAndPassDataResources(options, entry.getConsumer(), entry.getProviders(), resourceAdapter);
            }
        }
    }

    private static void adaptAndPassDataResources(final InternalOptions options, final DataResourceConsumer dataResourceConsumer, Collection<DataResourceProvider> dataResourceProviders, final ResourceAdapter resourceAdapter) {
        final HashSet generatedResourceNames = new HashSet();
        for (DataResourceProvider dataResourceProvider : dataResourceProviders) {
            try {
                dataResourceProvider.accept(new DataResourceProvider.Visitor(){

                    @Override
                    public void visit(DataDirectoryResource directory) {
                        DataDirectoryResource adapted = resourceAdapter.adaptIfNeeded(directory);
                        if (adapted != null) {
                            dataResourceConsumer.accept(adapted, (DiagnosticsHandler)options.reporter);
                            options.reporter.failIfPendingErrors();
                        }
                    }

                    @Override
                    public void visit(DataEntryResource file) {
                        if (resourceAdapter.isService(file)) {
                            return;
                        }
                        DataEntryResource adapted = resourceAdapter.adaptIfNeeded(file);
                        if (generatedResourceNames.add(adapted.getName())) {
                            dataResourceConsumer.accept(adapted, (DiagnosticsHandler)options.reporter);
                        } else {
                            options.reporter.warning(new StringDiagnostic("Resource '" + file.getName() + "' already exists."));
                        }
                        options.reporter.failIfPendingErrors();
                    }
                });
            }
            catch (ResourceException e) {
                throw new CompilationError(e.getMessage(), e);
            }
        }
    }

    private static boolean validateProguardMapParses(String content) {
        try {
            ClassNameMapper.mapperFromString(content);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void insertAttributeAnnotations() {
        for (DexProgramClass clazz : this.application.classes()) {
            EnclosingMethodAttribute enclosingMethod = clazz.getEnclosingMethod();
            List<InnerClassAttribute> innerClasses = clazz.getInnerClasses();
            if (enclosingMethod == null && innerClasses.isEmpty()) continue;
            ArrayList<DexAnnotation> annotations = new ArrayList<DexAnnotation>(1 + innerClasses.size());
            if (enclosingMethod != null) {
                if (enclosingMethod.getEnclosingMethod() != null) {
                    annotations.add(DexAnnotation.createEnclosingMethodAnnotation(enclosingMethod.getEnclosingMethod(), this.options.itemFactory));
                } else {
                    annotations.add(DexAnnotation.createEnclosingClassAnnotation(enclosingMethod.getEnclosingClass(), this.options.itemFactory));
                }
            }
            if (!innerClasses.isEmpty()) {
                ArrayList<DexType> memberClasses = new ArrayList<DexType>(innerClasses.size());
                for (InnerClassAttribute innerClass : innerClasses) {
                    if (clazz.type == innerClass.getInner()) {
                        if (enclosingMethod == null && (innerClass.getOuter() == null || innerClass.isAnonymous())) {
                            this.options.warningMissingEnclosingMember(clazz.type, clazz.origin, clazz.getInitialClassFileVersion());
                            continue;
                        }
                        annotations.add(DexAnnotation.createInnerClassAnnotation(this.namingLens.lookupInnerName(innerClass, this.options), innerClass.getAccess(), this.options.itemFactory));
                        if (innerClass.getOuter() == null || !innerClass.isNamed()) continue;
                        annotations.add(DexAnnotation.createEnclosingClassAnnotation(innerClass.getOuter(), this.options.itemFactory));
                        continue;
                    }
                    if (clazz.type != innerClass.getOuter() || !innerClass.isNamed()) continue;
                    memberClasses.add(innerClass.getInner());
                }
                if (!memberClasses.isEmpty()) {
                    annotations.add(DexAnnotation.createMemberClassesAnnotation(memberClasses, this.options.itemFactory));
                }
            }
            if (!annotations.isEmpty()) {
                DexAnnotation[] copy = ObjectArrays.concat(clazz.annotations.annotations, annotations.toArray(DexAnnotation.EMPTY_ARRAY), DexAnnotation.class);
                clazz.annotations = new DexAnnotationSet(copy);
            }
            clazz.clearEnclosingMethod();
            clazz.clearInnerClasses();
        }
    }

    private MethodToCodeObjectMapping rewriteCodeWithJumboStrings(ObjectToOffsetMapping mapping, Collection<DexProgramClass> classes, DexApplication application) {
        if (!this.options.testing.forceJumboStringProcessing) {
            if (!mapping.hasJumboStrings()) {
                return MethodToCodeObjectMapping.fromMethodBacking();
            }
            if (application.highestSortingString != null && application.highestSortingString.slowCompareTo(mapping.getFirstJumboString()) < 0) {
                return MethodToCodeObjectMapping.fromMethodBacking();
            }
        }
        IdentityHashMap<DexEncodedMethod, DexCode> codeMapping = new IdentityHashMap<DexEncodedMethod, DexCode>();
        for (DexProgramClass clazz : classes) {
            boolean isSharedSynthetic = clazz.getSynthesizedFrom().size() > 1;
            clazz.forEachMethod(method -> {
                DexCode code = method.rewriteCodeWithJumboStrings(mapping, application.dexItemFactory, this.options.testing.forceJumboStringProcessing);
                codeMapping.put((DexEncodedMethod)method, code);
                if (!isSharedSynthetic) {
                    method.removeCode();
                }
            });
        }
        return MethodToCodeObjectMapping.fromMapBacking(codeMapping);
    }

    private FileWriter.ByteBufferResult writeDexFile(ObjectToOffsetMapping objectMapping, MethodToCodeObjectMapping codeMapping, ByteBufferProvider provider) {
        FileWriter fileWriter = new FileWriter(provider, objectMapping, codeMapping, this.application, this.options, this.namingLens, this.desugaredLibraryCodeToKeep);
        fileWriter.collect();
        return fileWriter.generate();
    }

    private static String mapMainDexListName(DexType type, NamingLens namingLens) {
        return DescriptorUtils.descriptorToJavaType(namingLens.lookupDescriptor(type).toString()).replace('.', '/') + ".class";
    }

    private static String writeMainDexList(DexApplication application, NamingLens namingLens) {
        StringBuilder builder = new StringBuilder();
        ArrayList<DexType> list = new ArrayList<DexType>(application.mainDexList);
        list.sort(DexType::slowCompareTo);
        list.forEach(type -> builder.append(ApplicationWriter.mapMainDexListName(type, namingLens)).append('\n'));
        return builder.toString();
    }

    private static class SortAnnotations
    extends MixedSectionCollection {
        private SortAnnotations() {
        }

        @Override
        public boolean add(DexAnnotationSet dexAnnotationSet) {
            dexAnnotationSet.sort();
            return true;
        }

        @Override
        public boolean add(DexAnnotation annotation) {
            annotation.annotation.sort();
            return true;
        }

        @Override
        public boolean add(DexEncodedArray dexEncodedArray) {
            for (DexValue value : dexEncodedArray.values) {
                value.sort();
            }
            return true;
        }

        @Override
        public boolean add(DexProgramClass dexClassData) {
            return true;
        }

        @Override
        public boolean add(DexCode dexCode) {
            return true;
        }

        @Override
        public boolean add(DexDebugInfo dexDebugInfo) {
            return true;
        }

        @Override
        public boolean add(DexTypeList dexTypeList) {
            return true;
        }

        @Override
        public boolean add(ParameterAnnotationsList parameterAnnotationsList) {
            return true;
        }

        @Override
        public boolean setAnnotationsDirectoryForClass(DexProgramClass clazz, DexAnnotationDirectory annotationDirectory) {
            return true;
        }
    }
}

