/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import shadow.bundletool.com.android.tools.r8.dex.IndexedItemCollection;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.EnclosingMethodAttribute;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.ClassWriter;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;

public class InnerClassAttribute {
    private final int access;
    private final DexType inner;
    private final DexType outer;
    private final DexString innerName;

    public static InnerClassAttribute createUnknownNamedInnerClass(DexType inner, DexType outer) {
        return new InnerClassAttribute(0, inner, outer, DexItemFactory.unknownTypeName);
    }

    public InnerClassAttribute(int access, DexType inner, DexType outer, DexString innerName) {
        assert (inner != null);
        this.access = access;
        this.inner = inner;
        this.outer = outer;
        this.innerName = innerName;
    }

    public boolean isNamed() {
        return this.innerName != null;
    }

    public boolean isAnonymous() {
        return this.innerName == null;
    }

    public int getAccess() {
        return this.access;
    }

    public DexType getInner() {
        return this.inner;
    }

    public DexType getOuter() {
        return this.outer;
    }

    public DexString getInnerName() {
        return this.innerName;
    }

    public void write(ClassWriter writer, NamingLens lens, InternalOptions options) {
        String internalName = lens.lookupInternalName(this.inner);
        writer.visitInnerClass(internalName, this.outer == null ? null : lens.lookupInternalName(this.outer), this.innerName == null ? null : lens.lookupInnerName(this, options).toString(), this.access);
    }

    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        this.inner.collectIndexedItems(indexedItems);
        if (this.outer != null) {
            this.outer.collectIndexedItems(indexedItems);
        }
        if (this.innerName != null) {
            this.innerName.collectIndexedItems(indexedItems);
        }
    }

    public DexType getLiveContext(AppInfoWithLiveness appInfo) {
        DexClass inner;
        DexType context = this.getOuter();
        if (context == null && (inner = appInfo.definitionFor(this.getInner())) != null && inner.getEnclosingMethod() != null) {
            EnclosingMethodAttribute enclosingMethodAttribute = inner.getEnclosingMethod();
            if (enclosingMethodAttribute.getEnclosingClass() != null) {
                context = enclosingMethodAttribute.getEnclosingClass();
            } else {
                DexMethod enclosingMethod = enclosingMethodAttribute.getEnclosingMethod();
                if (!appInfo.liveMethods.contains(enclosingMethod)) {
                    return null;
                }
                context = enclosingMethod.holder;
            }
        }
        return context;
    }

    public String toString() {
        return "[access : " + Integer.toHexString(this.access) + ", inner: " + this.inner.toDescriptorString() + ", outer: " + (this.outer == null ? "null" : this.outer.toDescriptorString()) + ", innerName: " + (this.innerName == null ? "(anonymous)" : this.innerName.toString()) + "]";
    }
}

