/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Streams;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinition;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.ResolutionResult;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.CatchHandlers;
import shadow.bundletool.com.android.tools.r8.ir.code.DominatorTree;
import shadow.bundletool.com.android.tools.r8.ir.code.FieldInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.InstanceGet;
import shadow.bundletool.com.android.tools.r8.ir.code.InstancePut;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeDirect;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeInterface;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeStatic;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeSuper;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeVirtual;
import shadow.bundletool.com.android.tools.r8.ir.code.NewInstance;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticPut;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.OptionalBool;

public class ClassInitializationAnalysis {
    private static final ClassInitializationAnalysis TRIVIAL = new ClassInitializationAnalysis(){

        @Override
        public boolean isClassDefinitelyLoadedBeforeInstruction(DexType type, Instruction instruction) {
            return false;
        }
    };
    private final AppView<AppInfoWithLiveness> appView;
    private final IRCode code;
    private final DexItemFactory dexItemFactory;
    private DominatorTree dominatorTree = null;
    private int markingColor = -1;

    private ClassInitializationAnalysis() {
        this.appView = null;
        this.code = null;
        this.dexItemFactory = null;
    }

    public ClassInitializationAnalysis(AppView<AppInfoWithLiveness> appView, IRCode code) {
        this.appView = appView;
        this.code = code;
        this.dexItemFactory = appView.dexItemFactory();
    }

    public static ClassInitializationAnalysis trivial() {
        return TRIVIAL;
    }

    public boolean isClassDefinitelyLoadedBeforeInstruction(DexType type, Instruction instruction) {
        Instruction previous;
        DexType context = this.code.method.method.holder;
        BasicBlock block = instruction.getBlock();
        Iterator<Object> iterator2 = block.getInstructions().iterator();
        while (iterator2.hasNext() && (previous = (Instruction)iterator2.next()) != instruction) {
            if (!previous.definitelyTriggersClassInitialization(type, context, this.appView, Query.DIRECTLY_OR_INDIRECTLY, AnalysisAssumption.INSTRUCTION_DOES_NOT_THROW)) continue;
            return true;
        }
        if (this.dominatorTree == null) {
            this.dominatorTree = new DominatorTree(this.code, DominatorTree.Assumption.MAY_HAVE_UNREACHABLE_BLOCKS);
        }
        block1: for (BasicBlock dominator : this.dominatorTree.dominatorBlocks(block, DominatorTree.Inclusive.NO)) {
            AnalysisAssumption assumption = this.getAssumptionForDominator(dominator, block);
            InstructionIterator instructionIterator = dominator.iterator();
            while (instructionIterator.hasNext()) {
                Instruction previous2 = (Instruction)instructionIterator.next();
                if (previous2.definitelyTriggersClassInitialization(type, context, this.appView, Query.DIRECTLY_OR_INDIRECTLY, assumption)) {
                    return true;
                }
                if (!dominator.hasCatchHandlers() || !previous2.instructionTypeCanThrow()) continue;
                assert (Streams.stream(instructionIterator).noneMatch(Instruction::instructionTypeCanThrow));
                continue block1;
            }
        }
        return false;
    }

    private AnalysisAssumption getAssumptionForDominator(BasicBlock dominator, BasicBlock block) {
        if (!dominator.hasCatchHandlers()) {
            return AnalysisAssumption.INSTRUCTION_DOES_NOT_THROW;
        }
        Instruction exceptionalExit = dominator.exceptionalExit();
        if (exceptionalExit == null) {
            return AnalysisAssumption.INSTRUCTION_DOES_NOT_THROW;
        }
        if (this.markingColor < 0) {
            this.markingColor = this.code.reserveMarkingColor();
            this.code.markTransitivePredecessors(block, this.markingColor);
        }
        for (CatchHandlers.CatchHandler<BasicBlock> catchHandler : dominator.getCatchHandlers()) {
            OptionalBool isCatchingInitError;
            OptionalBool isCatchingNPE;
            if (!((BasicBlock)catchHandler.target).isMarked(this.markingColor)) continue;
            DexType guard = catchHandler.guard;
            if ((exceptionalExit.isInstanceGet() || exceptionalExit.isInstancePut() || exceptionalExit.isInvokeMethodWithReceiver()) && (isCatchingNPE = this.appView.isSubtype(this.dexItemFactory.npeType, guard)).isPossiblyTrue()) {
                return AnalysisAssumption.NONE;
            }
            if (!exceptionalExit.isStaticGet() && !exceptionalExit.isStaticPut() && !exceptionalExit.isInvokeStatic() || !(isCatchingInitError = this.appView.isSubtype(this.dexItemFactory.exceptionInInitializerErrorType, guard)).isPossiblyTrue()) continue;
            return AnalysisAssumption.NONE;
        }
        return AnalysisAssumption.INSTRUCTION_DOES_NOT_THROW;
    }

    public void notifyCodeHasChanged() {
        this.dominatorTree = null;
        this.returnMarkingColor();
    }

    public void finish() {
        this.returnMarkingColor();
    }

    private void returnMarkingColor() {
        if (this.markingColor >= 0) {
            this.code.returnMarkingColor(this.markingColor);
            this.markingColor = -1;
        }
    }

    public static class InstructionUtils {
        public static boolean forInstanceGet(InstanceGet instruction, DexType type, AppView<?> appView, Query mode, AnalysisAssumption assumption) {
            return InstructionUtils.forInstanceGetOrPut(instruction, type, appView, mode, assumption);
        }

        public static boolean forInstancePut(InstancePut instruction, DexType type, AppView<?> appView, Query mode, AnalysisAssumption assumption) {
            return InstructionUtils.forInstanceGetOrPut(instruction, type, appView, mode, assumption);
        }

        private static boolean forInstanceGetOrPut(FieldInstruction instruction, DexType type, AppView<?> appView, Query mode, AnalysisAssumption assumption) {
            DexEncodedField field;
            assert (instruction.isInstanceGet() || instruction.isInstancePut());
            if (assumption == AnalysisAssumption.NONE) {
                Value object;
                Value value = object = instruction.isInstanceGet() ? instruction.asInstanceGet().object() : instruction.asInstancePut().object();
                if (object.getTypeLattice().isNullable()) {
                    return false;
                }
            }
            return (field = ((AppInfo)appView.appInfo()).resolveField(instruction.getField())) != null && InstructionUtils.isTypeInitializedBy(type, field, appView, mode);
        }

        public static boolean forInvokeDirect(InvokeDirect instruction, DexType type, AppView<?> appView, Query mode, AnalysisAssumption assumption) {
            if (assumption == AnalysisAssumption.NONE && instruction.getReceiver().getTypeLattice().isNullable()) {
                return false;
            }
            DexEncodedMethod method = appView.definitionFor(instruction.getInvokedMethod());
            return method != null && InstructionUtils.isTypeInitializedBy(type, method, appView, mode);
        }

        public static boolean forInvokeInterface(InvokeInterface instruction, DexType type, DexType context, AppView<?> appView, Query mode, AnalysisAssumption assumption) {
            DexEncodedMethod singleTarget;
            if (assumption == AnalysisAssumption.NONE && instruction.getReceiver().getTypeLattice().isNullable()) {
                return false;
            }
            if (mode == Query.DIRECTLY) {
                return false;
            }
            if (((AppInfo)appView.appInfo()).hasLiveness() && (singleTarget = instruction.lookupSingleTarget(appView.withLiveness(), context)) != null) {
                return InstructionUtils.isTypeInitializedBy(type, singleTarget, appView, mode);
            }
            DexMethod method = instruction.getInvokedMethod();
            ResolutionResult resolutionResult = ((AppInfo)appView.appInfo()).resolveMethodOnInterface(method.holder, method);
            if (!resolutionResult.isSingleResolution()) {
                return false;
            }
            DexType holder = resolutionResult.getSingleTarget().method.holder;
            return appView.isSubtype(holder, type).isTrue();
        }

        public static boolean forInvokeStatic(InvokeStatic instruction, DexType type, AppView<?> appView, Query mode, AnalysisAssumption assumption) {
            if (assumption == AnalysisAssumption.NONE) {
                return false;
            }
            DexEncodedMethod method = appView.definitionFor(instruction.getInvokedMethod());
            return method != null && InstructionUtils.isTypeInitializedBy(type, method, appView, mode);
        }

        public static boolean forInvokeSuper(InvokeSuper instruction, DexType type, DexType context, AppView<?> appView, Query mode, AnalysisAssumption assumption) {
            DexEncodedMethod singleTarget;
            if (assumption == AnalysisAssumption.NONE && instruction.getReceiver().getTypeLattice().isNullable()) {
                return false;
            }
            if (mode == Query.DIRECTLY) {
                return false;
            }
            if (((AppInfo)appView.appInfo()).hasLiveness() && (singleTarget = instruction.lookupSingleTarget(appView.withLiveness(), context)) != null) {
                return InstructionUtils.isTypeInitializedBy(type, singleTarget, appView, mode);
            }
            DexMethod method = instruction.getInvokedMethod();
            DexClass enclosingClass = appView.definitionFor(method.holder);
            if (enclosingClass == null) {
                return false;
            }
            DexType superType = enclosingClass.superType;
            if (superType == null) {
                return false;
            }
            ResolutionResult resolutionResult = ((AppInfo)appView.appInfo()).resolveMethod(superType, method, instruction.itf);
            if (!resolutionResult.isSingleResolution()) {
                return false;
            }
            DexType holder = resolutionResult.getSingleTarget().method.holder;
            return appView.isSubtype(holder, type).isTrue();
        }

        public static boolean forInvokeVirtual(InvokeVirtual instruction, DexType type, DexType context, AppView<?> appView, Query mode, AnalysisAssumption assumption) {
            DexEncodedMethod singleTarget;
            if (assumption == AnalysisAssumption.NONE && instruction.getReceiver().getTypeLattice().isNullable()) {
                return false;
            }
            if (mode == Query.DIRECTLY) {
                return false;
            }
            if (((AppInfo)appView.appInfo()).hasLiveness() && (singleTarget = instruction.lookupSingleTarget(appView.withLiveness(), context)) != null) {
                return InstructionUtils.isTypeInitializedBy(type, singleTarget, appView, mode);
            }
            DexMethod method = instruction.getInvokedMethod();
            ResolutionResult resolutionResult = ((AppInfo)appView.appInfo()).resolveMethodOnClass(method.holder, method);
            if (!resolutionResult.isSingleResolution()) {
                return false;
            }
            DexType holder = resolutionResult.getSingleTarget().method.holder;
            return appView.isSubtype(holder, type).isTrue();
        }

        public static boolean forNewInstance(NewInstance instruction, DexType type, AppView<?> appView, Query mode, AnalysisAssumption assumption) {
            if (assumption == AnalysisAssumption.NONE) {
                return false;
            }
            DexClass clazz = appView.definitionFor(instruction.clazz);
            return clazz != null && InstructionUtils.isTypeInitializedBy(type, clazz, appView, mode);
        }

        public static boolean forStaticGet(StaticGet instruction, DexType type, AppView<?> appView, Query mode, AnalysisAssumption assumption) {
            return InstructionUtils.forStaticGetOrPut(instruction, type, appView, mode, assumption);
        }

        public static boolean forStaticPut(StaticPut instruction, DexType type, AppView<?> appView, Query mode, AnalysisAssumption assumption) {
            return InstructionUtils.forStaticGetOrPut(instruction, type, appView, mode, assumption);
        }

        private static boolean forStaticGetOrPut(FieldInstruction instruction, DexType type, AppView<?> appView, Query mode, AnalysisAssumption assumption) {
            assert (instruction.isStaticGet() || instruction.isStaticPut());
            if (assumption == AnalysisAssumption.NONE) {
                return false;
            }
            DexEncodedField field = ((AppInfo)appView.appInfo()).resolveField(instruction.getField());
            return field != null && InstructionUtils.isTypeInitializedBy(type, field, appView, mode);
        }

        private static boolean isTypeInitializedBy(DexType typeToBeInitialized, DexDefinition definition, AppView<?> appView, Query mode) {
            if (mode == Query.DIRECTLY) {
                if (definition.isDexClass()) {
                    return definition.asDexClass().type == typeToBeInitialized;
                }
                if (definition.isDexEncodedField()) {
                    return definition.asDexEncodedField().field.holder == typeToBeInitialized;
                }
                if (definition.isDexEncodedMethod()) {
                    return definition.asDexEncodedMethod().method.holder == typeToBeInitialized;
                }
                assert (false);
                return false;
            }
            Set<DexType> visited = Sets.newIdentityHashSet();
            ArrayDeque<DexType> worklist = new ArrayDeque<DexType>();
            if (definition.isDexClass()) {
                DexClass clazz = definition.asDexClass();
                InstructionUtils.enqueue(clazz.type, visited, worklist);
            } else if (definition.isDexEncodedField()) {
                DexEncodedField field = definition.asDexEncodedField();
                InstructionUtils.enqueue(field.field.holder, visited, worklist);
            } else if (definition.isDexEncodedMethod()) {
                DexEncodedMethod method = definition.asDexEncodedMethod();
                InstructionUtils.enqueue(method.method.holder, visited, worklist);
                InstructionUtils.enqueueInitializedClassesOnNormalExit(method, visited, worklist);
            } else assert (false);
            while (!worklist.isEmpty()) {
                DexEncodedMethod classInitializer;
                DexType typeKnownToBeInitialized = (DexType)worklist.removeFirst();
                assert (visited.contains(typeKnownToBeInitialized));
                if (appView.isSubtype(typeKnownToBeInitialized, typeToBeInitialized).isTrue()) {
                    return true;
                }
                DexClass clazz = appView.definitionFor(typeKnownToBeInitialized);
                if (clazz == null || (classInitializer = clazz.getClassInitializer()) == null) continue;
                InstructionUtils.enqueueInitializedClassesOnNormalExit(classInitializer, visited, worklist);
            }
            return false;
        }

        private static void enqueue(DexType type, Set<DexType> visited, Deque<DexType> worklist) {
            if (type.isClassType() && visited.add(type)) {
                worklist.add(type);
            }
        }

        private static void enqueueInitializedClassesOnNormalExit(DexEncodedMethod method, Set<DexType> visited, Deque<DexType> worklist) {
            for (DexType type : method.getOptimizationInfo().getInitializedClassesOnNormalExit()) {
                InstructionUtils.enqueue(type, visited, worklist);
            }
        }
    }

    public static enum Query {
        DIRECTLY,
        DIRECTLY_OR_INDIRECTLY;

    }

    public static enum AnalysisAssumption {
        INSTRUCTION_DOES_NOT_THROW,
        NONE;

    }
}

