/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.ArrayPut;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeDirect;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeNewArray;
import shadow.bundletool.com.android.tools.r8.ir.code.NewArrayEmpty;
import shadow.bundletool.com.android.tools.r8.ir.code.NewArrayFilledData;
import shadow.bundletool.com.android.tools.r8.ir.code.NewInstance;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticPut;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfo;
import shadow.bundletool.com.android.tools.r8.utils.ListUtils;
import shadow.bundletool.com.android.tools.r8.utils.LongInterval;

public class ValueMayDependOnEnvironmentAnalysis {
    private final AppView<?> appView;
    private final IRCode code;
    private final DexType context;
    private final Set<Value> knownNotToDependOnEnvironment = Sets.newIdentityHashSet();
    private final Set<Value> visited = Sets.newIdentityHashSet();
    private Map<DexEncodedField, List<StaticPut>> finalFieldPuts;

    public ValueMayDependOnEnvironmentAnalysis(AppView<?> appView, IRCode code) {
        this.appView = appView;
        this.code = code;
        this.context = code.method.method.holder;
    }

    public boolean valueMayDependOnEnvironment(Value value) {
        boolean result = this.valueMayDependOnEnvironment(value, Sets.newIdentityHashSet());
        assert (this.visited.isEmpty());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean valueMayDependOnEnvironment(Value value, Set<Value> assumedNotToDependOnEnvironment) {
        Value root = value.getAliasedValue();
        if (assumedNotToDependOnEnvironment.contains(root)) {
            return false;
        }
        if (this.knownNotToDependOnEnvironment.contains(root)) {
            return false;
        }
        if (!this.visited.add(root)) {
            return true;
        }
        try {
            if (root.isConstant()) {
                boolean bl = false;
                return bl;
            }
            if (this.isConstantArrayThroughoutMethod(root, assumedNotToDependOnEnvironment)) {
                boolean bl = false;
                return bl;
            }
            if (root.getAbstractValue(this.appView, this.context).isSingleEnumValue()) {
                boolean bl = false;
                return bl;
            }
            if (this.isNewInstanceWithoutEnvironmentDependentFields(root, assumedNotToDependOnEnvironment)) {
                boolean bl = false;
                return bl;
            }
            if (this.isAliasOfValueThatIsIndependentOfEnvironment(root, assumedNotToDependOnEnvironment)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            boolean changed = this.visited.remove(root);
            assert (changed);
        }
    }

    private boolean valueMayNotDependOnEnvironmentAssumingArrayDoesNotDependOnEnvironment(Value value, Value array, Set<Value> assumedNotToDependOnEnvironment) {
        assert (!value.hasAliasedValue());
        assert (!array.hasAliasedValue());
        if (assumedNotToDependOnEnvironment.add(array)) {
            boolean valueMayDependOnEnvironment = this.valueMayDependOnEnvironment(value, assumedNotToDependOnEnvironment);
            boolean changed = assumedNotToDependOnEnvironment.remove(array);
            assert (changed);
            return !valueMayDependOnEnvironment;
        }
        return !this.valueMayDependOnEnvironment(value, assumedNotToDependOnEnvironment);
    }

    public boolean isConstantArrayThroughoutMethod(Value value) {
        boolean result = this.isConstantArrayThroughoutMethod(value, Sets.newIdentityHashSet());
        assert (this.visited.isEmpty());
        return result;
    }

    private boolean isConstantArrayThroughoutMethod(Value value, Set<Value> assumedNotToDependOnEnvironment) {
        long size;
        Value root = value.getAliasedValue();
        if (root.isPhi()) {
            return false;
        }
        Instruction definition = root.definition;
        if (definition.isInvokeNewArray()) {
            InvokeNewArray invokeNewArray = definition.asInvokeNewArray();
            for (Value argument : invokeNewArray.arguments()) {
                if (argument.isConstant()) continue;
                return false;
            }
            size = invokeNewArray.arguments().size();
        } else if (definition.isNewArrayEmpty()) {
            NewArrayEmpty newArrayEmpty = definition.asNewArrayEmpty();
            Value sizeValue = newArrayEmpty.size().getAliasedValue();
            if (!sizeValue.hasValueRange()) {
                return false;
            }
            LongInterval sizeRange = sizeValue.getValueRange();
            if (!sizeRange.isSingleValue()) {
                return false;
            }
            size = sizeRange.getSingleValue();
        } else {
            return false;
        }
        if (size < 0L) {
            return false;
        }
        if (size == 0L) {
            return true;
        }
        Set<Value> arrayValues = Sets.newIdentityHashSet();
        Set<Instruction> consumedInstructions = Sets.newIdentityHashSet();
        for (Instruction instruction : definition.getBlock().instructionsAfter(definition)) {
            Value array;
            if (instruction.isArrayPut()) {
                ArrayPut arrayPut = instruction.asArrayPut();
                array = arrayPut.array().getAliasedValue();
                if (array != root) break;
                LongInterval indexRange = arrayPut.index().getValueRange();
                if (!indexRange.isSingleValue()) {
                    return false;
                }
                long index = indexRange.getSingleValue();
                if (index < 0L || index >= size) {
                    return false;
                }
                Value rhs = arrayPut.value().getAliasedValue();
                if (!this.valueMayNotDependOnEnvironmentAssumingArrayDoesNotDependOnEnvironment(rhs, root, assumedNotToDependOnEnvironment)) {
                    return false;
                }
                arrayValues.add(rhs);
                consumedInstructions.add(arrayPut);
                continue;
            }
            if (instruction.isNewArrayFilledData()) {
                NewArrayFilledData newArrayFilledData = instruction.asNewArrayFilledData();
                array = newArrayFilledData.src();
                if (array != root) break;
                consumedInstructions.add(newArrayFilledData);
                continue;
            }
            if (!instruction.instructionMayHaveSideEffects(this.appView, this.context)) continue;
            break;
        }
        if (this.valueMayBeMutatedBeforeMethodExit(root, assumedNotToDependOnEnvironment, consumedInstructions)) {
            return false;
        }
        if (assumedNotToDependOnEnvironment.isEmpty()) {
            this.knownNotToDependOnEnvironment.add(root);
            this.knownNotToDependOnEnvironment.addAll(arrayValues);
        }
        return true;
    }

    private boolean isNewInstanceWithoutEnvironmentDependentFields(Value value, Set<Value> assumedNotToDependOnEnvironment) {
        assert (!value.hasAliasedValue());
        if (value.isPhi() || !value.definition.isNewInstance()) {
            return false;
        }
        NewInstance newInstance = value.definition.asNewInstance();
        DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(newInstance.clazz));
        if (clazz == null) {
            return false;
        }
        InvokeMethod constructorInvoke = null;
        for (Instruction instruction : value.uniqueUsers()) {
            if (!instruction.isInvokeDirect()) continue;
            InvokeDirect invoke = instruction.asInvokeDirect();
            if (!this.appView.dexItemFactory().isConstructor(invoke.getInvokedMethod()) || invoke.getReceiver().getAliasedValue() != value) continue;
            if (constructorInvoke == null) {
                constructorInvoke = invoke;
                continue;
            }
            return false;
        }
        if (constructorInvoke == null) {
            return false;
        }
        DexEncodedMethod constructor = this.appView.definitionFor(constructorInvoke.getInvokedMethod());
        if (constructor == null) {
            return false;
        }
        if (clazz.hasInstanceFieldsDirectlyOrIndirectly(this.appView)) {
            InstanceInitializerInfo initializerInfo = constructor.getOptimizationInfo().getInstanceInitializerInfo();
            if (initializerInfo.instanceFieldInitializationMayDependOnEnvironment()) {
                return false;
            }
            for (int i = 1; i < constructorInvoke.arguments().size(); ++i) {
                Value argument = constructorInvoke.arguments().get(i);
                if (!this.valueMayDependOnEnvironment(argument, assumedNotToDependOnEnvironment)) continue;
                return false;
            }
            if (this.valueMayBeMutatedBeforeMethodExit(value, assumedNotToDependOnEnvironment, ImmutableSet.of(constructorInvoke))) {
                return false;
            }
        }
        if (assumedNotToDependOnEnvironment.isEmpty()) {
            this.knownNotToDependOnEnvironment.add(value);
        }
        return true;
    }

    private boolean valueMayBeMutatedBeforeMethodExit(Value value, Set<Value> assumedNotToDependOnEnvironment, Set<Instruction> whitelist) {
        assert (!value.hasAliasedValue());
        if (value.numberOfPhiUsers() > 0) {
            return true;
        }
        Set<Instruction> visited = Sets.newIdentityHashSet();
        for (Instruction user : value.uniqueUsers()) {
            ArrayPut arrayPut;
            if (whitelist.contains(user) || user.isArrayPut() && value == (arrayPut = user.asArrayPut()).value() && !this.valueMayDependOnEnvironment(arrayPut.array(), assumedNotToDependOnEnvironment)) continue;
            if (user.isStaticPut()) {
                StaticPut staticPut = user.asStaticPut();
                if (visited.contains(staticPut)) continue;
                for (Instruction instruction : this.code.getInstructionsReachableFrom(staticPut)) {
                    if (!visited.add(instruction)) continue;
                    if (instruction.isStaticPut()) {
                        StaticPut otherStaticPut = instruction.asStaticPut();
                        if (otherStaticPut.getField().holder == staticPut.getField().holder && instruction.instructionInstanceCanThrow(this.appView, this.context).cannotThrow()) continue;
                        return true;
                    }
                    if (!instruction.instructionMayTriggerMethodInvocation(this.appView, this.context) || !instruction.instructionMayHaveSideEffects(this.appView, this.context)) continue;
                    return true;
                }
                continue;
            }
            return false;
        }
        return false;
    }

    private boolean isAliasOfValueThatIsIndependentOfEnvironment(Value value, Set<Value> assumedNotToDependOnEnvironment) {
        if (this.code.method.isClassInitializer()) {
            assert (!value.hasAliasedValue());
            if (value.isPhi()) {
                return false;
            }
            Instruction definition = value.definition;
            if (definition.isStaticGet()) {
                StaticGet staticGet = definition.asStaticGet();
                DexEncodedField field = ((AppInfo)this.appView.appInfo()).resolveField(staticGet.getField());
                if (field != null && field.field.holder == this.context) {
                    List<StaticPut> finalFieldPuts = this.computeFinalFieldPuts().get(field);
                    if (finalFieldPuts == null || finalFieldPuts.size() != 1) {
                        return false;
                    }
                    StaticPut staticPut = ListUtils.first(finalFieldPuts);
                    return !this.valueMayDependOnEnvironment(staticPut.value(), assumedNotToDependOnEnvironment);
                }
            }
        }
        return false;
    }

    private Map<DexEncodedField, List<StaticPut>> computeFinalFieldPuts() {
        assert (this.code.method.isClassInitializer());
        if (this.finalFieldPuts == null) {
            this.finalFieldPuts = new IdentityHashMap<DexEncodedField, List<StaticPut>>();
            for (StaticPut staticPut : this.code.instructions(Instruction::isStaticPut)) {
                DexEncodedField field = ((AppInfo)this.appView.appInfo()).resolveField(staticPut.getField());
                if (field == null || field.field.holder != this.context || !field.isFinal()) continue;
                this.finalFieldPuts.computeIfAbsent(field, ignore -> new ArrayList()).add(staticPut);
            }
        }
        return this.finalFieldPuts;
    }
}

